/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core;

import com.google.gdt.eclipse.core.AbstractGwtPlugin;
import com.google.gdt.eclipse.core.PluginProperties;
import com.google.gdt.eclipse.core.markers.GdtProblemSeverities;
import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gdt.eclipse.core.sdk.UpdateWebInfFolderCommand;
import com.google.gdt.eclipse.core.sdk.WebInfFolderUpdater;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleResourceChangeListener;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleResourceDependencyIndex;
import com.google.gwt.eclipse.core.markers.ClientBundleProblemType;
import com.google.gwt.eclipse.core.markers.GWTProblemType;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import com.google.gwt.eclipse.core.sdk.GWTUpdateWebInfFolderCommand;
import com.google.gwt.eclipse.core.search.JavaRefIndex;
import com.google.gwt.eclipse.core.uibinder.model.reference.UiBinderReferenceManager;
import com.google.gwt.eclipse.core.uibinder.problems.UiBinderTemplateProblemType;
import com.google.gwt.eclipse.core.uibinder.problems.java.UiBinderJavaProblemType;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceProblemType;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.osgi.framework.BundleContext;

public class GWTPlugin
extends AbstractGwtPlugin {
    public static final String PLUGIN_ID = "com.gwtplugins.gwt.eclipse.core";
    public static final String SDK_DOWNLOAD_URL;
    private static GWTPlugin plugin;
    private final WebInfFolderUpdater webInfFolderUpdater = new WebInfFolderUpdater(){

        protected Sdk getSdk(IJavaProject javaProject) {
            return GwtSdk.findSdkFor(javaProject);
        }

        protected UpdateWebInfFolderCommand getUpdateCommand(IJavaProject javaProject, Sdk sdk) {
            return new GWTUpdateWebInfFolderCommand(javaProject, sdk);
        }
    };

    static {
        PluginProperties props = new PluginProperties(GWTPlugin.class);
        SDK_DOWNLOAD_URL = props.getProperty("gwtplugin.sdk_download_url", "http://www.gwtproject.org/download.html");
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = GWTPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return GWTPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static GWTPlugin getDefault() {
        return plugin;
    }

    public static String getName() {
        return (String)GWTPlugin.getDefault().getBundle().getHeaders().get("Bundle-Name");
    }

    public static String getVersion() {
        return (String)GWTPlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        GdtProblemSeverities.getInstance().addProblemTypeEnums(new Class[]{GWTProblemType.class, RemoteServiceProblemType.class, UiBinderJavaProblemType.class, ClientBundleProblemType.class, UiBinderTemplateProblemType.class});
        this.addLaunchListener();
        ClientBundleResourceChangeListener.addToWorkspace();
        UiBinderReferenceManager.INSTANCE.start();
        this.webInfFolderUpdater.start();
    }

    public void stop(BundleContext context) throws Exception {
        this.webInfFolderUpdater.stop();
        UiBinderReferenceManager.INSTANCE.stop();
        ClientBundleResourceDependencyIndex.save();
        JavaRefIndex.save();
        this.removeLaunchListener();
        InstanceScope.INSTANCE.getNode(PLUGIN_ID).flush();
        plugin = null;
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put("com.gwtplugins.gwt.eclipse.core.images.gwtIcon", this.imageDescriptorFromPath("icons/gwt_16x16.png"));
        reg.put(".images.sdmCodeServerImage", this.imageDescriptorFromPath("icons/gwt_codeserver_16x16.png"));
        reg.put(".images.compileImage", this.imageDescriptorFromPath("icons/gwt_compiler_16x16.png"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.gwtLogo", this.imageDescriptorFromPath("icons/gwt_75x46.png"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.javaIcon", this.imageDescriptorFromPath("icons/jcu_obj.gif"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.jsniDefaultMethodSmall", this.imageDescriptorFromPath("icons/methdef_obj.gif"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.jsniPrivateMethodSmall", this.imageDescriptorFromPath("icons/methpri_obj.gif"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.jsniProtectedMethodSmall", this.imageDescriptorFromPath("icons/methpro_obj.gif"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.jsniPublicMethodSmall", this.imageDescriptorFromPath("icons/methpub_obj.gif"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.newAsyncInterfaceLarge", this.imageDescriptorFromPath("icons/gwt-new-asyncinterface_large.png"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.newAsyncInterfaceSmall", this.imageDescriptorFromPath("icons/gwt-new-asyncinterface_small.png"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.editorSelectionInfo", this.imageDescriptorFromPath("icons/wordassist_co.gif"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.newEntryPointLarge", this.imageDescriptorFromPath("icons/gwt-new-entrypoint_large.png"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.newEntryPointSmall", this.imageDescriptorFromPath("icons/gwt-new-entrypoint_small.png"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.newHostPageLarge", this.imageDescriptorFromPath("icons/gwt-new-hostpage_large.png"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.newHostPageSmall", this.imageDescriptorFromPath("icons/gwt-new-hostpage_small.png"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.newModuleLarge", this.imageDescriptorFromPath("icons/gwt-new-module_large.png"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.newModuleSmall", this.imageDescriptorFromPath("icons/gwt-new-module_small.png"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.moduleIcon", this.imageDescriptorFromPath("icons/gwt-module-file_small.gif"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.gwtCompileLarge", this.imageDescriptorFromPath("icons/gwt_75x46.png"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.newClientBundleLarge", this.imageDescriptorFromPath("icons/gwt-new-clientbundle_large.png"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.newClientBundleSmall", this.imageDescriptorFromPath("icons/gwt-new-clientbundle_small.png"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.newUiBinderLarge", this.imageDescriptorFromPath("icons/gwt-new-uibinder_large.png"));
        reg.put("com.gwtplugins.gwt.eclipse.core.images.newUiBinderSmall", this.imageDescriptorFromPath("icons/gwt-new-uibinder_small.png"));
    }

    private void addLaunchListener() {
    }

    private void removeLaunchListener() {
    }
}

