/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core;

import com.google.gdt.eclipse.core.JavaProjectUtilities;
import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.runtime.GWTProjectsRuntime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public class GWTProjectUtilities {
    private static void fillGWTSourceFolderPathsFromProject(IJavaProject javaProject, Collection<? super IRuntimeClasspathEntry> sourceEntries, boolean includeTestSourceEntries) throws Sdk.SdkException {
        assert (javaProject != null);
        if (GWTProjectsRuntime.isGWTRuntimeProject(javaProject)) {
            sourceEntries.addAll(GWTProjectsRuntime.getGWTRuntimeProjectSourceEntries(javaProject, includeTestSourceEntries));
        } else {
            try {
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry curClasspathEntry = iClasspathEntryArray[n2];
                    if (curClasspathEntry.getEntryKind() == 3) {
                        IPath sourcePath = curClasspathEntry.getPath();
                        if (!(!includeTestSourceEntries && GWTProjectUtilities.isTestPath(sourcePath) || GWTProjectUtilities.isOptional(curClasspathEntry) && !GWTProjectUtilities.exists(sourcePath))) {
                            sourceEntries.add((IRuntimeClasspathEntry)JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)sourcePath));
                        }
                    }
                    ++n2;
                }
                IFolder folder = javaProject.getProject().getFolder("super");
                if (folder.exists()) {
                    sourceEntries.add((IRuntimeClasspathEntry)JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)folder.getFullPath()));
                }
            }
            catch (JavaModelException jme) {
                GWTPluginLog.logError(jme, "Unable to retrieve raw classpath for project " + javaProject.getProject().getName());
            }
        }
    }

    public static List<IRuntimeClasspathEntry> getGWTSourceFolderPathsFromProjectAndDependencies(IJavaProject javaProject, boolean includeTestSourceEntries) throws JavaModelException, Sdk.SdkException {
        ArrayList<IRuntimeClasspathEntry> sourceEntries = new ArrayList<IRuntimeClasspathEntry>();
        for (IJavaProject curJavaProject : JavaProjectUtilities.getTransitivelyRequiredProjects((IJavaProject)javaProject)) {
            GWTProjectUtilities.fillGWTSourceFolderPathsFromProject(curJavaProject, sourceEntries, includeTestSourceEntries);
        }
        return sourceEntries;
    }

    public static boolean isTestPath(IPath path) {
        String lastButTwo;
        String[] segments = path.segments();
        int length = segments.length;
        String last = length < 1 ? null : segments[length - 1];
        String lastButOne = length < 2 ? null : segments[length - 2];
        String string = lastButTwo = length < 3 ? null : segments[length - 3];
        return "test".equals(last) || "javatests".equals(last) || "src".equals(lastButTwo) && "test".equals(lastButOne);
    }

    private static boolean exists(IPath sourcePath) {
        return ResourcesPlugin.getWorkspace().getRoot().exists(sourcePath);
    }

    private static boolean isOptional(IClasspathEntry entry) {
        IClasspathAttribute[] attributes;
        IClasspathAttribute[] iClasspathAttributeArray = attributes = entry.getExtraAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            if ("optional".equals(attribute.getName()) && "true".equals(attribute.getValue())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

