/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.actions;

import com.google.gwt.eclipse.core.GWTPluginLog;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorAction
implements IEditorActionDelegate {
    private IEditorPart targetEditor;

    public void run(IAction action) {
        ITypedRegion[] types;
        if (this.targetEditor == null) {
            GWTPluginLog.logWarning("targetEditor is null");
            return;
        }
        IEditorInput editorInput = this.targetEditor.getEditorInput();
        IResource resource = (IResource)editorInput.getAdapter(IResource.class);
        ITextEditor javaEditor = (ITextEditor)this.targetEditor;
        ITextSelection sel = (ITextSelection)javaEditor.getSelectionProvider().getSelection();
        IDocument document = javaEditor.getDocumentProvider().getDocument((Object)javaEditor.getEditorInput());
        IDocumentExtension3 document3 = (IDocumentExtension3)document;
        IDocumentPartitioner gwtPartitioner = document3.getDocumentPartitioner("___gwt_partitioning");
        String[] partitionings = document3.getPartitionings();
        String partitioning = gwtPartitioner != null ? "___gwt_partitioning" : "___java_partitioning";
        try {
            types = TextUtilities.computePartitioning((IDocument)document, (String)partitioning, (int)sel.getOffset(), (int)sel.getLength(), (boolean)false);
        }
        catch (BadLocationException e) {
            GWTPluginLog.logError(e);
            return;
        }
        String msg = "File: " + resource.getName();
        msg = String.valueOf(msg) + "\nPartitionings: ";
        String[] stringArray = partitionings;
        int n = partitionings.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            msg = String.valueOf(msg) + "\n" + part;
            ++n2;
        }
        msg = String.valueOf(msg) + "\n\nContent types: ";
        stringArray = types;
        n = types.length;
        n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            msg = String.valueOf(msg) + "\n" + type.getType();
            ++n2;
        }
        msg = String.valueOf(msg) + "\n\nSelection range: (offset = " + sel.getOffset() + ", length = " + sel.getLength() + ")";
        MessageDialog.openInformation((Shell)this.targetEditor.getSite().getShell(), (String)"Selection Info", (String)msg);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }
}

