/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.actions;

import com.google.gdt.eclipse.core.AdapterUtilities;
import com.google.gdt.eclipse.core.ProcessUtilities;
import com.google.gdt.eclipse.core.WebAppUtilities;
import com.google.gdt.eclipse.core.console.CustomMessageConsole;
import com.google.gdt.eclipse.core.console.MessageConsoleUtilities;
import com.google.gdt.eclipse.core.console.TerminateAction;
import com.google.gdt.eclipse.core.console.TerminateProcessAction;
import com.google.gdt.eclipse.core.jobs.ProgressMonitorCanceledWatcher;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.compile.GWTCompileRunner;
import com.google.gwt.eclipse.core.compile.GWTCompileSettings;
import com.google.gwt.eclipse.core.compile.ui.GWTCompileDialog;
import com.google.gwt.eclipse.core.properties.GWTProjectProperties;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.service.prefs.BackingStoreException;

public class GWTCompileToolbarHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (!workbench.saveAllEditors(true)) {
            return null;
        }
        IProject initialProject = null;
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            IStructuredSelection selection = (IStructuredSelection)window.getSelectionService().getSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IAdaptable) {
                initialProject = (IProject)AdapterUtilities.getAdapter((Object)firstElement, IProject.class);
            }
        } else {
            return null;
        }
        GWTCompileDialog dialog = new GWTCompileDialog(Display.getDefault().getActiveShell(), initialProject);
        if (dialog.open() != 0) {
            return null;
        }
        final IProject project = dialog.getProject();
        final String taskName = GWTCompileRunner.computeTaskName(project);
        final GWTCompileSettings compileSettings = dialog.getCompileSettings();
        try {
            GWTProjectProperties.setGwtCompileSettings(project, compileSettings);
        }
        catch (BackingStoreException e) {
            GWTPluginLog.logError(e);
        }
        new WorkspaceJob(taskName){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IStatus iStatus;
                CustomMessageConsole messageConsole = MessageConsoleUtilities.getMessageConsole((String)taskName, null);
                TerminateProcessAction terminateAction = new TerminateProcessAction();
                messageConsole.setTerminateAction((TerminateAction)terminateAction);
                messageConsole.activate();
                MessageConsoleStream consoleOutputStream = messageConsole.newMessageStream();
                try {
                    IPath warLocation = null;
                    if (WebAppUtilities.isWebApp((IProject)project) && !compileSettings.getExtraArgs().contains("-war") && (warLocation = WebAppUtilities.getWarOutLocationOrPrompt((IProject)project)) == null) {
                        IStatus iStatus2 = Status.OK_STATUS;
                        return iStatus2;
                    }
                    GWTCompileRunner.compileWithCancellationSupport(JavaCore.create((IProject)project), warLocation, compileSettings, (OutputStream)consoleOutputStream, (ProcessUtilities.IProcessReceiver)terminateAction, monitor, (ProgressMonitorCanceledWatcher.Listener)terminateAction);
                    iStatus = Status.OK_STATUS;
                }
                catch (IOException e) {
                    GWTPluginLog.logError(e);
                    throw new CoreException((IStatus)new Status(4, "com.gwtplugins.gwt.eclipse.core", e.getLocalizedMessage(), (Throwable)e));
                }
                catch (InterruptedException e) {
                    GWTPluginLog.logError(e);
                    throw new CoreException((IStatus)new Status(4, "com.gwtplugins.gwt.eclipse.core", e.getLocalizedMessage(), (Throwable)e));
                }
                catch (OperationCanceledException e) {
                    IStatus iStatus3 = Status.OK_STATUS;
                    return iStatus3;
                }
                finally {
                    terminateAction.setEnabled(false);
                    try {
                        if (!$assertionsDisabled && consoleOutputStream == null) {
                            throw new AssertionError();
                        }
                        consoleOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return iStatus;
            }
        }.schedule();
        return null;
    }
}

