/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.applications;

import com.google.gwt.eclipse.core.editors.java.GWTDocumentSetupParticipant;
import com.google.gwt.eclipse.core.editors.java.JsniFormattingUtil;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.Workbench;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GWTCodeFormatterApplication
implements IApplication {
    private Properties javaConfig;
    private Properties jsConfig;

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        if (args.length < 3) {
            System.err.println("Usage: eclipse -application com.google.gwt.eclipse.core.formatter.GWTCodeFormatterApplication <javaFormatterConfigFile> <jsFormatterConfigFile> <sourceFile1> [<sourceFile2>] ...");
            return IApplication.EXIT_OK;
        }
        this.javaConfig = this.getConfig(args[0]);
        this.jsConfig = this.getConfig(args[1]);
        this.startWorkbench();
        int i = 2;
        while (i < args.length) {
            File f = new File(args[i]);
            this.format(f);
            ++i;
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }

    private void doFormat(File file) {
        Document doc = new Document();
        try {
            String contents = new String(Util.getFileCharContent((File)file, null));
            GWTDocumentSetupParticipant.setupGWTPartitioning((IDocument)doc);
            doc.set(contents);
            TextEdit edit = JsniFormattingUtil.format((IDocument)doc, this.javaConfig, this.jsConfig, null);
            if (edit == null) {
                System.err.println("Error formatting " + file.getAbsolutePath());
                return;
            }
            edit.apply((IDocument)doc);
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            try {
                out.write(doc.get());
                out.flush();
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void format(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.format(f);
                ++n2;
            }
        } else if (file.getName().endsWith(".java")) {
            this.doFormat(file);
        }
    }

    private Properties getConfig(String configFilename) throws Exception {
        InputStream stream = null;
        File f = new File(configFilename);
        try {
            stream = configFilename.endsWith(".xml") ? this.transformXmlToProperties(f) : new BufferedInputStream(new FileInputStream(f));
            Properties formatterOptions = new Properties();
            formatterOptions.load(stream);
            Properties properties = formatterOptions;
            return properties;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void startWorkbench() {
        PlatformUI.createAndRunWorkbench((Display)PlatformUI.createDisplay(), (WorkbenchAdvisor)new WorkbenchAdvisor(){

            public String getInitialWindowPerspectiveId() {
                return null;
            }

            public void postStartup() {
                Workbench.getInstance().close();
            }
        });
    }

    private InputStream transformXmlToProperties(File f) throws IOException, SAXException, ParserConfigurationException {
        StringBuilder sb = new StringBuilder((int)f.length());
        sb.append("#\n");
        org.w3c.dom.Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f);
        NodeList nodes = xml.getElementsByTagName("setting");
        int i = 0;
        while (i < nodes.getLength()) {
            Node n = nodes.item(i);
            String key = n.getAttributes().getNamedItem("id").getNodeValue();
            String value = n.getAttributes().getNamedItem("value").getNodeValue();
            sb.append(key);
            sb.append('=');
            sb.append(value);
            sb.append('\n');
            ++i;
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }
}

