/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.clientbundle;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gdt.eclipse.core.JavaUtilities;
import com.google.gdt.eclipse.core.ResourceUtils;
import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleUtilities;
import com.google.gwt.eclipse.core.clientbundle.GeneratedCssResource;
import com.google.gwt.eclipse.core.modules.ModuleUtils;
import com.google.gwt.eclipse.core.uibinder.UiBinderUtilities;
import com.google.gwt.eclipse.platform.clientbundle.ResourceTypeDefaultExtensions;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;

public class ClientBundleResource {
    private final IFile file;
    private final String methodName;
    private final String resourceTypeName;

    public static ClientBundleResource create(IFile file, String methodName, String resourceTypeName) {
        if (resourceTypeName.equals("com.google.gwt.resources.client.CssResource")) {
            return new GeneratedCssResource(file, methodName);
        }
        return new ClientBundleResource(file, methodName, resourceTypeName);
    }

    public static ClientBundleResource createFromFile(IJavaProject javaProject, IFile file) {
        if (!ClientBundleResource.isProbableClientBundleResource(file)) {
            return null;
        }
        String methodName = ClientBundleUtilities.suggestMethodName(file);
        String resourceTypeName = ClientBundleUtilities.suggestResourceTypeName(javaProject, file);
        return ClientBundleResource.create(file, methodName, resourceTypeName);
    }

    public static IStatus errorStatus(String message, Object ... args) {
        return StatusUtilities.newErrorStatus((String)message, (String)"com.gwtplugins.gwt.eclipse.core", (Object[])args);
    }

    public static boolean isProbableClientBundleResource(IFile file) {
        if (JavaCore.create((IFile)file) != null) {
            return false;
        }
        return !ModuleUtils.isModuleXml((IResource)file) && !UiBinderUtilities.isUiXml(file);
    }

    protected ClientBundleResource(IFile file, String methodName, String resourceTypeName) {
        this.file = file;
        this.methodName = methodName;
        this.resourceTypeName = resourceTypeName;
    }

    public void addToClientBundle(IType clientBundle, NewTypeWizardPage.ImportsManager imports, boolean addComments, IProgressMonitor monitor) throws CoreException {
        String methodSource = MessageFormat.format("{0} {1}();", Signature.getSimpleName((String)this.getReturnTypeName()), this.getMethodName());
        String sourceAnnotation = this.getSourceAnnotationValue(clientBundle);
        if (sourceAnnotation != null) {
            methodSource = String.valueOf(MessageFormat.format("@Source(\"{0}\")", sourceAnnotation)) + StubUtility.getLineDelimiterUsed((IJavaProject)clientBundle.getJavaProject()) + methodSource;
        }
        clientBundle.createMethod(methodSource, null, false, monitor);
        imports.addImport(this.getReturnTypeName());
    }

    public MethodDeclaration createMethodDeclaration(IType clientBundle, ASTRewrite astRewrite, ImportRewrite importRewrite, boolean addComments) throws CoreException {
        AST ast = astRewrite.getAST();
        MethodDeclaration methodDecl = ast.newMethodDeclaration();
        methodDecl.setName(ast.newSimpleName(this.getMethodName()));
        ITypeBinding resourceTypeBinding = JavaASTUtils.resolveType((IJavaProject)clientBundle.getJavaProject(), (String)this.getReturnTypeName());
        Type resourceType = importRewrite.addImport(resourceTypeBinding, ast);
        methodDecl.setReturnType2(resourceType);
        String sourceAnnotationValue = this.getSourceAnnotationValue(clientBundle);
        if (sourceAnnotationValue != null) {
            SingleMemberAnnotation sourceAnnotation = ast.newSingleMemberAnnotation();
            sourceAnnotation.setTypeName(ast.newName("Source"));
            StringLiteral annotationValue = ast.newStringLiteral();
            annotationValue.setLiteralValue(sourceAnnotationValue);
            sourceAnnotation.setValue((Expression)annotationValue);
            ChildListPropertyDescriptor modifiers = methodDecl.getModifiersProperty();
            ListRewrite modifiersRewriter = astRewrite.getListRewrite((ASTNode)methodDecl, modifiers);
            modifiersRewriter.insertFirst((ASTNode)sourceAnnotation, null);
        }
        return methodDecl;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClientBundleResource)) {
            return false;
        }
        ClientBundleResource other = (ClientBundleResource)obj;
        if (!JavaUtilities.equalsWithNullCheck((Object)this.methodName, (Object)other.methodName)) {
            return false;
        }
        if (!JavaUtilities.equalsWithNullCheck((Object)this.file, (Object)other.file)) {
            return false;
        }
        return JavaUtilities.equalsWithNullCheck((Object)this.resourceTypeName, (Object)other.resourceTypeName);
    }

    public IFile getFile() {
        return this.file;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getResourceTypeName() {
        return this.resourceTypeName;
    }

    public int hashCode() {
        int result = 17;
        if (this.methodName != null) {
            result = 37 * result + this.methodName.hashCode();
        }
        if (this.file != null) {
            result = 37 * result + this.file.hashCode();
        }
        if (this.resourceTypeName != null) {
            result = 37 * result + this.resourceTypeName.hashCode();
        }
        return result;
    }

    public IStatus validate(IJavaProject javaProject, String[] extendedInterfaces, String[] methodNames) {
        IStatus fileStatus = this.validateFile(javaProject);
        IStatus methodNameStatus = this.validateMethodName(javaProject, extendedInterfaces, methodNames);
        IStatus resourceTypeStatus = this.validateResourceTypeName(javaProject);
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{fileStatus, methodNameStatus, resourceTypeStatus});
    }

    protected String getReturnTypeName() {
        return this.resourceTypeName;
    }

    private String getSourceAnnotationValue(IType clientBundle) throws JavaModelException {
        IJavaProject javaProject = clientBundle.getJavaProject();
        assert (javaProject.isOnClasspath((IResource)this.file));
        IPackageFragment resourcePckg = javaProject.findPackageFragment(this.file.getParent().getFullPath());
        if (!clientBundle.getPackageFragment().equals(resourcePckg)) {
            return ResourceUtils.getClasspathRelativePath((IPackageFragment)resourcePckg, (String)this.file.getName()).toString();
        }
        String fileNameWithoutExt = ResourceUtils.filenameWithoutExtension((IFile)this.file);
        if (!ResourceUtils.areFilenamesEqual((String)fileNameWithoutExt, (String)this.methodName)) {
            return this.file.getName();
        }
        IType resourceType = JavaModelSearch.findType((IJavaProject)javaProject, (String)this.resourceTypeName);
        if (!this.hasDefaultExtension(this.file, resourceType)) {
            return this.file.getName();
        }
        return null;
    }

    private boolean hasDefaultExtension(IFile file, IType resourceType) throws JavaModelException {
        String fileExtension = "." + file.getFileExtension();
        String[] stringArray = ResourceTypeDefaultExtensions.getDefaultExtensions((IType)resourceType);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultExtension = stringArray[n2];
            if (ResourceUtils.areFilenamesEqual((String)fileExtension, (String)defaultExtension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isMethodAlreadyDefined(IJavaProject javaProject, String[] extendedInterfaces) throws JavaModelException {
        String[] stringArray = extendedInterfaces;
        int n = extendedInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            String extendedInterface = stringArray[n2];
            IType type = JavaModelSearch.findType((IJavaProject)javaProject, (String)extendedInterface);
            if (type != null) {
                ITypeHierarchy superHierarchy;
                IMethod method;
                boolean isInterface = false;
                try {
                    isInterface = type.isInterface();
                }
                catch (JavaModelException e) {
                    GWTPluginLog.logError(e);
                }
                if (isInterface && (method = JavaModelSearch.findMethodInHierarchy((ITypeHierarchy)(superHierarchy = type.newSupertypeHierarchy(null)), (IType)type, (String)this.methodName, (String[])new String[0])) != null) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private IStatus validateFile(IJavaProject javaProject) {
        if (this.file == null || !this.file.exists()) {
            return ClientBundleResource.errorStatus("The file ''{0}'' does not exist", this.file.getName());
        }
        if (!javaProject.isOnClasspath((IResource)this.file)) {
            return ClientBundleResource.errorStatus("The file ''{0}'' is not on the project''s classpath", this.file.getName());
        }
        return StatusUtilities.OK_STATUS;
    }

    private IStatus validateMethodName(IJavaProject javaProject, String[] extendedInterfaces, String[] methodNames) {
        assert (this.methodName != null);
        if (this.methodName.length() == 0) {
            return ClientBundleResource.errorStatus("Enter the method name", new Object[0]);
        }
        if (Arrays.asList(methodNames).contains(this.methodName)) {
            return ClientBundleResource.errorStatus("Another method is already named ''{0}''", this.methodName);
        }
        try {
            if (this.isMethodAlreadyDefined(javaProject, extendedInterfaces)) {
                return ClientBundleResource.errorStatus("Another method is already named ''{0}''", this.methodName);
            }
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e);
            return ClientBundleResource.errorStatus("Error while looking for conflicting methods.  See Eclipse log for details.", new Object[0]);
        }
        IStatus nameStatus = JavaUtilities.validateMethodName((String)this.methodName);
        if (!nameStatus.isOK()) {
            return nameStatus;
        }
        return StatusUtilities.OK_STATUS;
    }

    private IStatus validateResourceTypeName(IJavaProject javaProject) {
        assert (this.resourceTypeName != null);
        if (this.resourceTypeName.length() == 0) {
            return ClientBundleResource.errorStatus("Enter the resource type name", new Object[0]);
        }
        IType resourceType = JavaModelSearch.findType((IJavaProject)javaProject, (String)this.resourceTypeName);
        if (resourceType == null) {
            return ClientBundleResource.errorStatus("Resource type ''{0}'' does not exist", this.resourceTypeName);
        }
        if (ClientBundleUtilities.findResourcePrototypeType(javaProject) == null) {
            return ClientBundleResource.errorStatus("{0} is not on the project''s classpath", "com.google.gwt.resources.client.ResourcePrototype");
        }
        try {
            if (!ClientBundleUtilities.isResourceType(javaProject, resourceType)) {
                return ClientBundleResource.errorStatus("{0} is not a ClientBundle resource type", resourceType.getFullyQualifiedName());
            }
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e);
            return ClientBundleResource.errorStatus("Error while calculating resource type's super types.  See Eclipse log for details.", new Object[0]);
        }
        return StatusUtilities.OK_STATUS;
    }
}

