/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.clientbundle;

import com.google.gdt.eclipse.core.BuilderUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleResourceDependencyIndex;
import com.google.gwt.eclipse.core.nature.GWTNature;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;

public class ClientBundleResourceChangeListener
implements IResourceChangeListener {
    private static ClientBundleResourceChangeListener INSTANCE;

    public static synchronized void addToWorkspace() {
        if (INSTANCE == null) {
            INSTANCE = new ClientBundleResourceChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)INSTANCE, 1);
        }
    }

    private static IPackageFragment getContainingPackageFragment(IResource resource) {
        IContainer container = resource.getParent();
        if (!(container instanceof IFolder)) {
            return null;
        }
        IJavaElement javaElement = JavaCore.create((IFolder)((IFolder)container));
        if (!(javaElement instanceof IPackageFragment)) {
            return null;
        }
        return (IPackageFragment)javaElement;
    }

    private static boolean isPossibleClientBundleResourceDelta(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource.isDerived()) {
            return false;
        }
        if (resource.getType() != 1) {
            return false;
        }
        if (delta.getKind() != 1 && delta.getKind() != 2) {
            return false;
        }
        if ("java".equals(resource.getFileExtension())) {
            return false;
        }
        if (!GWTNature.isGWTProject(resource.getProject())) {
            return false;
        }
        IJavaProject javaProject = JavaCore.create((IProject)resource.getProject());
        return javaProject.isOnClasspath(resource);
    }

    private static boolean shouldVisitResourceDeltaChildren(IResourceDelta delta) {
        return !delta.getResource().isDerived();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                this.visitResourceDelta(delta);
            }
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e);
        }
    }

    private void visitResourceDelta(IResourceDelta delta) throws CoreException {
        delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                if (!ClientBundleResourceChangeListener.isPossibleClientBundleResourceDelta(delta)) {
                    return ClientBundleResourceChangeListener.shouldVisitResourceDeltaChildren(delta);
                }
                IResource resource = delta.getResource();
                IPackageFragment pckgFragment = ClientBundleResourceChangeListener.getContainingPackageFragment(resource);
                if (pckgFragment == null) {
                    return true;
                }
                IPath resourceClasspathRelativePath = new Path(pckgFragment.getElementName().replace('.', '/')).append(resource.getName());
                Set dependentCompilationUnits = ClientBundleResourceDependencyIndex.getInstance().findDependentCompilationUnits(resourceClasspathRelativePath);
                for (ICompilationUnit cu : dependentCompilationUnits) {
                    if (cu.exists()) continue;
                    ClientBundleResourceDependencyIndex.getInstance().remove(cu);
                }
                if (dependentCompilationUnits.size() > 0) {
                    BuilderUtilities.revalidateCompilationUnits((Set)dependentCompilationUnits, (String)"Validating ClientBundles");
                }
                return true;
            }
        });
    }
}

