/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.clientbundle;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gdt.eclipse.core.JavaUtilities;
import com.google.gdt.eclipse.core.ResourceUtils;
import com.google.gdt.eclipse.core.TypeHierarchyCache;
import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.platform.clientbundle.ResourceTypeDefaultExtensions;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.dom.Bindings;

public final class ClientBundleUtilities {
    public static final String CLIENT_BUNDLE_SOURCE_ANNOTATION_NAME = "com.google.gwt.resources.client.ClientBundle.Source";
    public static final String CLIENT_BUNDLE_TYPE_NAME = "com.google.gwt.resources.client.ClientBundle";
    public static final String CLIENT_BUNDLE_WITH_LOOKUP_TYPE_NAME = "com.google.gwt.resources.client.ClientBundleWithLookup";
    public static final String CSS_RESOURCE_TYPE_NAME = "com.google.gwt.resources.client.CssResource";
    public static final String DATA_RESOURCE_TYPE_NAME = "com.google.gwt.resources.client.DataResource";
    public static final String RESOURCE_PROTOTYPE_TYPE_NAME = "com.google.gwt.resources.client.ResourcePrototype";
    private static final String GWT_CREATE_RESOURCE_TYPE_NAME = "com.google.gwt.resources.client.GwtCreateResource";
    private static final TypeHierarchyCache resourceTypesCache = new TypeHierarchyCache();
    private static final String TEXT_RESOURCE_TYPE_NAME = "com.google.gwt.resources.client.TextResource";

    public static IType findClientBundleType(IJavaProject javaProject) {
        return JavaModelSearch.findType((IJavaProject)javaProject, (String)CLIENT_BUNDLE_TYPE_NAME);
    }

    public static IType findCssResourceType(IJavaProject javaProject) {
        return JavaModelSearch.findType((IJavaProject)javaProject, (String)CSS_RESOURCE_TYPE_NAME);
    }

    public static IType[] findResourcePrototypeSubtypes(IJavaProject javaProject) throws JavaModelException {
        IType resourcePrototype = ClientBundleUtilities.findResourcePrototypeType(javaProject);
        if (resourcePrototype == null) {
            return new IType[0];
        }
        return resourceTypesCache.getHierarchy(resourcePrototype).getAllSubtypes(resourcePrototype);
    }

    public static IType findResourcePrototypeType(IJavaProject javaProject) {
        return JavaModelSearch.findType((IJavaProject)javaProject, (String)RESOURCE_PROTOTYPE_TYPE_NAME);
    }

    public static boolean isClientBundle(IJavaProject javaProject, IType type) throws JavaModelException {
        return JavaUtilities.isSubtype((IType)ClientBundleUtilities.findClientBundleType(javaProject), (IType)type);
    }

    public static boolean isClientBundle(IJavaProject javaProject, String typeName) throws JavaModelException {
        IType type = JavaModelSearch.findType((IJavaProject)javaProject, (String)typeName);
        if (type == null) {
            return false;
        }
        return ClientBundleUtilities.isClientBundle(javaProject, type);
    }

    public static boolean isClientBundle(ITypeBinding typeBinding) {
        ITypeBinding clientBundleBinding = Bindings.findTypeInHierarchy((ITypeBinding)typeBinding, (String)CLIENT_BUNDLE_TYPE_NAME);
        return clientBundleBinding != null;
    }

    public static boolean isCssResource(IJavaProject javaProject, IType type) throws JavaModelException {
        return JavaUtilities.isSubtype((IType)ClientBundleUtilities.findCssResourceType(javaProject), (IType)type);
    }

    public static boolean isGwtCreateResource(ITypeBinding typeBinding) {
        ITypeBinding gwtCreateResourceBinding = JavaASTUtils.findTypeInHierarchy((ITypeBinding)typeBinding, (String)GWT_CREATE_RESOURCE_TYPE_NAME);
        return gwtCreateResourceBinding != null;
    }

    public static boolean isResourceType(IJavaProject javaProject, IType type) throws JavaModelException {
        return JavaUtilities.isSubtype((IType)ClientBundleUtilities.findResourcePrototypeType(javaProject), (IType)type);
    }

    public static boolean isResourceType(ITypeBinding typeBinding) {
        ITypeBinding resourcePrototypeBinding = Bindings.findTypeInHierarchy((ITypeBinding)typeBinding, (String)RESOURCE_PROTOTYPE_TYPE_NAME);
        return resourcePrototypeBinding != null;
    }

    public static String suggestMethodName(IFile file) {
        String filename = ResourceUtils.filenameWithoutExtension((IFile)file);
        if (filename.length() == 0) {
            filename = file.getName();
        }
        if (JavaUtilities.isGoodMethodName((String)filename)) {
            return filename;
        }
        return JavaUtilities.sanitizeMethodName((String)filename);
    }

    public static String suggestResourceTypeName(IJavaProject javaProject, IFile file) {
        block7: {
            ArrayList<String> matchingResourceTypes;
            block8: {
                IType[] resourceTypes;
                String ext = file.getFileExtension();
                if (ext == null) {
                    return DATA_RESOURCE_TYPE_NAME;
                }
                ext = "." + ext;
                matchingResourceTypes = new ArrayList<String>();
                IType[] iTypeArray = resourceTypes = ClientBundleUtilities.findResourcePrototypeSubtypes(javaProject);
                int n = resourceTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] defaultExtensions;
                    IType resourceType = iTypeArray[n2];
                    String[] stringArray = defaultExtensions = ResourceTypeDefaultExtensions.getDefaultExtensions((IType)resourceType);
                    int n3 = defaultExtensions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String defaultExtension = stringArray[n4];
                        if (ResourceUtils.areFilenamesEqual((String)ext, (String)defaultExtension)) {
                            String resourceTypeName = resourceType.getFullyQualifiedName('.');
                            matchingResourceTypes.add(resourceTypeName);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                if (matchingResourceTypes.size() <= 0) break block7;
                if (!matchingResourceTypes.contains(TEXT_RESOURCE_TYPE_NAME)) break block8;
                return TEXT_RESOURCE_TYPE_NAME;
            }
            try {
                return (String)matchingResourceTypes.get(0);
            }
            catch (JavaModelException e) {
                GWTPluginLog.logError(e, "Unable to suggest resource type for file " + file.getName());
            }
        }
        return DATA_RESOURCE_TYPE_NAME;
    }

    private ClientBundleUtilities() {
    }
}

