/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.clientbundle;

import com.google.gdt.eclipse.core.JavaUtilities;
import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gdt.eclipse.core.TypeCreator;
import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleResource;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleUtilities;
import com.google.gwt.eclipse.core.util.GwtProblemsTreeLogger;
import com.google.gwt.resources.css.ExtractClassNamesVisitor;
import com.google.gwt.resources.css.GenerateCssAst;
import com.google.gwt.resources.css.ast.CssStylesheet;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class GeneratedCssResource
extends ClientBundleResource {
    private IType customCssResourceType;

    private static String[] getExistingTopLevelTypeNames(IPackageFragment pckg) throws JavaModelException {
        ArrayList<String> typeNames = new ArrayList<String>();
        for (IType type : JavaModelSearch.findAllTopLevelTypes((IPackageFragment)pckg)) {
            typeNames.add(type.getElementName());
        }
        return typeNames.toArray(new String[0]);
    }

    public GeneratedCssResource(IFile file, String methodName) {
        super(file, methodName, "com.google.gwt.resources.client.CssResource");
    }

    @Override
    public void addToClientBundle(IType clientBundle, NewTypeWizardPage.ImportsManager imports, boolean addComments, IProgressMonitor monitor) throws CoreException {
        this.createType(clientBundle.getPackageFragment(), addComments);
        super.addToClientBundle(clientBundle, imports, addComments, monitor);
    }

    @Override
    public MethodDeclaration createMethodDeclaration(IType clientBundle, ASTRewrite astRewrite, ImportRewrite importRewrite, boolean addComments) throws CoreException {
        this.createType(clientBundle.getPackageFragment(), addComments);
        return super.createMethodDeclaration(clientBundle, astRewrite, importRewrite, addComments);
    }

    @Override
    protected String getReturnTypeName() {
        return this.customCssResourceType.getFullyQualifiedName('.');
    }

    private String computeCssClassMethodSource(IType type, String cssClass) {
        StringBuilder sb = new StringBuilder();
        String methodName = cssClass;
        if (!JavaUtilities.isGoodMethodName((String)methodName)) {
            methodName = JavaUtilities.sanitizeMethodName((String)methodName);
            sb.append("@ClassName(\"");
            sb.append(cssClass);
            sb.append("\")");
            sb.append(StubUtility.getLineDelimiterUsed((IJavaProject)type.getJavaProject()));
        }
        sb.append("String ");
        sb.append(methodName);
        sb.append("();");
        return sb.toString();
    }

    private void createType(IPackageFragment pckg, boolean addComments) throws CoreException {
        CssParseResult result;
        IStatus status;
        IJavaProject javaProject = pckg.getJavaProject();
        NullProgressMonitor monitor = new NullProgressMonitor();
        String simpleName = StringUtilities.capitalize((String)this.getMethodName());
        String qualifiedName = JavaModelUtil.concatenateName((String)pckg.getElementName(), (String)simpleName);
        IType existingType = JavaModelSearch.findType((IJavaProject)javaProject, (String)qualifiedName);
        if (existingType != null) {
            if (ClientBundleUtilities.isCssResource(javaProject, existingType)) {
                this.customCssResourceType = existingType;
                return;
            }
            simpleName = StringUtilities.computeUniqueName((String[])GeneratedCssResource.getExistingTopLevelTypeNames(pckg), (String)simpleName);
        }
        if ((status = (result = this.parseCss()).getStatus()).getSeverity() == 4) {
            throw new CoreException(status);
        }
        if (status.getSeverity() == 2) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning(null, (String)"CSS Parsing", (String)status.getMessage());
                }
            });
        }
        final Set cssClassNames = ExtractClassNamesVisitor.exec((CssStylesheet)result.getStylesheet());
        TypeCreator gen = new TypeCreator(pckg, simpleName, TypeCreator.ElementType.INTERFACE, new String[]{"com.google.gwt.resources.client.CssResource"}, addComments, (IProgressMonitor)monitor){
            private final /* synthetic */ IProgressMonitor val$monitor;
            {
                this.val$monitor = iProgressMonitor;
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
            }

            protected void createTypeMembers(IType newType, ImportRewrite imports) throws CoreException {
                for (String cssClass : cssClassNames) {
                    newType.createMethod(GeneratedCssResource.this.computeCssClassMethodSource(newType, cssClass), null, true, this.val$monitor);
                }
            }
        };
        this.customCssResourceType = gen.createType();
    }

    private CssParseResult parseCss() {
        CssStylesheet cssAst = null;
        GwtProblemsTreeLogger logger = new GwtProblemsTreeLogger();
        IFile cssFile = this.getFile();
        try {
            URL cssUrl = cssFile.getLocationURI().toURL();
            cssAst = GenerateCssAst.exec((TreeLogger)logger, (URL[])new URL[]{cssUrl});
        }
        catch (MalformedURLException e) {
            GWTPluginLog.logError(e);
        }
        catch (UnableToCompleteException unableToCompleteException) {
            // empty catch block
        }
        return new CssParseResult(cssFile.getName(), cssAst, logger);
    }

    private static class CssParseResult {
        private final String fileName;
        private final GwtProblemsTreeLogger logger;
        private IStatus status;
        private final CssStylesheet stylesheet;

        public CssParseResult(String fileName, CssStylesheet stylesheet, GwtProblemsTreeLogger logger) {
            this.fileName = fileName;
            this.stylesheet = stylesheet;
            this.logger = logger;
        }

        public IStatus getStatus() {
            if (this.status == null) {
                this.createStatus();
            }
            return this.status;
        }

        public CssStylesheet getStylesheet() {
            return this.stylesheet;
        }

        private void createStatus() {
            StringBuilder sb = new StringBuilder();
            int severity = 0;
            if (this.logger.hasProblems()) {
                sb.append("There were problems parsing '" + this.fileName + "'. ");
                List<String> errors = this.logger.getErrors();
                if (errors.size() > 0) {
                    severity = 4;
                    sb.append("\n\nERRORS:\n");
                    sb.append(StringUtilities.join(errors, (String)"\n"));
                } else {
                    sb.append("A CssResource subtype was still generated.");
                }
                List<String> warnings = this.logger.getWarnings();
                if (warnings.size() > 0) {
                    if (severity != 4) {
                        severity = 2;
                    }
                    sb.append("\n\nWARNINGS:\n");
                    sb.append(StringUtilities.join(warnings, (String)"\n"));
                }
            }
            if (this.stylesheet == null) {
                severity = 4;
            }
            this.status = new Status(severity, "com.gwtplugins.gwt.eclipse.core", sb.toString());
        }
    }
}

