/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.clientbundle.ui;

import com.google.gdt.eclipse.core.AdapterUtilities;
import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gdt.eclipse.core.ResourceUtils;
import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleResource;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleUtilities;
import com.google.gwt.eclipse.core.clientbundle.ui.AddResourcesToClientBundleDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;

public class AddResourcesToClientBundleAction
extends Action
implements IActionDelegate {
    private IType clientBundleType;
    private IFile[] files;
    private IProject project;

    private static IType findFirstTopLevelClientBundleType(IFile file) {
        try {
            ICompilationUnit cu;
            IJavaElement element = JavaCore.create((IFile)file);
            if (element instanceof ICompilationUnit && (cu = (ICompilationUnit)element).exists()) {
                IType[] iTypeArray = cu.getTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    if (ClientBundleUtilities.isClientBundle(cu.getJavaProject(), type)) {
                        return type;
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e);
        }
        return null;
    }

    public void run(IAction action) {
        AddResourcesToClientBundleDialog dlg = new AddResourcesToClientBundleDialog(this.getShell(), this.project, this.clientBundleType, this.files);
        if (dlg.open() != 0) {
            return;
        }
        IType clientBundle = dlg.getClientBundleType();
        try {
            this.addResourcesToClientBundle(clientBundle, dlg.getResources());
            ResourceUtils.openInDefaultEditor((Shell)this.getShell(), (IFile)((IFile)clientBundle.getResource()), (boolean)true);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error Adding Resources", (String)"One or more selected resources could not be added to the ClientBundle.", (IStatus)e.getStatus());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.project = null;
        this.clientBundleType = null;
        ArrayList<IFile> selectedFiles = new ArrayList<IFile>();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                IFile file = (IFile)AdapterUtilities.getAdapter(element, IFile.class);
                if (file == null) continue;
                if (this.project == null) {
                    this.project = file.getProject();
                }
                if (this.clientBundleType == null) {
                    this.clientBundleType = AddResourcesToClientBundleAction.findFirstTopLevelClientBundleType(file);
                    if (this.clientBundleType != null) {
                        this.project = this.clientBundleType.getJavaProject().getProject();
                    }
                }
                if (!ClientBundleResource.isProbableClientBundleResource(file)) continue;
                selectedFiles.add(file);
            }
        }
        this.files = selectedFiles.toArray(new IFile[0]);
    }

    private void addResourcesToClientBundle(IType clientBundle, List<ClientBundleResource> resources) throws CoreException {
        AddResourcesJob op = new AddResourcesJob(clientBundle, resources);
        IResource lock = clientBundle.getPackageFragment().getResource();
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, (ISchedulingRule)lock, 1, null);
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private static class AddResourcesJob
    implements IWorkspaceRunnable {
        private final IType clientBundle;
        private final List<ClientBundleResource> resources;

        public AddResourcesJob(IType clientBundle, List<ClientBundleResource> resources) {
            this.clientBundle = clientBundle;
            this.resources = resources;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            ICompilationUnit icu = this.clientBundle.getCompilationUnit();
            CompilationUnit cu = JavaASTUtils.parseCompilationUnit((ICompilationUnit)icu);
            ImportRewrite importRewrite = StubUtility.createImportRewrite((CompilationUnit)cu, (boolean)true);
            TypeDeclaration typeDecl = JavaASTUtils.findTypeDeclaration((CompilationUnit)cu, (String)this.clientBundle.getFullyQualifiedName());
            if (typeDecl == null) {
                throw new CoreException(StatusUtilities.newErrorStatus((String)("Missing ClientBundle type " + this.clientBundle.getFullyQualifiedName()), (String)"com.gwtplugins.gwt.eclipse.core"));
            }
            ASTRewrite astRewrite = ASTRewrite.create((AST)cu.getAST());
            ChildListPropertyDescriptor property = ASTNodes.getBodyDeclarationsProperty((ASTNode)typeDecl);
            ListRewrite listRewriter = astRewrite.getListRewrite((ASTNode)typeDecl, property);
            boolean addComments = StubUtility.doAddComments((IJavaProject)icu.getJavaProject());
            for (ClientBundleResource resource : this.resources) {
                listRewriter.insertLast((ASTNode)resource.createMethodDeclaration(this.clientBundle, astRewrite, importRewrite, addComments), null);
            }
            MultiTextEdit rootEdit = new MultiTextEdit();
            rootEdit.addChild(astRewrite.rewriteAST());
            rootEdit.addChild(importRewrite.rewriteImports(null));
            CompilationUnitChange cuChange = new CompilationUnitChange("Update ClientBundle", icu);
            cuChange.setSaveMode(1);
            cuChange.setEdit((TextEdit)rootEdit);
            cuChange.perform((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

