/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.clientbundle.ui;

import com.google.gdt.eclipse.core.JavaUtilities;
import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gdt.eclipse.core.ui.JavaProjectSelectionDialog;
import com.google.gdt.eclipse.core.ui.JavaTypeCompletionProcessorWithAutoActivation;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleResource;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleUtilities;
import com.google.gwt.eclipse.core.clientbundle.ui.BundledResourcesSelectionBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddResourcesToClientBundleDialog
extends StatusDialog {
    private final BundledResourcesSelectionBlock bundledResourcesBlock;
    private IType clientBundleType;
    private StringButtonDialogField clientBundleTypeField;
    private final FieldAdapter fieldAdapter = new FieldAdapter();
    private IFile[] files;
    private IProject project;
    private StringButtonDialogField projectField;
    private JavaTypeCompletionProcessor resourceTypeCompletionProcessor;

    public AddResourcesToClientBundleDialog(Shell parent, IProject project, IType clientBundleType, IFile[] files) {
        super(parent);
        this.project = project;
        this.clientBundleType = clientBundleType;
        this.files = files;
        this.bundledResourcesBlock = new BundledResourcesSelectionBlock("Bundled resources:", this.fieldAdapter);
        this.setTitle("Add Resources to ClientBundle");
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void create() {
        super.create();
        this.validateFields();
    }

    public IType getClientBundleType() {
        return this.clientBundleType;
    }

    public List<ClientBundleResource> getResources() {
        return this.bundledResourcesBlock.getResources();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeControls();
        this.addEventHandlers();
        this.fieldChanged();
        this.setInitialFocus(parent);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        int nColumns;
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = nColumns = 3;
        gridLayout.marginHeight = 8;
        gridLayout.marginWidth = 8;
        container.setLayout((Layout)gridLayout);
        this.createProjectControls(container, nColumns);
        this.createClientBundleTypeControls(container, nColumns);
        this.createBundledResourcesControls(container, nColumns);
        return container;
    }

    private void addEventHandlers() {
        this.projectField.setDialogFieldListener((IDialogFieldListener)this.fieldAdapter);
        this.clientBundleTypeField.setDialogFieldListener((IDialogFieldListener)this.fieldAdapter);
    }

    private IType chooseClientBundleType() {
        try {
            IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)ClientBundleUtilities.findClientBundleType(this.getJavaProject()));
            FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), scope, 6);
            dialog.setTitle("ClientBundle Type Selection");
            dialog.setMessage("Choose a type:");
            if (dialog.open() == 0) {
                return (IType)dialog.getFirstResult();
            }
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e);
        }
        return null;
    }

    private void clientBundleTypeChanged() {
        this.updateControls();
        if (this.clientBundleType != null) {
            IPackageFragment pckgFragment = this.clientBundleType.getPackageFragment();
            this.bundledResourcesBlock.setPackage(pckgFragment);
            this.bundledResourcesBlock.setExtendedInterfaces(new String[]{this.clientBundleType.getFullyQualifiedName('.')});
        } else {
            this.bundledResourcesBlock.setPackage(null);
            this.bundledResourcesBlock.setExtendedInterfaces(new String[0]);
        }
    }

    private void createBundledResourcesControls(Composite parent, int columns) {
        this.bundledResourcesBlock.doFillIntoGrid(parent, columns);
    }

    private void createClientBundleTypeControls(Composite parent, int nColumns) {
        this.clientBundleTypeField = new StringButtonDialogField((IStringButtonAdapter)this.fieldAdapter);
        this.clientBundleTypeField.setLabelText("ClientBundle:");
        this.clientBundleTypeField.setButtonLabel("Browse...");
        this.clientBundleTypeField.doFillIntoGrid(parent, nColumns);
        Text text = this.clientBundleTypeField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        this.resourceTypeCompletionProcessor = new JavaTypeCompletionProcessorWithAutoActivation();
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this.resourceTypeCompletionProcessor);
        TextFieldNavigationHandler.install((Text)text);
    }

    private void createProjectControls(Composite parent, int nColumns) {
        this.projectField = new StringButtonDialogField((IStringButtonAdapter)this.fieldAdapter);
        this.projectField.setLabelText("Project:");
        this.projectField.setButtonLabel("Browse...");
        this.projectField.doFillIntoGrid(parent, nColumns);
        Text text = this.projectField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.projectField.getTextControl(null));
    }

    private void fieldChanged() {
        this.validateFields();
        this.updateControls();
    }

    private IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.project);
    }

    private int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(60);
    }

    private void initBundledResources() {
        assert (this.getJavaProject() != null);
        ArrayList<ClientBundleResource> resources = new ArrayList<ClientBundleResource>();
        IFile[] iFileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            ClientBundleResource resource = ClientBundleResource.createFromFile(this.getJavaProject(), file);
            if (resource != null) {
                resources.add(resource);
            }
            ++n2;
        }
        this.bundledResourcesBlock.setResources(resources);
    }

    private void initializeControls() {
        if (this.project != null) {
            this.projectField.setText(this.project.getName());
            this.projectChanged();
            IJavaProject javaProject = this.getJavaProject();
            if (javaProject != null) {
                if (this.clientBundleType != null) {
                    this.clientBundleTypeField.setText(this.clientBundleType.getFullyQualifiedName('.'));
                    this.clientBundleTypeChanged();
                }
                if (this.files != null) {
                    this.initBundledResources();
                }
            }
        }
    }

    private void projectChanged() {
        this.updateControls();
        this.bundledResourcesBlock.setJavaProject(this.getJavaProject());
        this.setPackageFragmentForTypeCompletion();
    }

    private void setInitialFocus(Composite parent) {
        if (this.project == null) {
            this.projectField.postSetFocusOnDialogField(parent.getDisplay());
        } else if (this.clientBundleType == null) {
            this.clientBundleTypeField.postSetFocusOnDialogField(parent.getDisplay());
        }
    }

    private void setPackageFragmentForTypeCompletion() {
        IPackageFragment pckgFragment = null;
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            try {
                IPackageFragmentRoot[] srcRoots = javaProject.getPackageFragmentRoots();
                if (srcRoots.length > 0) {
                    pckgFragment = srcRoots[0].getPackageFragment("");
                }
            }
            catch (JavaModelException e) {
                GWTPluginLog.logError(e);
            }
        }
        this.resourceTypeCompletionProcessor.setPackageFragment(pckgFragment);
    }

    private void updateControls() {
        boolean enableBundledResourcesBlock;
        boolean enableClientBundleTypeField = this.project != null;
        boolean bl = enableBundledResourcesBlock = enableClientBundleTypeField && this.clientBundleType != null;
        if (enableClientBundleTypeField != this.clientBundleTypeField.isEnabled()) {
            this.clientBundleTypeField.setEnabled(enableClientBundleTypeField);
        }
        if (enableBundledResourcesBlock != this.bundledResourcesBlock.isEnabled()) {
            this.bundledResourcesBlock.setEnabled(enableBundledResourcesBlock);
        }
    }

    private IStatus validateBundledResources() {
        IStatus blockStatus = this.bundledResourcesBlock.getStatus();
        if (!blockStatus.isOK()) {
            return blockStatus;
        }
        if (this.bundledResourcesBlock.getResources().size() == 0) {
            return StatusUtilities.newErrorStatus((String)"", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        return StatusUtilities.OK_STATUS;
    }

    private IStatus validateClientBundleType() {
        IType oldClientBundleType = this.clientBundleType;
        this.clientBundleType = null;
        if (this.getJavaProject() == null) {
            return StatusUtilities.OK_STATUS;
        }
        String clientBundleTypeName = this.clientBundleTypeField.getText().trim();
        if (clientBundleTypeName.length() == 0) {
            return StatusUtilities.newErrorStatus((String)"", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        IType enteredClientBundleType = JavaModelSearch.findType((IJavaProject)this.getJavaProject(), (String)clientBundleTypeName);
        if (enteredClientBundleType == null) {
            return StatusUtilities.newErrorStatus((String)"ClientBundle type does not exist", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        try {
            if (!ClientBundleUtilities.isClientBundle(this.getJavaProject(), enteredClientBundleType)) {
                return StatusUtilities.newErrorStatus((String)"ClientBundle type must extend com.google.gwt.resources.client.ClientBundle", (String)"com.gwtplugins.gwt.eclipse.core");
            }
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e);
            return StatusUtilities.newErrorStatus((String)"Error while calculating super types.  See Eclipse log for details.", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        this.clientBundleType = enteredClientBundleType;
        if (!JavaUtilities.equalsWithNullCheck((Object)oldClientBundleType, (Object)enteredClientBundleType)) {
            this.clientBundleTypeChanged();
        }
        return StatusUtilities.OK_STATUS;
    }

    private void validateFields() {
        IStatus projectStatus = this.validateProject();
        IStatus clientBundleTypeStatus = this.validateClientBundleType();
        IStatus bundledResourcesStatus = this.validateBundledResources();
        this.updateStatus(StatusUtil.getMostSevere((IStatus[])new IStatus[]{projectStatus, clientBundleTypeStatus, bundledResourcesStatus}));
    }

    private IStatus validateProject() {
        IProject oldProject = this.project;
        this.project = null;
        String projectName = this.projectField.getText().trim();
        if (projectName.length() == 0) {
            return StatusUtilities.newErrorStatus((String)"", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        IProject enteredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!enteredProject.exists()) {
            return StatusUtilities.newErrorStatus((String)"Project does not exist", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        if (!enteredProject.isOpen()) {
            return StatusUtilities.newErrorStatus((String)"Project is not open", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        IJavaProject javaProject = JavaCore.create((IProject)enteredProject);
        if (javaProject == null || ClientBundleUtilities.findClientBundleType(javaProject) == null) {
            return StatusUtilities.newErrorStatus((String)"Project must be using GWT 2.0 or later to use ClientBundle.", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        this.project = enteredProject;
        if (!JavaUtilities.equalsWithNullCheck((Object)oldProject, (Object)enteredProject)) {
            this.projectChanged();
        }
        return StatusUtilities.OK_STATUS;
    }

    private class FieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    BundledResourcesSelectionBlock.IResourcesChangeListener {
        private FieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            IType type;
            if (field == AddResourcesToClientBundleDialog.this.projectField) {
                IJavaProject selectedProject = JavaProjectSelectionDialog.chooseProject((Shell)AddResourcesToClientBundleDialog.this.getShell(), (IJavaProject)AddResourcesToClientBundleDialog.this.getJavaProject(), Collections.singleton("com.gwtplugins.gwt.eclipse.core.gwtNature"));
                if (selectedProject != null) {
                    AddResourcesToClientBundleDialog.this.projectField.setText(selectedProject.getElementName());
                }
            } else if (field == AddResourcesToClientBundleDialog.this.clientBundleTypeField && (type = AddResourcesToClientBundleDialog.this.chooseClientBundleType()) != null) {
                AddResourcesToClientBundleDialog.this.clientBundleTypeField.setText(type.getFullyQualifiedName('.'));
            }
        }

        public void dialogFieldChanged(DialogField field) {
            AddResourcesToClientBundleDialog.this.fieldChanged();
        }

        @Override
        public void onResourcesChanged() {
            AddResourcesToClientBundleDialog.this.fieldChanged();
        }
    }
}

