/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.clientbundle.ui;

import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleResource;
import com.google.gwt.eclipse.core.clientbundle.ui.ClientBundleResourceDialog;
import com.google.gwt.eclipse.core.clientbundle.ui.ClientBundleResourceSelectionDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class BundledResourcesSelectionBlock {
    private static final int COL_FILE = 0;
    private static final int COL_METHOD = 2;
    private static final int COL_TYPE = 1;
    private static final int IDX_ADD = 0;
    private static final int IDX_ADD_MULTIPLE = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 4;
    private String[] extendedInterfaces;
    private IJavaProject javaProject;
    private final String labelText;
    private final IResourcesChangeListener listener;
    private IPackageFragment pckgFragment;
    private ListDialogField<ClientBundleResource> resourcesField;
    private Shell shell;
    private IStatus status = StatusUtilities.OK_STATUS;
    private ResourceImageLabelProvider workbenchLabelProvider = new ResourceImageLabelProvider();

    public BundledResourcesSelectionBlock(String labelText, IResourcesChangeListener listener) {
        this.labelText = labelText;
        this.listener = listener;
        this.createListField();
    }

    public void doFillIntoGrid(Composite parent, int columns) {
        this.shell = parent.getShell();
        this.resourcesField.doFillIntoGrid(parent, columns);
        GridData modulesFieldGridData = (GridData)this.resourcesField.getListControl(parent).getLayoutData();
        modulesFieldGridData.grabExcessHorizontalSpace = true;
        modulesFieldGridData.grabExcessVerticalSpace = true;
        this.resourcesField.getListControl(parent).setLayoutData((Object)modulesFieldGridData);
    }

    public String[] getExtendedInterfaces() {
        return this.extendedInterfaces;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public IPackageFragment getPackage() {
        return this.pckgFragment;
    }

    public List<ClientBundleResource> getResources() {
        return this.resourcesField.getElements();
    }

    public IStatus getStatus() {
        return this.status;
    }

    public boolean isEnabled() {
        return this.resourcesField.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.resourcesField.setEnabled(enabled);
        this.updateStatus();
    }

    public void setExtendedInterfaces(String[] extendedInterfaces) {
        this.extendedInterfaces = extendedInterfaces;
        this.updateStatus();
    }

    public void setJavaProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
        this.updateStatus();
    }

    public void setPackage(IPackageFragment pckgFragment) {
        this.pckgFragment = pckgFragment;
    }

    public void setResources(List<ClientBundleResource> resources) {
        this.resourcesField.setElements(resources);
        this.updateStatus();
    }

    private void addMultipleResources() {
        if (this.javaProject == null) {
            MessageDialog.openError((Shell)this.shell, (String)"Resource Selection Error", (String)"A valid Java project must be selected.");
            return;
        }
        List<IFile> files = ClientBundleResourceSelectionDialog.getFiles(this.shell, true, this.javaProject, null);
        if (files != null) {
            for (IFile file : files) {
                ClientBundleResource resource = ClientBundleResource.createFromFile(this.javaProject, file);
                if (this.resourcesField.getElements().contains(resource)) continue;
                this.resourcesField.addElement((Object)resource);
            }
            this.resourcesChanged();
        }
    }

    private void addResource() {
        ClientBundleResource resource;
        if (this.javaProject == null) {
            MessageDialog.openError((Shell)this.shell, (String)"Resource Selection Error", (String)"A valid Java project must be selected.");
            return;
        }
        ClientBundleResourceDialog dialog = new ClientBundleResourceDialog(this.shell, this.javaProject, this.pckgFragment, this.extendedInterfaces, this.getAllMethodsBeingAdded());
        if (dialog.open() == 0 && (resource = dialog.getClientBundleResource()) != null && !this.resourcesField.getElements().contains(resource)) {
            this.resourcesField.addElement((Object)resource);
            this.resourcesChanged();
        }
    }

    private void createListField() {
        String[] stringArray = new String[6];
        stringArray[0] = "Add...";
        stringArray[1] = "Add Multiple...";
        stringArray[2] = "Edit";
        stringArray[4] = "Remove";
        String[] buttons = stringArray;
        this.resourcesField = new ListDialogField((IListAdapter)new SelectionAdapter(), buttons, (ILabelProvider)new ColumnLabelProvider());
        this.resourcesField.setLabelText(this.labelText);
        String[] columnNames = new String[]{"File", "Type", "Method name"};
        ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(100), new ColumnPixelData(100), new ColumnPixelData(100)};
        this.resourcesField.setTableColumns(new ListDialogField.ColumnsDescription(columnLayouts, columnNames, false));
        this.resourcesField.enableButton(2, false);
        this.resourcesField.enableButton(4, false);
    }

    private void editSelectedResource() {
        ClientBundleResource resource = this.getSelectedResource();
        assert (resource != null);
        ClientBundleResourceDialog dialog = new ClientBundleResourceDialog(this.shell, this.javaProject, this.pckgFragment, this.extendedInterfaces, this.getMethodsBeingAddedExceptFrom(resource), resource);
        if (dialog.open() == 0) {
            ClientBundleResource newResource = dialog.getClientBundleResource();
            this.resourcesField.replaceElement((Object)resource, (Object)newResource);
            this.resourcesChanged();
        }
    }

    private String[] getAllMethodsBeingAdded() {
        return this.getMethodsBeingAddedExceptFrom(null);
    }

    private String[] getMethodsBeingAddedExceptFrom(ClientBundleResource excludedResource) {
        ArrayList<String> methodNames = new ArrayList<String>();
        for (ClientBundleResource otherResource : this.getResources()) {
            if (otherResource == excludedResource) continue;
            methodNames.add(otherResource.getMethodName());
        }
        return methodNames.toArray(new String[0]);
    }

    private ClientBundleResource getSelectedResource() {
        List selectedResources = this.resourcesField.getSelectedElements();
        if (selectedResources.size() == 1) {
            return (ClientBundleResource)selectedResources.get(0);
        }
        return null;
    }

    private void removeSelectedResources() {
        this.resourcesField.removeElements(this.resourcesField.getSelectedElements());
        this.resourcesChanged();
    }

    private void resourcesChanged() {
        this.updateStatus();
        this.listener.onResourcesChanged();
    }

    private void updateStatus() {
        if (!this.resourcesField.isEnabled()) {
            this.status = StatusUtilities.OK_STATUS;
            return;
        }
        List<ClientBundleResource> resources = this.getResources();
        if (resources.isEmpty()) {
            this.status = StatusUtilities.OK_STATUS;
            return;
        }
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        for (ClientBundleResource resource : resources) {
            statuses.add(this.validateResource(resource));
        }
        this.status = StatusUtil.getMostSevere((IStatus[])statuses.toArray(new IStatus[0]));
        this.resourcesField.refresh();
    }

    private IStatus validateResource(ClientBundleResource resource) {
        if (this.javaProject == null || !this.javaProject.getProject().isAccessible()) {
            return StatusUtilities.OK_STATUS;
        }
        if (this.extendedInterfaces == null || this.extendedInterfaces.length == 0) {
            return StatusUtilities.OK_STATUS;
        }
        return resource.validate(this.javaProject, this.extendedInterfaces, this.getMethodsBeingAddedExceptFrom(resource));
    }

    private class ColumnLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ColumnLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ClientBundleResource resource = (ClientBundleResource)element;
            switch (columnIndex) {
                case 0: {
                    IStatus resourceStatus = BundledResourcesSelectionBlock.this.validateResource(resource);
                    return BundledResourcesSelectionBlock.this.workbenchLabelProvider.getImage(resource, resourceStatus);
                }
                case 2: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpub_obj.gif");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ClientBundleResource resource = (ClientBundleResource)element;
            switch (columnIndex) {
                case 0: {
                    return resource.getFile().getName();
                }
                case 1: {
                    return Signature.getSimpleName((String)resource.getResourceTypeName());
                }
                case 2: {
                    return resource.getMethodName();
                }
            }
            return "";
        }
    }

    public static interface IResourcesChangeListener {
        public void onResourcesChanged();
    }

    private static class ResourceImageLabelProvider
    extends WorkbenchLabelProvider {
        private Map<IFile, Image> errorIconCache = new HashMap<IFile, Image>();

        private ResourceImageLabelProvider() {
        }

        public Image getImage(ClientBundleResource resource, IStatus status) {
            IFile file = resource.getFile();
            if (status.getSeverity() == 4) {
                if (this.errorIconCache.containsKey(file)) {
                    return this.errorIconCache.get(file);
                }
                ImageDescriptor imageDescriptor = this.getAdapter(file).getImageDescriptor((Object)file);
                imageDescriptor = new JavaElementImageDescriptor(imageDescriptor, 64, JavaElementImageProvider.SMALL_SIZE);
                Image errorIcon = imageDescriptor.createImage();
                this.errorIconCache.put(file, errorIcon);
                return errorIcon;
            }
            return this.getImage(file);
        }
    }

    private class SelectionAdapter
    implements IListAdapter<ClientBundleResource> {
        private SelectionAdapter() {
        }

        public void customButtonPressed(ListDialogField<ClientBundleResource> field, int index) {
            List resourcesBefore = BundledResourcesSelectionBlock.this.resourcesField.getElements();
            switch (index) {
                case 0: {
                    BundledResourcesSelectionBlock.this.addResource();
                    break;
                }
                case 1: {
                    BundledResourcesSelectionBlock.this.addMultipleResources();
                    break;
                }
                case 2: {
                    BundledResourcesSelectionBlock.this.editSelectedResource();
                    break;
                }
                case 4: {
                    BundledResourcesSelectionBlock.this.removeSelectedResources();
                }
            }
            if (BundledResourcesSelectionBlock.this.listener != null && !BundledResourcesSelectionBlock.this.getResources().equals(resourcesBefore)) {
                BundledResourcesSelectionBlock.this.listener.onResourcesChanged();
            }
        }

        public void doubleClicked(ListDialogField<ClientBundleResource> field) {
            BundledResourcesSelectionBlock.this.editSelectedResource();
        }

        public void selectionChanged(ListDialogField<ClientBundleResource> field) {
            int selectedElementsCount = BundledResourcesSelectionBlock.this.resourcesField.getSelectedElements().size();
            BundledResourcesSelectionBlock.this.resourcesField.enableButton(2, selectedElementsCount == 1);
            BundledResourcesSelectionBlock.this.resourcesField.enableButton(4, selectedElementsCount > 0);
        }
    }
}

