/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.clientbundle.ui;

import com.google.gdt.eclipse.core.ui.JavaTypeCompletionProcessorWithAutoActivation;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleResource;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleUtilities;
import com.google.gwt.eclipse.core.clientbundle.ui.ClientBundleResourceSelectionDialog;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ClientBundleResourceDialog
extends StatusDialog {
    private final ClientBundleResource editedResource;
    private final String[] existingMethodNames;
    private final String[] extendedInterfaces;
    private final FieldAdapter fieldAdapter = new FieldAdapter();
    private StringButtonDialogField fileField;
    private final IJavaProject javaProject;
    private StringDialogField methodNameField;
    private final IPackageFragment pckgFragment;
    private ClientBundleResource resource;
    private StringButtonDialogField resourceTypeField;

    public ClientBundleResourceDialog(Shell parent, IJavaProject javaProject, IPackageFragment pckgFragment, String[] extendedInterfaces, String[] existingMethodNames) {
        this(parent, javaProject, pckgFragment, extendedInterfaces, existingMethodNames, null);
    }

    public ClientBundleResourceDialog(Shell parent, IJavaProject javaProject, IPackageFragment pckgFragment, String[] extendedInterfaces, String[] existingMethodNames, ClientBundleResource editedResource) {
        super(parent);
        this.javaProject = javaProject;
        this.pckgFragment = pckgFragment;
        this.extendedInterfaces = extendedInterfaces;
        this.existingMethodNames = existingMethodNames;
        this.editedResource = editedResource;
        this.setTitle("ClientBundle Resource");
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void create() {
        super.create();
        if (this.editedResource != null) {
            this.validateFields();
        }
    }

    public ClientBundleResource getClientBundleResource() {
        return this.resource;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeControls();
        this.addEventHandlers();
        this.validateFields();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        int nColumns;
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = nColumns = 3;
        gridLayout.marginHeight = 8;
        gridLayout.marginWidth = 8;
        container.setLayout((Layout)gridLayout);
        this.createFileControls(container, nColumns);
        this.createMethodNameControls(container, nColumns);
        this.createResourceTypeControls(container, nColumns);
        return container;
    }

    private void addEventHandlers() {
        this.fileField.setDialogFieldListener((IDialogFieldListener)this.fieldAdapter);
        this.methodNameField.setDialogFieldListener((IDialogFieldListener)this.fieldAdapter);
        this.resourceTypeField.setDialogFieldListener((IDialogFieldListener)this.fieldAdapter);
    }

    private IType chooseResourceType() {
        try {
            IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)ClientBundleUtilities.findResourcePrototypeType(this.javaProject));
            FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), scope, 6);
            dialog.setTitle("Resource Type Selection");
            dialog.setMessage("Choose a resource type:");
            if (dialog.open() == 0) {
                return (IType)dialog.getFirstResult();
            }
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e);
        }
        return null;
    }

    private void createFileControls(Composite parent, int nColumns) {
        this.fileField = new StringButtonDialogField((IStringButtonAdapter)this.fieldAdapter);
        this.fileField.setLabelText("File:");
        this.fileField.setButtonLabel("Browse...");
        this.fileField.doFillIntoGrid(parent, nColumns);
        Text text = this.fileField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fileField.getTextControl(null));
        this.fileField.postSetFocusOnDialogField(parent.getDisplay());
    }

    private void createMethodNameControls(Composite parent, int nColumns) {
        this.methodNameField = new StringDialogField();
        this.methodNameField.setLabelText("Method name:");
        this.methodNameField.doFillIntoGrid(parent, nColumns - 1);
        Text text = this.methodNameField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        new Label(parent, 0);
    }

    private void createResourceTypeControls(Composite parent, int nColumns) {
        this.resourceTypeField = new StringButtonDialogField((IStringButtonAdapter)this.fieldAdapter);
        this.resourceTypeField.setLabelText("Resource type:");
        this.resourceTypeField.setButtonLabel("Browse...");
        this.resourceTypeField.doFillIntoGrid(parent, nColumns);
        Text text = this.resourceTypeField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        JavaTypeCompletionProcessorWithAutoActivation resourceTypeCompletionProcessor = new JavaTypeCompletionProcessorWithAutoActivation();
        resourceTypeCompletionProcessor.setPackageFragment(this.pckgFragment);
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)resourceTypeCompletionProcessor);
        TextFieldNavigationHandler.install((Text)text);
    }

    private void fileFieldChanged() {
        IFile file = this.getFileFieldValue();
        if (file == null || !file.exists()) {
            return;
        }
        if (this.methodNameField.getText().length() == 0) {
            this.methodNameField.setText(ClientBundleUtilities.suggestMethodName(file));
        }
        if (this.resourceTypeField.getText().length() == 0) {
            this.resourceTypeField.setText(ClientBundleUtilities.suggestResourceTypeName(this.javaProject, file));
        }
    }

    private IFile getFileFieldValue() {
        Path path = new Path(this.fileField.getText());
        if (path.segmentCount() < 2) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
    }

    private int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(60);
    }

    private void initializeControls() {
        if (this.editedResource != null) {
            this.fileField.setText(this.editedResource.getFile().getFullPath().toString());
            this.methodNameField.setText(this.editedResource.getMethodName());
            this.resourceTypeField.setText(this.editedResource.getResourceTypeName());
        }
    }

    private void validateFields() {
        this.resource = null;
        String fileFieldValue = this.fileField.getText().trim();
        if (fileFieldValue.length() == 0) {
            this.updateStatus(ClientBundleResource.errorStatus("Enter the resource file", new Object[0]));
            return;
        }
        IFile file = this.getFileFieldValue();
        String methodName = this.methodNameField.getText().trim();
        String resourceTypeName = this.resourceTypeField.getText().trim();
        ClientBundleResource curResource = ClientBundleResource.create(file, methodName, resourceTypeName);
        IStatus resourceStatus = curResource.validate(this.javaProject, this.extendedInterfaces, this.existingMethodNames);
        this.updateStatus(resourceStatus);
        if (resourceStatus.getSeverity() != 4) {
            this.resource = curResource;
        }
    }

    private class FieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private FieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            IType resourceType;
            if (field == ClientBundleResourceDialog.this.fileField) {
                List<IFile> files = ClientBundleResourceSelectionDialog.getFiles(ClientBundleResourceDialog.this.getShell(), false, ClientBundleResourceDialog.this.javaProject, ClientBundleResourceDialog.this.getFileFieldValue());
                if (files != null) {
                    assert (files.size() == 1);
                    ClientBundleResourceDialog.this.fileField.setText(files.get(0).getFullPath().toString());
                }
            } else if (field == ClientBundleResourceDialog.this.resourceTypeField && (resourceType = ClientBundleResourceDialog.this.chooseResourceType()) != null) {
                ClientBundleResourceDialog.this.resourceTypeField.setText(resourceType.getFullyQualifiedName('.'));
            }
        }

        public void dialogFieldChanged(DialogField field) {
            ClientBundleResourceDialog.this.validateFields();
            if (field == ClientBundleResourceDialog.this.fileField) {
                ClientBundleResourceDialog.this.fileFieldChanged();
            }
        }
    }
}

