/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.clientbundle.ui;

import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleResource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ClientBundleResourceSelectionDialog
extends ElementTreeSelectionDialog {
    public static List<IFile> getFiles(Shell shell, boolean multiSelection, IJavaProject javaProject, IFile initialSelection) {
        ClientBundleResourceSelectionDialog dialog = new ClientBundleResourceSelectionDialog(shell, javaProject, multiSelection);
        dialog.setInput(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        dialog.setInitialSelection(initialSelection);
        if (dialog.open() == 0) {
            ArrayList<IFile> files = new ArrayList<IFile>();
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                files.add((IFile)object);
                ++n2;
            }
            return files;
        }
        return null;
    }

    private ClientBundleResourceSelectionDialog(Shell shell, IJavaProject javaProject, boolean multiSelection) {
        super(shell, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (ITreeContentProvider)new StandardJavaElementContentProvider());
        this.setValidator((ISelectionStatusValidator)new TypedElementSelectionValidator(new Class[]{IFile.class}, multiSelection));
        this.setComparator((ViewerComparator)new JavaElementComparator());
        this.setTitle("Resource Selection");
        String message = MessageFormat.format("Choose {0} to bundle:", multiSelection ? "one or more resources" : "a resource");
        this.setMessage(message);
        this.addFilter((org.eclipse.jface.viewers.ViewerFilter)new ViewerFilter(javaProject));
    }

    private class ViewerFilter
    extends TypedViewerFilter {
        private final IJavaProject javaProject;

        public ViewerFilter(IJavaProject javaProject) {
            super(new Class[]{IJavaProject.class, IPackageFragmentRoot.class, IPackageFragment.class, IFile.class});
            this.javaProject = javaProject;
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean isValid = super.select(viewer, parent, element);
            if (!isValid) {
                return false;
            }
            try {
                if (element instanceof IJavaProject) {
                    return this.showProject((IJavaProject)element);
                }
                if (element instanceof IPackageFragmentRoot) {
                    return this.showPackageFragmentRoot((IPackageFragmentRoot)element);
                }
                if (element instanceof IPackageFragment) {
                    return this.showPackage((IPackageFragment)element);
                }
                if (element instanceof IFile) {
                    return this.showFile((IFile)element);
                }
                return true;
            }
            catch (JavaModelException e) {
                GWTPluginLog.logError(e);
                return false;
            }
        }

        private boolean showFile(IFile file) {
            if (!this.javaProject.isOnClasspath((IResource)file)) {
                return false;
            }
            if (!ClientBundleResource.isProbableClientBundleResource(file)) {
                return false;
            }
            return !(file.getParent() instanceof IProject);
        }

        private boolean showPackage(IPackageFragment pckg) throws JavaModelException {
            Object[] nonJavaResources = pckg.getNonJavaResources();
            if (nonJavaResources.length == 0) {
                return false;
            }
            Object[] objectArray = nonJavaResources;
            int n = nonJavaResources.length;
            int n2 = 0;
            while (n2 < n) {
                Object nonJavaResource = objectArray[n2];
                if (nonJavaResource instanceof IFile && this.showFile((IFile)nonJavaResource)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private boolean showPackageFragmentRoot(IPackageFragmentRoot srcRoot) throws JavaModelException {
            if (srcRoot.getKind() != 1) {
                return false;
            }
            IJavaElement[] iJavaElementArray = srcRoot.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                if (child instanceof IPackageFragment && this.showPackage((IPackageFragment)child)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private boolean showProject(IJavaProject project) throws JavaModelException {
            if (this.javaProject.equals(project)) {
                return true;
            }
            if (!this.javaProject.isOnClasspath((IJavaElement)project)) {
                return false;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot srcRoot = iPackageFragmentRootArray[n2];
                if (this.showPackageFragmentRoot(srcRoot)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

