/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.compile;

import com.google.gdt.eclipse.core.ClasspathUtilities;
import com.google.gdt.eclipse.core.ProcessUtilities;
import com.google.gdt.eclipse.core.jobs.ProgressMonitorCanceledWatcher;
import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.GWTProjectUtilities;
import com.google.gwt.eclipse.core.compile.GWTCompileSettings;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfiguration;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public class GWTCompileRunner {
    private static final String COMPILER_NAME = "com.google.gwt.dev.Compiler";
    private static final Pattern EXTRACT_QUOTED_ARGS_PATTERN = Pattern.compile("^([\"'])(.*)([\"'])$");
    private static final Pattern SPLIT_QUOTED_ARGS_PATTERN = Pattern.compile("[^\\s\"]+|\"[^\"\\\\]*(\\\\.[^\"\\\\]*)*\"");

    public static void compile(IJavaProject javaProject, IPath warLocation, GWTCompileSettings settings, OutputStream consoleOutputStream, ProcessUtilities.IProcessReceiver processReceiver) throws IOException, InterruptedException, CoreException, OperationCanceledException {
        IProject project = javaProject.getProject();
        if (settings.getEntryPointModules().isEmpty()) {
            return;
        }
        int processStatus = ProcessUtilities.launchProcessAndWaitFor(GWTCompileRunner.computeCompilerCommandLine(javaProject, warLocation, settings), (File)project.getLocation().toFile(), (OutputStream)consoleOutputStream, (ProcessUtilities.IProcessReceiver)processReceiver);
        if (warLocation != null) {
            IContainer[] iContainerArray = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(URIUtil.toURI((IPath)warLocation));
            int n = iContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer warFolder = iContainerArray[n2];
                warFolder.refreshLocal(2, null);
                ++n2;
            }
        }
        if (processStatus != 0) {
            if (processReceiver != null && processReceiver.hasDestroyedProcess()) {
                PrintWriter printWriter = new PrintWriter(consoleOutputStream);
                printWriter.println("GWT compilation terminated by the user.");
                printWriter.flush();
                throw new OperationCanceledException();
            }
            throw new CoreException((IStatus)new Status(4, "com.gwtplugins.gwt.eclipse.core", "GWT compilation failed"));
        }
    }

    public static void compileWithCancellationSupport(IJavaProject javaProject, IPath warLocation, GWTCompileSettings settings, OutputStream consoleOutputStream, ProcessUtilities.IProcessReceiver processReceiver, IProgressMonitor monitor, ProgressMonitorCanceledWatcher.Listener cancellationListener) throws IOException, InterruptedException, CoreException, OperationCanceledException {
        monitor.setTaskName("Performing GWT compile");
        ProgressMonitorCanceledWatcher monitorWatcher = new ProgressMonitorCanceledWatcher(monitor, cancellationListener);
        monitorWatcher.start();
        try {
            GWTCompileRunner.compile(javaProject, warLocation, settings, consoleOutputStream, processReceiver);
        }
        finally {
            monitorWatcher.stop();
        }
    }

    public static String computeTaskName(IProject project) {
        return String.valueOf(project.getName()) + " - GWT Compile";
    }

    static List<IRuntimeClasspathEntry> computeClasspath(IJavaProject javaProject) throws CoreException {
        IRuntimeClasspathEntry[] unresolvedRuntimeClasspath = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)javaProject);
        ArrayList<IRuntimeClasspathEntry> resolvedRuntimeClasspath = new ArrayList<IRuntimeClasspathEntry>();
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = unresolvedRuntimeClasspath;
        int n = unresolvedRuntimeClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry unresolvedClasspathEntry = iRuntimeClasspathEntryArray[n2];
            if (!JavaRuntime.isVMInstallReference((IRuntimeClasspathEntry)unresolvedClasspathEntry)) {
                resolvedRuntimeClasspath.addAll(Arrays.asList(JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)unresolvedClasspathEntry, (IJavaProject)javaProject)));
            }
            ++n2;
        }
        try {
            resolvedRuntimeClasspath.addAll(0, GWTProjectUtilities.getGWTSourceFolderPathsFromProjectAndDependencies(javaProject, false));
        }
        catch (Sdk.SdkException e) {
            throw new CoreException((IStatus)new Status(4, "com.gwtplugins.gwt.eclipse.core", e.getLocalizedMessage(), (Throwable)e));
        }
        GwtSdk gwtRuntime = GwtSdk.findSdkFor(javaProject);
        if (gwtRuntime == null) {
            GWTPluginLog.logWarning("Unable to find GWT runtime for project " + javaProject.getElementName() + ", will try to continue GWT compilation..");
            return resolvedRuntimeClasspath;
        }
        IStatus validationStatus = gwtRuntime.validate();
        if (!validationStatus.isOK()) {
            GWTPluginLog.logWarning("GWT runtime for project " + javaProject.getElementName() + " is not valid: " + validationStatus.getMessage() + ". Will attempt to proceed with GWT compilation anyway.");
            return resolvedRuntimeClasspath;
        }
        try {
            File gwtDevJar = gwtRuntime.getDevJar();
            resolvedRuntimeClasspath.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)Path.fromOSString((String)gwtDevJar.getAbsolutePath())));
        }
        catch (Sdk.SdkException e) {
            GWTPluginLog.logWarning(e, "Unable to add gwt-dev.jar to the compiler's classpath; will attempt GWT compilation anyway.");
        }
        return resolvedRuntimeClasspath;
    }

    private static List<String> computeCompilerCommandLine(IJavaProject javaProject, IPath warLocation, GWTCompileSettings settings) throws CoreException {
        ArrayList<String> commandLine = new ArrayList<String>();
        String javaExecutable = ProcessUtilities.computeJavaExecutableFullyQualifiedPath((IJavaProject)javaProject);
        commandLine.add(javaExecutable);
        commandLine.addAll(GWTLaunchConfiguration.computeCompileDynamicVMArgsAsList(javaProject));
        commandLine.addAll(GWTCompileRunner.splitArgs(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(settings.getVmArgs())));
        commandLine.add("-cp");
        commandLine.add(ClasspathUtilities.flattenToClasspathString(GWTCompileRunner.computeClasspath(javaProject)));
        commandLine.add(COMPILER_NAME);
        commandLine.addAll(GWTCompileRunner.computeCompilerOptions(warLocation, settings));
        commandLine.addAll(settings.getEntryPointModules());
        return commandLine;
    }

    private static List<String> computeCompilerOptions(IPath warLocation, GWTCompileSettings settings) {
        String outputStyle;
        ArrayList<String> options = new ArrayList<String>();
        String logLevel = settings.getLogLevel();
        if (logLevel != null && logLevel.trim().length() > 0) {
            options.add("-logLevel");
            options.add(logLevel);
        }
        if ((outputStyle = settings.getOutputStyle()) != null && outputStyle.trim().length() > 0) {
            options.add("-style");
            options.add(outputStyle);
        }
        if (warLocation != null) {
            options.add("-war");
            options.add(warLocation.toOSString());
        }
        options.addAll(GWTCompileRunner.splitArgs(settings.getExtraArgs()));
        return options;
    }

    private static List<String> splitArgs(String args) {
        ArrayList<String> options = new ArrayList<String>();
        if (args != null && args.trim().length() > 0) {
            Matcher matcher = SPLIT_QUOTED_ARGS_PATTERN.matcher(args);
            while (matcher.find()) {
                String arg = matcher.group();
                Matcher qmatcher = EXTRACT_QUOTED_ARGS_PATTERN.matcher(arg);
                if (qmatcher.matches()) {
                    options.add(qmatcher.group(2));
                    continue;
                }
                options.add(arg);
            }
        }
        return options;
    }
}

