/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.compile;

import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.launch.GWTLaunchAttributes;
import com.google.gwt.eclipse.core.properties.GWTProjectProperties;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class GWTCompileSettings {
    private static final String CDATA_END = "]]>";
    private static final String CDATA_START = "<![CDATA[";
    private static final String ENTRY_POINT_MODULES_TAG = "entry-point-module";
    private static final String EXTRA_ARGS_TAG = "extra-args";
    private static final String LOG_LEVEL_TAG = "log-level";
    private static final String OUTPUT_STYLE_TAG = "output-style";
    private static final String ROOT_TAG = "gwt-compile-settings";
    private static final String VM_ARGS_TAG = "vm-args";
    private List<String> entryPointModules = new ArrayList<String>();
    private String extraArgs = "";
    private String logLevel = (String)GWTLaunchAttributes.LOG_LEVEL.getDefaultValue();
    private String outputStyle = (String)GWTLaunchAttributes.OUTPUT_STYLE.getDefaultValue();
    private final IProject project;
    private String vmArgs = "-Xmx1g";

    public static GWTCompileSettings deserialize(byte[] bytes, IProject project) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(bytes);
        BufferedInputStream stream = new BufferedInputStream(byteInputStream);
        Element config = null;
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                config = parser.parse(new InputSource(stream)).getDocumentElement();
            }
            catch (Exception e) {
                GWTPluginLog.logError(e);
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e2) {
                    GWTPluginLog.logError(e2);
                }
                return null;
            }
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                GWTPluginLog.logError(e);
            }
        }
        if (!config.getNodeName().equalsIgnoreCase(ROOT_TAG)) {
            return null;
        }
        GWTCompileSettings settings = new GWTCompileSettings();
        NodeList nodes = config.getChildNodes();
        int length = nodes.getLength();
        int i = 0;
        while (i < length) {
            if (nodes.item(i).getNodeType() == 1) {
                Element element = (Element)nodes.item(i);
                String nodeName = element.getNodeName();
                if (nodeName.equalsIgnoreCase(LOG_LEVEL_TAG)) {
                    settings.setLogLevel(GWTCompileSettings.getElementText(element));
                } else if (nodeName.equalsIgnoreCase(OUTPUT_STYLE_TAG)) {
                    settings.setOutputStyle(GWTCompileSettings.getElementText(element));
                } else if (nodeName.equalsIgnoreCase(EXTRA_ARGS_TAG)) {
                    settings.setExtraArgs(GWTCompileSettings.getElementText(element));
                } else if (nodeName.equalsIgnoreCase(VM_ARGS_TAG)) {
                    settings.setVmArgs(GWTCompileSettings.getElementText(element));
                } else if (nodeName.equalsIgnoreCase(ENTRY_POINT_MODULES_TAG)) {
                    settings.entryPointModules.add(GWTCompileSettings.getElementText(element));
                }
            }
            ++i;
        }
        settings.initEntryPointModules();
        return settings;
    }

    public static IStatus validateExtraArgs(String extraArgs) {
        if (extraArgs.contains(CDATA_END)) {
            return StatusUtilities.newErrorStatus((String)"Compiler arguments list cannot contain: ]]>", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        return StatusUtilities.OK_STATUS;
    }

    public static IStatus validateVmArgs(String vmArgs) {
        if (vmArgs.contains(CDATA_END)) {
            return StatusUtilities.newErrorStatus((String)"VM arguments list cannot contain: ]]>", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        return StatusUtilities.OK_STATUS;
    }

    private static String createCDATAElement(String value) {
        if (value.contains(CDATA_END)) {
            throw new IllegalArgumentException("CDATA value cannot contain ]]>");
        }
        return CDATA_START + value + CDATA_END;
    }

    private static String createXmlElement(String tagName, String value) {
        return "<" + tagName + ">" + value + "</" + tagName + ">";
    }

    private static String getElementText(Element element) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(0);
            if (child.getNodeType() == 3) {
                return ((Text)child).getNodeValue();
            }
            if (child.getNodeType() == 4) {
                return ((CDATASection)child).getNodeValue();
            }
            ++i;
        }
        return "";
    }

    public GWTCompileSettings() {
        this(null);
    }

    public GWTCompileSettings(IProject project) {
        this.project = project;
        this.initEntryPointModules();
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            GWTCompileSettings that = (GWTCompileSettings)o;
            return this.toXml().equals(that.toXml());
        }
        return false;
    }

    public List<String> getEntryPointModules() {
        return this.entryPointModules;
    }

    public String getExtraArgs() {
        return this.extraArgs;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getOutputStyle() {
        return this.outputStyle;
    }

    public String getVmArgs() {
        return this.vmArgs;
    }

    public int hashCode() {
        return this.toXml().hashCode();
    }

    public void setEntryPointModules(List<String> entryPointModules) {
        this.entryPointModules = entryPointModules;
    }

    public void setExtraArgs(String args) {
        this.extraArgs = args;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public void setOutputStyle(String outputStyle) {
        this.outputStyle = outputStyle;
    }

    public void setVmArgs(String vmArgs) {
        this.vmArgs = vmArgs;
    }

    public byte[] toByteArray() {
        try {
            return this.toXml().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            GWTPluginLog.logError(e);
            return new byte[0];
        }
    }

    private void initEntryPointModules() {
        List<String> modules;
        if (this.project != null && this.getEntryPointModules().size() == 0 && (modules = GWTProjectProperties.getEntryPointModules(this.project)).size() != 0) {
            this.setEntryPointModules(modules);
        }
    }

    private boolean shouldSaveEntryPointModules() {
        if (this.entryPointModules == null) {
            return false;
        }
        if (this.project == null) {
            return true;
        }
        List<String> defaultModules = GWTProjectProperties.getDefaultEntryPointModules(this.project);
        if (defaultModules.size() != this.entryPointModules.size()) {
            return true;
        }
        for (String moduleName : defaultModules) {
            if (this.entryPointModules.contains(moduleName)) continue;
            return false;
        }
        return true;
    }

    private String toXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<gwt-compile-settings>");
        sb.append(GWTCompileSettings.createXmlElement(LOG_LEVEL_TAG, this.logLevel));
        sb.append(GWTCompileSettings.createXmlElement(OUTPUT_STYLE_TAG, this.outputStyle));
        sb.append(GWTCompileSettings.createXmlElement(EXTRA_ARGS_TAG, GWTCompileSettings.createCDATAElement(this.extraArgs)));
        sb.append(GWTCompileSettings.createXmlElement(VM_ARGS_TAG, GWTCompileSettings.createCDATAElement(this.vmArgs)));
        if (this.shouldSaveEntryPointModules()) {
            for (String moduleName : this.entryPointModules) {
                sb.append(GWTCompileSettings.createXmlElement(ENTRY_POINT_MODULES_TAG, moduleName));
            }
        }
        sb.append("</gwt-compile-settings>");
        return sb.toString();
    }
}

