/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.compile.ui;

import com.google.gdt.eclipse.core.SWTUtilities;
import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gdt.eclipse.core.extensions.ExtensionQuery;
import com.google.gdt.eclipse.platform.shared.ui.IPixelConverter;
import com.google.gdt.eclipse.platform.ui.PixelConverterFactory;
import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.compile.GWTCompileSettings;
import com.google.gwt.eclipse.core.launch.GWTLaunchAttributes;
import com.google.gwt.eclipse.core.launch.ui.EntryPointModulesSelectionBlock;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.properties.GWTProjectProperties;
import com.google.gwt.eclipse.core.runtime.GwtCapabilityChecker;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.osgi.service.prefs.BackingStoreException;

public class GWTCompileDialog
extends TitleAreaDialog {
    private Composite advancedContainer;
    private Button applyButton;
    private Button chooseProjectButton;
    private Button compileButton;
    private EntryPointModulesSelectionBlock entryPointModulesBlock;
    private String extraArgs;
    private Text extraArgsText;
    private final FieldListener listener = new FieldListener();
    private String logLevel;
    private ComboViewer logLevelComboViewer;
    private GWTCompileSettings originalSettings;
    private String outputStyle;
    private ComboViewer outputStyleComboViewer;
    private IProject project;
    private Text projectText;
    private String vmArgs;
    private Text vmArgsText;

    private static int convertSeverity(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public GWTCompileDialog(Shell shell, IProject project) {
        super(shell);
        this.project = project;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public GWTCompileSettings getCompileSettings() {
        GWTCompileSettings settings = new GWTCompileSettings(this.project);
        settings.setOutputStyle(this.outputStyle);
        settings.setLogLevel(this.logLevel);
        settings.setExtraArgs(this.extraArgs);
        settings.setVmArgs(this.vmArgs);
        settings.setEntryPointModules(this.entryPointModulesBlock.getModules());
        return settings;
    }

    public IProject getProject() {
        return this.project;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("GWT Compile");
        this.setHelpAvailable(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.compileButton = this.getButton(0);
        this.compileButton.setText("Compile");
        this.getShell().setDefaultButton(this.compileButton);
        ++((GridLayout)parent.getLayout()).numColumns;
        this.applyButton = new Button(parent, 8);
        this.applyButton.setText("Apply");
        this.applyButton.setEnabled(false);
        this.setButtonLayoutData(this.applyButton);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Compile");
        this.setTitleImage(GWTPlugin.getDefault().getImage("com.gwtplugins.gwt.eclipse.core.images.gwtCompileLarge"));
        this.initializeControls();
        this.addEventHandlers();
        this.fieldChanged();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(parent, 0);
        GridData containerGridData = new GridData(4, 4, true, true, 1, 1);
        container.setLayoutData((Object)containerGridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 8;
        gridLayout.marginWidth = 8;
        container.setLayout((Layout)gridLayout);
        SWTFactory.createLabel((Composite)container, (String)"Project:", (int)1);
        this.projectText = new Text(container, 2048);
        this.projectText.setLayoutData((Object)new GridData(768));
        this.chooseProjectButton = new Button(container, 0);
        this.chooseProjectButton.setText("Browse...");
        this.createCompilerAndShellComponent(container);
        this.createEntryPointModulesComponent(container);
        this.createAdvancedOptions(container);
        return container;
    }

    private void addEventHandlers() {
        this.projectText.addModifyListener((ModifyListener)this.listener);
        this.chooseProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IJavaProject selectedProject = GWTCompileDialog.this.chooseProject();
                if (selectedProject != null) {
                    GWTCompileDialog.this.projectText.setText(selectedProject.getElementName());
                }
            }
        });
        this.logLevelComboViewer.addPostSelectionChangedListener((ISelectionChangedListener)this.listener);
        this.outputStyleComboViewer.addPostSelectionChangedListener((ISelectionChangedListener)this.listener);
        this.extraArgsText.addModifyListener((ModifyListener)this.listener);
        this.vmArgsText.addModifyListener((ModifyListener)this.listener);
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    GWTCompileSettings settings = GWTCompileDialog.this.getCompileSettings();
                    GWTProjectProperties.setGwtCompileSettings(GWTCompileDialog.this.project, settings);
                    GWTCompileDialog.this.originalSettings = settings;
                    GWTCompileDialog.this.applyButton.setEnabled(false);
                }
                catch (BackingStoreException e) {
                    GWTPluginLog.logError(e);
                }
            }
        });
    }

    private boolean areMultipleModulesAllowed() {
        GwtSdk sdk;
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        if (javaProject != null && (sdk = GwtSdk.findSdkFor(javaProject)) != null) {
            return new GwtCapabilityChecker(sdk).doesCompilerAllowMultipleModules();
        }
        return false;
    }

    private IJavaProject chooseProject() {
        IJavaProject[] javaProjects;
        try {
            javaProjects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e);
            javaProjects = new IJavaProject[]{};
        }
        ArrayList<IJavaProject> gwtProjects = new ArrayList<IJavaProject>();
        IJavaProject[] iJavaProjectArray = javaProjects;
        int n = javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            if (GWTNature.isGWTProject(javaProject.getProject())) {
                gwtProjects.add(javaProject);
            }
            ++n2;
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project Selection");
        dialog.setMessage("Choose a project to compile");
        dialog.setElements((Object[])gwtProjects.toArray(new IJavaProject[0]));
        dialog.setInitialSelections(new Object[]{JavaCore.create((IProject)this.project)});
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private void createAdvancedOptions(Composite parent) {
        IPixelConverter converter = PixelConverterFactory.createPixelConverter((Font)JFaceResources.getDialogFont());
        final ExpandableComposite expandPanel = new ExpandableComposite(parent, 0, 18);
        expandPanel.setText("Advanced");
        expandPanel.setExpanded(false);
        expandPanel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        GridData expandPanelGridData = new GridData(4, 4, true, false, 3, 1);
        expandPanelGridData.verticalIndent = converter.convertHeightInCharsToPixels(1);
        expandPanel.setLayoutData((Object)expandPanelGridData);
        expandPanel.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Shell shell = GWTCompileDialog.this.getShell();
                shell.setLayoutDeferred(true);
                Point size = shell.getSize();
                int shellHeightDeltaOnExpand = ((GWTCompileDialog)GWTCompileDialog.this).advancedContainer.computeSize((int)-1, (int)-1).y;
                if (expandPanel.isExpanded()) {
                    shell.setSize(size.x, size.y + shellHeightDeltaOnExpand);
                } else {
                    shell.setSize(size.x, size.y - shellHeightDeltaOnExpand);
                }
                shell.layout(true, true);
                shell.setLayoutDeferred(false);
            }
        });
        this.advancedContainer = new Composite((Composite)expandPanel, 0);
        this.advancedContainer.setLayoutData((Object)new GridData());
        this.advancedContainer.setFont(parent.getFont());
        this.advancedContainer.setLayout((Layout)new GridLayout(1, false));
        expandPanel.setClient((Control)this.advancedContainer);
        SWTFactory.createLabel((Composite)this.advancedContainer, (String)"Additional compiler arguments:", (int)1);
        this.extraArgsText = SWTUtilities.createMultilineTextbox((Composite)this.advancedContainer, (int)2048, (boolean)false);
        GridData extraArgsGridData = new GridData(768);
        extraArgsGridData.heightHint = converter.convertHeightInCharsToPixels(5);
        this.extraArgsText.setLayoutData((Object)extraArgsGridData);
        SWTFactory.createLabel((Composite)this.advancedContainer, (String)"VM arguments:", (int)1);
        this.vmArgsText = SWTUtilities.createMultilineTextbox((Composite)this.advancedContainer, (int)2048, (boolean)false);
        GridData vmArgsGridData = new GridData(768);
        vmArgsGridData.heightHint = converter.convertHeightInCharsToPixels(5);
        this.vmArgsText.setLayoutData((Object)vmArgsGridData);
    }

    private void createCompilerAndShellComponent(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)"Compiler && Shell", (int)2, (int)3, (int)768);
        this.createLogLevelControl((Composite)group);
        this.createOutputStyleControl((Composite)group);
    }

    private void createEntryPointModulesComponent(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)"Entry Point Modules", (int)3, (int)3, (int)1808);
        GridLayout groupLayout = (GridLayout)group.getLayout();
        groupLayout.marginBottom = 8;
        group.setLayout((Layout)groupLayout);
        this.entryPointModulesBlock = new EntryPointModulesSelectionBlock(null, this.listener);
        this.entryPointModulesBlock.doFillIntoGrid((Composite)group, 3);
    }

    private void createLogLevelControl(Composite parent) {
        SWTFactory.createLabel((Composite)parent, (String)"Log level:", (int)1);
        this.logLevelComboViewer = new ComboViewer(parent, 8);
        this.logLevelComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.logLevelComboViewer.setLabelProvider((IBaseLabelProvider)new DefaultComboLabelProvider());
        this.logLevelComboViewer.setInput((Object)GWTLaunchAttributes.LOG_LEVELS);
    }

    private void createOutputStyleControl(Composite parent) {
        SWTFactory.createLabel((Composite)parent, (String)"Output style:", (int)1);
        this.outputStyleComboViewer = new ComboViewer(parent, 8);
        this.outputStyleComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.outputStyleComboViewer.setLabelProvider((IBaseLabelProvider)new DefaultComboLabelProvider());
        this.outputStyleComboViewer.setInput((Object)GWTLaunchAttributes.OUTPUT_STYLES);
    }

    private void fieldChanged() {
        IStatus status = this.updateFields();
        boolean valid = status.getSeverity() != 4;
        this.compileButton.setEnabled(valid);
        if (valid) {
            GWTCompileSettings currentSettings = this.getCompileSettings();
            boolean different = !this.originalSettings.equals(currentSettings);
            this.applyButton.setEnabled(different);
        }
    }

    private void initializeControls() {
        if (this.project != null) {
            this.projectText.setText(this.project.getName());
        }
        GWTCompileSettings settings = this.project != null ? GWTProjectProperties.getGwtCompileSettings(this.project) : new GWTCompileSettings();
        this.initializeLogLevel(settings.getLogLevel());
        this.initializeOutputStyle(settings.getOutputStyle());
        this.initializeExtraArgs(settings.getExtraArgs());
        this.initializeVmArgs(settings.getVmArgs());
        this.originalSettings = settings;
    }

    private void initializeExtraArgs(String args) {
        this.extraArgsText.setText(args);
    }

    private void initializeLogLevel(String level) {
        this.logLevelComboViewer.setSelection((ISelection)new StructuredSelection((Object)level));
    }

    private void initializeOutputStyle(String style) {
        this.outputStyleComboViewer.setSelection((ISelection)new StructuredSelection((Object)style));
    }

    private void initializeVmArgs(String vmArgs) {
        this.vmArgsText.setText(vmArgs);
    }

    private IStatus updateEntryPointModules() {
        this.updateEntryPointModulesIfProjectChanged();
        if (this.entryPointModulesBlock.getModules().isEmpty()) {
            return StatusUtilities.newErrorStatus((String)"Add an entry point module", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        if (!this.areMultipleModulesAllowed() && this.entryPointModulesBlock.getModules().size() > 1) {
            return StatusUtilities.newErrorStatus((String)"Projects using GWT 1.5 or lower may only specify one entry point module to compile", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        return StatusUtilities.OK_STATUS;
    }

    private void updateEntryPointModulesIfProjectChanged() {
        if (this.project != null) {
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            if (javaProject != null && !javaProject.equals(this.entryPointModulesBlock.getJavaProject())) {
                this.entryPointModulesBlock.setJavaProject(javaProject);
                GWTCompileSettings settings = GWTProjectProperties.getGwtCompileSettings(this.project);
                this.entryPointModulesBlock.setDefaultModules(settings.getEntryPointModules());
                this.entryPointModulesBlock.setModules(settings.getEntryPointModules());
            }
        } else {
            this.entryPointModulesBlock.setJavaProject(null);
            this.entryPointModulesBlock.setDefaultModules(Collections.emptyList());
            this.entryPointModulesBlock.setModules(Collections.emptyList());
        }
    }

    private IStatus updateExtraArgs() {
        IStatus status = GWTCompileSettings.validateExtraArgs(this.extraArgsText.getText());
        if (status.getSeverity() != 4) {
            this.extraArgs = this.extraArgsText.getText();
        }
        return status;
    }

    private IStatus updateFields() {
        IStatus projectStatus = this.updateProjectAndCompileSettings();
        IStatus logLevelStatus = this.updateLogLevel();
        IStatus outputStyleStatus = this.updateOutputStyle();
        IStatus entryPointModulesStatus = this.updateEntryPointModules();
        IStatus extraArgsStatus = this.updateExtraArgs();
        IStatus vmArgsStatus = this.updateVmArgs();
        return this.updateStatus(new IStatus[]{projectStatus, logLevelStatus, outputStyleStatus, entryPointModulesStatus, extraArgsStatus, vmArgsStatus});
    }

    private IStatus updateLogLevel() {
        this.logLevel = (String)((StructuredSelection)this.logLevelComboViewer.getSelection()).getFirstElement();
        return StatusUtilities.OK_STATUS;
    }

    private IStatus updateOutputStyle() {
        this.outputStyle = (String)((StructuredSelection)this.outputStyleComboViewer.getSelection()).getFirstElement();
        return StatusUtilities.OK_STATUS;
    }

    private IStatus updateProjectAndCompileSettings() {
        String newProjectName;
        String oldProjectName = this.project != null ? this.project.getName() : "";
        this.project = null;
        String projectName = this.projectText.getText().trim();
        if (projectName.length() == 0) {
            return StatusUtilities.newErrorStatus((String)"Enter the project name", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        IProject enteredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!enteredProject.exists()) {
            return StatusUtilities.newErrorStatus((String)"Project does not exist", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        if (!enteredProject.isOpen()) {
            return StatusUtilities.newErrorStatus((String)"Project is not open", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        if (!GWTNature.isGWTProject(enteredProject)) {
            return StatusUtilities.newErrorStatus((String)(String.valueOf(projectName) + " is not a GWT project"), (String)"com.gwtplugins.gwt.eclipse.core");
        }
        String validViaExtensionMsg = this.validateProjectViaExtensions(enteredProject);
        if (validViaExtensionMsg != null) {
            return StatusUtilities.newErrorStatus((String)validViaExtensionMsg, (String)"com.gwtplugins.gwt.eclipse.core");
        }
        this.project = enteredProject;
        String string = newProjectName = this.project != null ? this.project.getName() : "";
        if (!newProjectName.equals(oldProjectName)) {
            this.originalSettings = GWTProjectProperties.getGwtCompileSettings(this.project);
        }
        try {
            if (2 == enteredProject.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2)) {
                return StatusUtilities.newWarningStatus((String)"The project {0} has errors.", (String)"com.gwtplugins.gwt.eclipse.core", (Object[])new Object[]{enteredProject.getName()});
            }
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e);
        }
        return StatusUtilities.OK_STATUS;
    }

    private IStatus updateStatus(IStatus status) {
        if (status.getSeverity() == 0) {
            status = StatusUtilities.newOkStatus((String)"Build the project with the GWT compiler", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        this.setMessage(status.getMessage(), GWTCompileDialog.convertSeverity(status));
        return status;
    }

    private IStatus updateStatus(IStatus[] status) {
        return this.updateStatus(StatusUtilities.getMostImportantStatusWithMessage((IStatus[])status));
    }

    private IStatus updateVmArgs() {
        IStatus status = GWTCompileSettings.validateVmArgs(this.vmArgsText.getText());
        if (status.getSeverity() != 4) {
            this.vmArgs = this.vmArgsText.getText();
        }
        return status;
    }

    private String validateProjectViaExtensions(IProject project) {
        ExtensionQuery extQuery = new ExtensionQuery("com.gwtplugins.gwt.eclipse.core", "gwtCompileProjectValidator", "class");
        List enablementFinders = extQuery.getData();
        for (ExtensionQuery.Data enablementFinder : enablementFinders) {
            String validityString = ((GWTCompileProjectValidator)enablementFinder.getExtensionPointData()).validate(project);
            if (validityString == null) continue;
            return validityString;
        }
        return null;
    }

    private static class DefaultComboLabelProvider
    extends LabelProvider {
        private DefaultComboLabelProvider() {
        }

        public String getText(Object element) {
            String element2 = (String)element;
            return String.valueOf(element2.toUpperCase().charAt(0)) + element2.toLowerCase().substring(1);
        }
    }

    private class FieldListener
    implements ModifyListener,
    ISelectionChangedListener,
    EntryPointModulesSelectionBlock.IModulesChangeListener {
        private FieldListener() {
        }

        public void modifyText(ModifyEvent e) {
            GWTCompileDialog.this.fieldChanged();
        }

        @Override
        public void onModulesChanged() {
            GWTCompileDialog.this.fieldChanged();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            GWTCompileDialog.this.fieldChanged();
        }
    }

    public static interface GWTCompileProjectValidator {
        public String validate(IProject var1);
    }
}

