/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.dialogs;

import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.dialogs.ModuleCompletionProposal;
import com.google.gwt.eclipse.core.modules.IModule;
import com.google.gwt.eclipse.core.modules.ModuleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class ModuleCompletionProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private static final int SIMPLE_NAME_PROPOSAL_RELEVANCE = 1;
    private static final int QUALIFIED_NAME_PROPOSAL_RELEVANCE = 2;
    private static final int PACKAGE_PROPOSAL_RELEVANCE = 3;
    private List<ModuleCompletionProposal> allProposals;
    private final JavaElementLabelProvider javaLabelProvider = new JavaElementLabelProvider(256);
    private IJavaProject javaProject;

    private static String simpleNameDisplayString(IModule module) {
        return String.valueOf(module.getSimpleName()) + " - " + module.getPackageName();
    }

    public ModuleCompletionProcessor() {
        this.allProposals = new ArrayList<ModuleCompletionProposal>();
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        String input = contentAssistSubjectControl.getDocument().get();
        return this.createProposals(documentOffset, input);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public void setProject(IJavaProject javaProject) {
        if (javaProject == null) {
            this.javaProject = null;
            this.allProposals = new ArrayList<ModuleCompletionProposal>();
        } else if (!javaProject.equals(this.javaProject)) {
            this.javaProject = javaProject;
            this.allProposals = this.createProposals();
        }
    }

    private void addPackageProposal(List<ModuleCompletionProposal> proposals, IModule module) {
        String modulePackageName = module.getPackageName();
        if (modulePackageName.length() == 0) {
            return;
        }
        for (ModuleCompletionProposal proposal : proposals) {
            if (!proposal.getDisplayString().equals(modulePackageName)) continue;
            return;
        }
        try {
            IPackageFragment[] iPackageFragmentArray = this.javaProject.getPackageFragments();
            int n = iPackageFragmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment packageFragment = iPackageFragmentArray[n2];
                if (packageFragment.getElementName().equals(modulePackageName)) {
                    Image image = this.javaLabelProvider.getImage((Object)packageFragment);
                    String displayString = packageFragment.getElementName();
                    ModuleCompletionProposal proposal = new ModuleCompletionProposal(modulePackageName, 0, 0, image, displayString, modulePackageName, 3);
                    proposals.add(proposal);
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e);
        }
    }

    private void addQualifiedNameProposal(List<ModuleCompletionProposal> proposals, IModule module) {
        QualifiedModuleCompletion proposal = new QualifiedModuleCompletion(module.getQualifiedName(), 0, 0, GWTPlugin.getDefault().getImage("com.gwtplugins.gwt.eclipse.core.images.moduleIcon"), ModuleCompletionProcessor.simpleNameDisplayString(module), module.getQualifiedName(), 2);
        proposals.add(proposal);
    }

    private void addSimpleNameProposal(List<ModuleCompletionProposal> proposals, IModule module) {
        ModuleCompletionProposal proposal = new ModuleCompletionProposal(module.getQualifiedName(), 0, 0, GWTPlugin.getDefault().getImage("com.gwtplugins.gwt.eclipse.core.images.moduleIcon"), ModuleCompletionProcessor.simpleNameDisplayString(module), module.getSimpleName(), 1);
        proposals.add(proposal);
    }

    private List<ModuleCompletionProposal> createProposals() {
        IModule[] modules;
        ArrayList<ModuleCompletionProposal> proposals = new ArrayList<ModuleCompletionProposal>();
        IModule[] iModuleArray = modules = ModuleUtils.findAllModules(this.javaProject, false);
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            this.addSimpleNameProposal(proposals, module);
            this.addQualifiedNameProposal(proposals, module);
            this.addPackageProposal(proposals, module);
            ++n2;
        }
        return proposals;
    }

    private ICompletionProposal[] createProposals(int documentOffset, String input) {
        assert (this.allProposals != null);
        String prefix = input.substring(0, documentOffset);
        ArrayList<ModuleCompletionProposal> proposals = new ArrayList<ModuleCompletionProposal>();
        for (ModuleCompletionProposal proposal : this.allProposals) {
            if (!proposal.matches(prefix)) continue;
            proposal.setReplacementLength(prefix.length());
            proposals.add(proposal);
        }
        Collections.sort(proposals);
        return proposals.toArray(new ICompletionProposal[0]);
    }

    private static class QualifiedModuleCompletion
    extends ModuleCompletionProposal {
        public QualifiedModuleCompletion(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, String prefixCompareString, int relevance) {
            super(replacementString, replacementOffset, replacementLength, image, displayString, prefixCompareString, relevance);
        }

        @Override
        public boolean matches(String input) {
            String packageName = Signature.getQualifier((String)this.prefixCompareString);
            if (!input.toLowerCase().startsWith(packageName.toLowerCase())) {
                return false;
            }
            return super.matches(input);
        }
    }
}

