/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.dialogs;

import com.google.gwt.eclipse.core.GWTPluginLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ModuleCompletionProposal
implements ICompletionProposal,
Comparable<ModuleCompletionProposal> {
    protected final String prefixCompareString;
    private final String displayString;
    private final Image image;
    private final int relevance;
    private int replacementLength;
    private final int replacementOffset;
    private final String newString;

    public ModuleCompletionProposal(String newString, int replacementOffset, int replacementLength, Image image, String displayString, String prefixCompareString, int relevance) {
        Assert.isNotNull((Object)newString);
        Assert.isNotNull((Object)displayString);
        Assert.isNotNull((Object)prefixCompareString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.newString = newString;
        this.replacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.image = image;
        this.displayString = displayString;
        this.prefixCompareString = prefixCompareString;
        this.relevance = relevance;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.replacementOffset, this.replacementLength, this.newString);
        }
        catch (BadLocationException e) {
            GWTPluginLog.logError(e);
        }
    }

    @Override
    public int compareTo(ModuleCompletionProposal other) {
        int diff = other.relevance - this.relevance;
        if (diff == 0) {
            diff = this.displayString.compareToIgnoreCase(other.displayString);
        }
        return diff;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public Image getImage() {
        return this.image;
    }

    public int getReplacementLength() {
        return this.replacementLength;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.replacementOffset + this.newString.length(), 0);
    }

    public boolean matches(String input) {
        return this.prefixCompareString.toLowerCase().startsWith(input.toLowerCase());
    }

    public void setReplacementLength(int replacementLength) {
        this.replacementLength = replacementLength;
    }

    public String toString() {
        return this.displayString;
    }
}

