/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.dialogs;

import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.modules.IModule;
import com.google.gwt.eclipse.core.modules.ModuleFile;
import com.google.gwt.eclipse.core.modules.ModuleJarResource;
import com.google.gwt.eclipse.core.modules.ModuleUtils;
import java.text.Collator;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ModuleSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "com.gwtplugins.gwt.eclipse.core.dialogs.ModuleInheritsSelectionDialog";
    private IJavaProject javaProject;
    private boolean showModulesInJars;

    public static IModule show(Shell shell, IJavaProject project, boolean showModulesInJars) {
        ModuleSelectionDialog dialog = new ModuleSelectionDialog(shell, project, showModulesInJars);
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            assert (result.length == 1 && result[0] instanceof IModule);
            IModule module = (IModule)result[0];
            return module;
        }
        return null;
    }

    private static IPath getPathForModule(IModule module) {
        if (module == null) {
            return null;
        }
        if (!module.isBinary()) {
            ModuleFile moduleFile = (ModuleFile)module;
            IFile file = moduleFile.getFile();
            return file.getFullPath();
        }
        ModuleJarResource moduleJarResource = (ModuleJarResource)module;
        IJarEntryResource jarEntryResource = moduleJarResource.getJarEntryResource();
        return jarEntryResource.getPackageFragmentRoot().getPath();
    }

    private ModuleSelectionDialog(Shell shell, IJavaProject javaProject, boolean showModulesInJars) {
        super(shell);
        this.javaProject = javaProject;
        this.showModulesInJars = showModulesInJars;
        this.setTitle("GWT Module Selection");
        this.setListLabelProvider((ILabelProvider)new ModuleItemLabelProvider());
        this.setDetailsLabelProvider((ILabelProvider)new ModuleItemDetailsLabelProvider());
    }

    public String getElementName(Object item) {
        IModule module = (IModule)item;
        return module.getSimpleName();
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ModuleItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) {
        IModule[] projectModules;
        IModule[] iModuleArray = projectModules = ModuleUtils.findAllModules(this.javaProject, this.showModulesInJars);
        int n = projectModules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            contentProvider.add((Object)module, itemsFilter);
            ++n2;
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected Comparator<?> getItemsComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String s2;
                Collator collator = Collator.getInstance();
                IModule module1 = (IModule)o1;
                IModule module2 = (IModule)o2;
                String s1 = module1.getSimpleName();
                int comparability = collator.compare(s1, s2 = module2.getSimpleName());
                if (comparability == 0) {
                    s1 = module1.getQualifiedName();
                    s2 = module2.getQualifiedName();
                    comparability = collator.compare(s1, s2);
                }
                if (comparability == 0) {
                    s1 = ModuleSelectionDialog.getPathForModule(module1).toString();
                    s2 = ModuleSelectionDialog.getPathForModule(module2).toString();
                    comparability = collator.compare(s1, s2);
                }
                return comparability;
            }
        };
    }

    protected IStatus validateItem(Object item) {
        return new Status(Status.OK_STATUS.getSeverity(), "com.gwtplugins.gwt.eclipse.core", 0, "", null);
    }

    private class ModuleItemDetailsLabelProvider
    extends ModuleItemLabelProvider {
        private ModuleItemDetailsLabelProvider() {
        }

        @Override
        public Image getImage(Object element) {
            if (!(element instanceof IModule)) {
                return super.getImage(element);
            }
            Image image = null;
            IModule module = (IModule)element;
            if (!module.isBinary()) {
                ModuleFile moduleFile = (ModuleFile)module;
                IFile file = moduleFile.getFile();
                try {
                    IPackageFragment pkFrag = ModuleSelectionDialog.this.javaProject.findPackageFragment(file.getParent().getFullPath());
                    image = this.provider.getImage((Object)pkFrag);
                }
                catch (JavaModelException e) {
                    GWTPluginLog.log(2, 0, "Unable to retrieve image for module " + module.getQualifiedName() + " package.", e);
                }
            }
            return image;
        }

        @Override
        public String getText(Object element) {
            if (!(element instanceof IModule)) {
                return super.getText(element);
            }
            String text = null;
            IModule module = (IModule)element;
            String packageName = module.getPackageName();
            if (!module.isBinary()) {
                ModuleFile moduleFile = (ModuleFile)module;
                IFile file = moduleFile.getFile();
                String modulePath = file.getFullPath().makeRelative().toString();
                text = String.valueOf(packageName) + " - " + modulePath;
            } else {
                ModuleJarResource moduleJarResource = (ModuleJarResource)module;
                IJarEntryResource jarEntryResource = moduleJarResource.getJarEntryResource();
                String jarPath = jarEntryResource.getPackageFragmentRoot().getPath().makeRelative().toString();
                text = String.valueOf(packageName) + " - " + jarPath;
            }
            return text;
        }
    }

    private static class ModuleItemLabelProvider
    extends LabelProvider {
        WorkbenchLabelProvider provider = new WorkbenchLabelProvider();

        public void dispose() {
            this.provider.dispose();
            super.dispose();
        }

        public Image getImage(Object element) {
            if (!(element instanceof IModule)) {
                return super.getImage(element);
            }
            return GWTPlugin.getDefault().getImage("com.gwtplugins.gwt.eclipse.core.images.moduleIcon");
        }

        public String getText(Object element) {
            if (!(element instanceof IModule)) {
                return super.getText(element);
            }
            IModule module = (IModule)element;
            return String.valueOf(module.getSimpleName()) + " - " + module.getPackageName();
        }
    }

    private class ModuleItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private SearchPattern packageMatcher;

        public ModuleItemsFilter() {
            String stringPackage;
            super((FilteredItemsSelectionDialog)ModuleSelectionDialog.this, (SearchPattern)new ModuleSearchPattern());
            if (this.patternMatcher.getPattern() == null || this.patternMatcher.getPattern().length() == 0) {
                this.patternMatcher.setPattern("*");
            }
            if ((stringPackage = ((ModuleSearchPattern)this.patternMatcher).getPackagePattern()) != null) {
                this.packageMatcher = new SearchPattern();
                this.packageMatcher.setPattern(stringPackage);
            } else {
                this.packageMatcher = null;
            }
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter iFilter) {
            if (!super.equalsFilter(iFilter)) {
                return false;
            }
            if (!(iFilter instanceof ModuleItemsFilter)) {
                return false;
            }
            ModuleItemsFilter moduleTypeItemsFilter = (ModuleItemsFilter)iFilter;
            String packagePattern = this.getPackagePattern();
            String filterPackagePattern = moduleTypeItemsFilter.getPackagePattern();
            if (packagePattern == null) {
                return filterPackagePattern == null;
            }
            return packagePattern.equals(filterPackagePattern);
        }

        public String getPackagePattern() {
            if (this.packageMatcher == null) {
                return null;
            }
            return this.packageMatcher.getPattern();
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.isSubFilter(filter)) {
                return false;
            }
            ModuleItemsFilter moduleTypeItemsFilter = (ModuleItemsFilter)filter;
            String packagePattern = this.getPackagePattern();
            String filterPackagePattern = moduleTypeItemsFilter.getPackagePattern();
            if (filterPackagePattern == null) {
                return packagePattern == null;
            }
            if (packagePattern == null) {
                return true;
            }
            return filterPackagePattern.startsWith(packagePattern) && filterPackagePattern.indexOf(46, packagePattern.length()) == -1;
        }

        public boolean matchesRawNamePattern(IModule module) {
            return Strings.startsWithIgnoreCase((String)module.getSimpleName(), (String)this.getPattern());
        }

        public boolean matchesRawNamePattern(Object item) {
            IModule module = (IModule)item;
            return this.matchesRawNamePattern(module);
        }

        public boolean matchItem(Object item) {
            IModule module = (IModule)item;
            if (!this.matchesPackage(module)) {
                return false;
            }
            return this.matchesName(module);
        }

        private boolean matchesName(IModule module) {
            return this.matches(module.getSimpleName());
        }

        private boolean matchesPackage(IModule module) {
            if (this.packageMatcher == null) {
                return true;
            }
            return this.packageMatcher.matches(module.getPackageName());
        }
    }

    private static class ModuleSearchPattern
    extends SearchPattern {
        private String packagePattern;

        private ModuleSearchPattern() {
        }

        public String getPackagePattern() {
            return this.packagePattern;
        }

        public void setPattern(String stringPattern) {
            String pattern = stringPattern;
            String packPattern = null;
            int index = stringPattern.lastIndexOf(".");
            if (index != -1) {
                packPattern = this.evaluatePackagePattern(stringPattern.substring(0, index));
                pattern = stringPattern.substring(index + 1);
                if (pattern.length() == 0) {
                    pattern = "**";
                }
            }
            super.setPattern(pattern);
            this.packagePattern = packPattern;
        }

        private String evaluatePackagePattern(String s) {
            StringBuffer buf = new StringBuffer();
            boolean hasWildCard = false;
            int i = 0;
            while (i < s.length()) {
                char ch = s.charAt(i);
                if (ch == '.') {
                    if (!hasWildCard) {
                        buf.append('*');
                    }
                    hasWildCard = false;
                } else if (ch == '*' || ch == '?') {
                    hasWildCard = true;
                }
                buf.append(ch);
                ++i;
            }
            if (!hasWildCard) {
                buf.append('*');
            }
            return buf.toString();
        }
    }
}

