/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.dialogs;

import com.google.gdt.eclipse.core.JavaProjectUtilities;
import com.google.gwt.eclipse.core.dialogs.ModuleCompletionProcessor;
import com.google.gwt.eclipse.core.dialogs.ModuleSelectionDialog;
import com.google.gwt.eclipse.core.modules.IModule;
import com.google.gwt.eclipse.core.modules.ModuleFile;
import com.google.gwt.eclipse.core.modules.ModuleUtils;
import com.google.gwt.eclipse.core.nature.GWTNature;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ModuleSelectionDialogButtonField
extends StringDialogField {
    private Button browseButton;
    private boolean browseButtonEnabled;
    private IJavaProject javaProjectWithGWTNature;
    private IModule module;
    private final WizardPage page;
    private IResource selection;
    private final StatusInfo status;

    private static GridData gridDataForButton(Button button, int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)button);
        return gd;
    }

    public ModuleSelectionDialogButtonField(WizardPage page, IDialogFieldListener changeListener) {
        this.page = page;
        this.browseButtonEnabled = true;
        this.setDialogFieldListener(changeListener);
        this.setContentAssistProcessor(new ModuleCompletionProcessor());
        this.status = new StatusInfo();
    }

    public void dialogFieldChanged() {
        this.validate();
        super.dialogFieldChanged();
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        this.setLabelText("Module:");
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)ModuleSelectionDialogButtonField.gridDataForLabel((int)1));
        Text text = this.getTextControl(parent);
        text.setLayoutData((Object)ModuleSelectionDialogButtonField.gridDataForText((int)(nColumns - 2)));
        Button button = this.getChangeControl(parent);
        button.setLayoutData((Object)ModuleSelectionDialogButtonField.gridDataForButton(button, 1));
        return new Control[]{label, text, button};
    }

    public void enableButton(boolean enable) {
        if (this.isOkToUse((Control)this.browseButton)) {
            this.browseButton.setEnabled(this.isEnabled() && enable);
        }
        this.browseButtonEnabled = enable;
    }

    public ModuleFile getModule() {
        return (ModuleFile)this.module;
    }

    public int getNumberOfControls() {
        return 3;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public boolean init(IResource selection) {
        assert (selection != null);
        assert (this.selection == null);
        assert (selection.getType() != 8);
        this.selection = selection;
        this.setGWTProject(JavaCore.create((IProject)selection.getProject()));
        if (this.javaProjectWithGWTNature == null) {
            return false;
        }
        ArrayList<IModule> modules = new ArrayList<IModule>();
        if (ModuleUtils.isModuleXml(selection)) {
            modules.add(ModuleUtils.create((IFile)selection));
        } else if (selection.getType() == 2) {
            modules.addAll(Arrays.asList(ModuleUtils.findChildModules((IContainer)selection)));
        }
        if (modules.isEmpty()) {
            modules.addAll(Arrays.asList(ModuleUtils.findAllModules(this.javaProjectWithGWTNature, false)));
        }
        if (modules.size() == 1) {
            String moduleName = ((IModule)modules.get(0)).getQualifiedName();
            this.setText(moduleName);
            return true;
        }
        return false;
    }

    public void setGWTProject(IJavaProject javaProject) {
        this.javaProjectWithGWTNature = JavaProjectUtilities.isJavaProjectNonNullAndExists((IJavaProject)javaProject) && GWTNature.isGWTProject(javaProject.getProject()) ? javaProject : null;
        this.validate();
        ((ModuleCompletionProcessor)this.getContentAssistProcessor()).setProject(this.javaProjectWithGWTNature);
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.browseButton)) {
            this.browseButton.setEnabled(this.isEnabled() && this.browseButtonEnabled);
        }
    }

    private void changeControlPressed() {
        IModule selectedModule = ModuleSelectionDialog.show(this.page.getShell(), this.javaProjectWithGWTNature, false);
        if (selectedModule != null) {
            this.setText(selectedModule.getQualifiedName());
        }
    }

    private Button getChangeControl(Composite parent) {
        if (this.browseButton == null) {
            this.assertCompositeNotNull(parent);
            this.browseButton = new Button(parent, 8);
            this.browseButton.setFont(parent.getFont());
            this.browseButton.setText("Browse...");
            this.browseButton.setEnabled(this.isEnabled() && this.browseButtonEnabled);
            this.browseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ModuleSelectionDialogButtonField.this.changeControlPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    ModuleSelectionDialogButtonField.this.changeControlPressed();
                }
            });
        }
        return this.browseButton;
    }

    private void validate() {
        this.module = null;
        if (this.javaProjectWithGWTNature == null) {
            return;
        }
        String str = this.getText().trim();
        if (str.length() == 0) {
            this.status.setError("Enter the fully-qualified module name");
            return;
        }
        IStatus nameStatus = ModuleUtils.validateQualifiedModuleName(str);
        if (!nameStatus.isOK()) {
            this.status.setError(nameStatus.getMessage());
            return;
        }
        IModule newModule = ModuleUtils.findModule(this.javaProjectWithGWTNature, str, false);
        if (newModule == null) {
            this.status.setError(MessageFormat.format("The module ''{0}'' does not exist", str));
            return;
        }
        this.module = newModule;
        this.status.setOK();
    }
}

