/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.editors.java;

import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.editors.java.GWTOpenEditorActionGroup;
import com.google.gwt.eclipse.core.editors.java.GWTSourceViewerConfiguration;
import com.google.gwt.eclipse.core.editors.java.JsniFormattingUtil;
import com.google.gwt.eclipse.core.nature.GWTNature;
import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.fix.CleanUpPostSaveListener;
import org.eclipse.jdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.saveparticipant.IPostSaveListener;
import org.eclipse.jdt.internal.ui.javaeditor.saveparticipant.SaveParticipantRegistry;
import org.eclipse.jdt.ui.actions.OpenEditorActionGroup;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;

public class GWTJavaEditor
extends CompilationUnitEditor {
    public static final String EDITOR_ID = "com.gwtplugins.gwt.eclipse.core.editors.gwtJavaEditor";
    private static final String CLEAN_UP_OPTION_TRUE = "true";
    private String inputPartitioning = "___java_partitioning";

    public String getInputPartitioning() {
        return this.inputPartitioning;
    }

    protected void createActions() {
        super.createActions();
        GWTOpenEditorActionGroup gwtOpenEditorActionGroup = new GWTOpenEditorActionGroup((JavaEditor)this);
        try {
            this.replaceOpenEditorAction(this.fActionGroups, gwtOpenEditorActionGroup);
            Field contextMenuField = JavaEditor.class.getDeclaredField("fContextMenuGroup");
            contextMenuField.setAccessible(true);
            CompositeActionGroup contextMenuGroup = (CompositeActionGroup)contextMenuField.get((Object)this);
            this.replaceOpenEditorAction(contextMenuGroup, gwtOpenEditorActionGroup);
        }
        catch (Exception e) {
            GWTPluginLog.logError(e);
        }
    }

    protected JavaSourceViewerConfiguration createJavaSourceViewerConfiguration() {
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        return new GWTSourceViewerConfiguration(textTools.getColorManager(), this.getPreferenceStore(), (ITextEditor)this);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IJavaProject javaProject = EditorUtility.getJavaProject((IEditorInput)input);
        this.inputPartitioning = javaProject != null && GWTNature.isGWTProject(javaProject.getProject()) ? "___gwt_partitioning" : "___java_partitioning";
        super.doSetInput(input);
    }

    protected void performSave(final boolean overwrite, final IProgressMonitor progressMonitor) {
        final ICompilationUnit cu = (ICompilationUnit)this.getInputJavaElement();
        final IJavaProject javaProject = cu.getJavaProject();
        if (javaProject == null || !this.formatOnSaveEnabled(javaProject)) {
            super.performSave(overwrite, progressMonitor);
            return;
        }
        final IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        final String[] originalJsniMethods = JsniFormattingUtil.getJsniMethods(document);
        this.runBehindSmokescreen(new Runnable(){

            @Override
            public void run() {
                GWTJavaEditor.super.performSave(overwrite, progressMonitor);
                try {
                    TextEdit edit = JsniFormattingUtil.format(document, javaProject, originalJsniMethods);
                    if (edit != null) {
                        edit.apply(document);
                        IBuffer buffer = cu.getBuffer();
                        if (buffer.hasUnsavedChanges()) {
                            buffer.save(null, true);
                        }
                    }
                }
                catch (Exception e) {
                    GWTPluginLog.logError(e);
                }
            }
        });
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.createJavaSourceViewerConfiguration());
    }

    ICompilationUnit getCompilationUnit() {
        return (ICompilationUnit)this.getInputJavaElement();
    }

    IJavaProject getInputJavaProject() {
        return this.getInputJavaElement().getJavaProject();
    }

    private boolean formatOnSaveEnabled(IJavaProject javaProject) {
        IPostSaveListener[] listeners;
        SaveParticipantRegistry spr = JavaPlugin.getDefault().getSaveParticipantRegistry();
        IPostSaveListener[] iPostSaveListenerArray = listeners = spr.getEnabledPostSaveListeners(javaProject.getProject());
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPostSaveListener listener = iPostSaveListenerArray[n2];
            if (listener instanceof CleanUpPostSaveListener) {
                Map settings = CleanUpPreferenceUtil.loadSaveParticipantOptions((IScopeContext)new ProjectScope(javaProject.getProject()));
                if (settings == null) {
                    return false;
                }
                return CLEAN_UP_OPTION_TRUE.equals(settings.get("cleanup.format_source_code"));
            }
            ++n2;
        }
        return false;
    }

    private void replaceOpenEditorAction(CompositeActionGroup actionGroup, GWTOpenEditorActionGroup newAction) throws Exception {
        Field groupsField = CompositeActionGroup.class.getDeclaredField("fGroups");
        groupsField.setAccessible(true);
        ActionGroup[] actionGroups = (ActionGroup[])groupsField.get(actionGroup);
        int i = 0;
        while (i < actionGroups.length) {
            if (actionGroups[i] instanceof OpenEditorActionGroup) {
                actionGroups[i] = newAction;
                return;
            }
            ++i;
        }
        throw new Exception("No existing OpenEditorActionGroup found");
    }

    private void runBehindSmokescreen(Runnable action) {
        Image image = null;
        Label label = null;
        try {
            SourceViewer sourceViewer;
            Control viewerControl;
            ISourceViewer viewer = this.getViewer();
            if (viewer instanceof SourceViewer && (viewerControl = (sourceViewer = (SourceViewer)viewer).getControl()) instanceof Composite) {
                Point size;
                Composite composite = (Composite)viewerControl;
                Display display = composite.getDisplay();
                while (!display.isDisposed() && display.readAndDispatch()) {
                }
                GC gc = new GC((Drawable)composite);
                try {
                    size = composite.getSize();
                    image = new Image(gc.getDevice(), size.x, size.y);
                    gc.copyArea(image, 0, 0);
                }
                finally {
                    gc.dispose();
                    gc = null;
                }
                label = new Label(composite, 0);
                label.setImage(image);
                label.setBounds(0, 0, size.x, size.y);
                label.moveAbove(null);
            }
            action.run();
        }
        finally {
            if (label != null) {
                label.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }
}

