/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.editors.java;

import com.google.gdt.eclipse.core.AdapterUtilities;
import com.google.gwt.eclipse.core.validators.java.JsniJavaRef;
import com.google.gwt.eclipse.core.validators.java.JsniParser;
import com.google.gwt.eclipse.core.validators.java.UnresolvedJsniJavaRefException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenWithMenu;

public class GWTOpenEditorActionGroup
extends ActionGroup {
    private boolean isEditorOwner;
    private OpenAction openAction;
    private IWorkbenchSite site;

    public GWTOpenEditorActionGroup(IViewPart part) {
        this.site = part.getSite();
        this.openAction = new GWTOpenAction(this.site);
        this.openAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        this.initialize(this.site.getSelectionProvider());
    }

    public GWTOpenEditorActionGroup(JavaEditor editor) {
        this.isEditorOwner = true;
        this.openAction = new GWTOpenAction(editor);
        this.openAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        editor.setAction("OpenEditor", (IAction)this.openAction);
        this.site = editor.getEditorSite();
        this.initialize(this.site.getSelectionProvider());
    }

    public void dispose() {
        ISelectionProvider provider = this.site.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.openAction);
        super.dispose();
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.appendToGroup(menu, (IAction)this.openAction);
        if (!this.isEditorOwner) {
            this.addOpenWithMenu(menu);
        }
    }

    public IAction getOpenAction() {
        return this.openAction;
    }

    private void addOpenWithMenu(IMenuManager menu) {
        ISelection selection = this.getContext().getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() != 1) {
            return;
        }
        Object o = ss.getFirstElement();
        IFile file = (IFile)AdapterUtilities.getAdapter((Object)o, IFile.class);
        if (file == null) {
            return;
        }
        MenuManager submenu = new MenuManager(ActionMessages.OpenWithMenu_label);
        submenu.add((IContributionItem)new OpenWithMenu(this.site.getPage(), (IAdaptable)file));
        menu.appendToGroup("group.open", (IContributionItem)submenu);
    }

    private void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.open", action);
        }
    }

    private void initialize(ISelectionProvider provider) {
        ISelection selection = provider.getSelection();
        this.openAction.update(selection);
        if (!this.isEditorOwner) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.openAction);
        }
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.Open", (IAction)this.openAction);
    }

    private static class GWTOpenAction
    extends OpenAction {
        private JavaEditor editor;

        public GWTOpenAction(IWorkbenchSite site) {
            super(site);
        }

        public GWTOpenAction(JavaEditor editor) {
            super(editor);
            this.editor = editor;
        }

        public void run(ITextSelection selection) {
            IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            ITypedRegion jsniRegion = JsniParser.getEnclosingJsniRegion(selection, document);
            if (jsniRegion == null) {
                super.run(selection);
                return;
            }
            TextSelection jsniBlock = new TextSelection(jsniRegion.getOffset(), jsniRegion.getLength());
            JsniJavaRef javaRef = JsniJavaRef.findEnclosingJavaRef(selection, (ITextSelection)jsniBlock, document);
            if (javaRef == null) {
                return;
            }
            IJavaProject project = EditorUtility.getEditorInputJavaElement((IEditorPart)this.editor, (boolean)false).getJavaProject();
            try {
                IJavaElement element = javaRef.resolveJavaElement(project);
                this.run(new Object[]{element});
            }
            catch (UnresolvedJsniJavaRefException unresolvedJsniJavaRefException) {
                // empty catch block
            }
        }
    }
}

