/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.editors.java;

import com.google.gdt.eclipse.core.formatter.IDocumentCloner;
import com.google.gdt.eclipse.core.formatter.IndependentMultiPassContentFormatter;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.editors.java.GWTDocumentSetupParticipant;
import com.google.gwt.eclipse.core.editors.java.GWTJavaEditor;
import com.google.gwt.eclipse.core.editors.java.GWTJavaSpellingReconcileStrategy;
import com.google.gwt.eclipse.core.editors.java.JsniAutoEditStrategy;
import com.google.gwt.eclipse.core.editors.java.JsniFormattingStrategy;
import com.google.gwt.eclipse.core.editors.java.JsniScanner;
import com.google.gwt.eclipse.core.editors.java.contentassist.JsniCompletionProcessor;
import java.util.Hashtable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.text.JavaCompositeReconcilingStrategy;
import org.eclipse.jdt.internal.ui.text.JavaReconciler;
import org.eclipse.jdt.internal.ui.text.java.JavaFormattingStrategy;
import org.eclipse.jdt.internal.ui.text.spelling.JavaSpellingReconcileStrategy;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.ITextEditor;

public class GWTSourceViewerConfiguration
extends JavaSourceViewerConfiguration {
    private static final IDocumentCloner JAVA_DOCUMENT_CLONER = new IDocumentCloner(){

        public IDocument clone(IDocument original) {
            Document clone = new Document(original.get());
            new GWTDocumentSetupParticipant().setup((IDocument)clone);
            return clone;
        }

        public void release(IDocument clone) {
        }
    };
    private final JsniScanner jsniScanner;

    public GWTSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor) {
        super(colorManager, preferenceStore, editor, null);
        this.jsniScanner = new JsniScanner(colorManager);
        this.jsniScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(colorManager.getColor("java_default"))));
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if ("__jsni_method".equals(contentType)) {
            IJavaProject javaProject = ((GWTJavaEditor)this.getEditor()).getInputJavaProject();
            Hashtable prefs = javaProject != null ? javaProject.getOptions(true) : JavaCore.getOptions();
            return new IAutoEditStrategy[]{new JsniAutoEditStrategy(prefs)};
        }
        return super.getAutoEditStrategies(sourceViewer, contentType);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        String[] javaContentTypes = super.getConfiguredContentTypes(sourceViewer);
        String[] jsniContentTypes = new String[]{"__jsni_method"};
        String[] allContentTypes = new String[javaContentTypes.length + jsniContentTypes.length];
        System.arraycopy(javaContentTypes, 0, allContentTypes, 0, javaContentTypes.length);
        System.arraycopy(jsniContentTypes, 0, allContentTypes, javaContentTypes.length, jsniContentTypes.length);
        return allContentTypes;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        try {
            ITextEditor editor = this.getEditor();
            return ((GWTJavaEditor)editor).getInputPartitioning();
        }
        catch (Exception e) {
            GWTPluginLog.logError(e);
            return "___java_partitioning";
        }
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = (ContentAssistant)super.getContentAssistant(sourceViewer);
        ICompilationUnit cu = ((GWTJavaEditor)this.getEditor()).getCompilationUnit();
        JsniCompletionProcessor processor = new JsniCompletionProcessor(cu);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__jsni_method");
        return assistant;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        IndependentMultiPassContentFormatter formatter = new IndependentMultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type", JAVA_DOCUMENT_CLONER);
        formatter.setMasterStrategy((IFormattingStrategy)new JavaFormattingStrategy());
        formatter.setSlaveStrategy2((IFormattingStrategy)new JsniFormattingStrategy(), "__jsni_method");
        return formatter;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = (PresentationReconciler)super.getPresentationReconciler(sourceViewer);
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.jsniScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__jsni_method");
        reconciler.setRepairer((IPresentationRepairer)dr, "__jsni_method");
        return reconciler;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        JavaReconciler reconciler = (JavaReconciler)super.getReconciler(sourceViewer);
        if (reconciler != null) {
            try {
                JavaCompositeReconcilingStrategy strategy = (JavaCompositeReconcilingStrategy)reconciler.getReconcilingStrategy("__dftl_partition_content_type");
                IReconcilingStrategy[] strategies = strategy.getReconcilingStrategies();
                IReconcilingStrategy[] newStrategies = new IReconcilingStrategy[strategies.length];
                int i = 0;
                while (i < strategies.length) {
                    newStrategies[i] = strategies[i] instanceof JavaSpellingReconcileStrategy ? new GWTJavaSpellingReconcileStrategy(sourceViewer, this.getEditor()) : strategies[i];
                    ++i;
                }
                strategy.setReconcilingStrategies(newStrategies);
            }
            catch (Exception e) {
                GWTPluginLog.logError(e);
            }
            return reconciler;
        }
        return null;
    }
}

