/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.editors.java;

import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.validators.java.JsniParser;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;

public class JsniFormattingUtil {
    public static TextEdit format(IDocument document, IJavaProject project, String[] originalJsniMethods) {
        Map jsOptions = JavaScriptCore.create((IProject)project.getProject()).getOptions(true);
        Map jOptions = project.getOptions(true);
        return JsniFormattingUtil.format(document, jOptions, jsOptions, originalJsniMethods);
    }

    public static TextEdit format(IDocument document, Map javaFormattingPrefs, Map javaScriptFormattingPrefs, String[] originalJsniMethods) {
        MultiTextEdit combinedEdit = new MultiTextEdit();
        try {
            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)document, (String)"___gwt_partitioning", (int)0, (int)document.getLength(), (boolean)false);
            int i = 0;
            ITypedRegion[] iTypedRegionArray = regions;
            int n = regions.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedRegion region = iTypedRegionArray[n2];
                if (region.getType().equals("__jsni_method")) {
                    TextEdit edit;
                    String originalJsniMethod = null;
                    if (originalJsniMethods != null && i < originalJsniMethods.length) {
                        originalJsniMethod = originalJsniMethods[i];
                    }
                    if ((edit = JsniFormattingUtil.format(document, new TypedPosition(region), javaFormattingPrefs, javaScriptFormattingPrefs, originalJsniMethod)) != null) {
                        combinedEdit.addChild(edit);
                    }
                    ++i;
                }
                ++n2;
            }
            return combinedEdit;
        }
        catch (BadLocationException e) {
            GWTPluginLog.logError(e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextEdit format(IDocument document, TypedPosition partition, Map<String, String> javaFormattingPrefs, Map<String, String> javaScriptFormattingPrefs, String original) {
        String formattedJs;
        int length;
        int offset;
        block6: {
            try {
                offset = partition.getOffset();
                length = partition.getLength();
                String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                int tabWidth = IndentManipulation.getTabWidth(javaFormattingPrefs);
                int indentWidth = IndentManipulation.getIndentWidth(javaFormattingPrefs);
                int methodDeclarationOffset = JsniFormattingUtil.getMethodDeclarationOffset(document, offset);
                int jsniLine1 = document.getLineOfOffset(methodDeclarationOffset);
                int methodIndentLevel = JsniFormattingUtil.getLineIndentLevel(document, jsniLine1, tabWidth, indentWidth);
                DefaultCodeFormatter defaultCodeFormatter = new DefaultCodeFormatter(javaFormattingPrefs);
                String indentLine = defaultCodeFormatter.createIndentationString(methodIndentLevel);
                String jsniSource = document.get(offset, length);
                String body = JsniParser.extractMethodBody(jsniSource);
                JsniJavaRefReplacementResult replacementResults = JsniFormattingUtil.replaceJsniJavaRefs(body);
                body = replacementResults.getJsni();
                TextEdit formatEdit = CodeFormatterUtil.format2((int)2, (String)body, (int)(methodIndentLevel + 1), (String)lineDelimiter, javaScriptFormattingPrefs);
                if (formatEdit != null) {
                    body = JsniFormattingUtil.restoreJsniJavaRefs(replacementResults);
                    Document d = new Document(body);
                    formatEdit.apply((IDocument)d);
                    formattedJs = d.get();
                    if (!formattedJs.startsWith(lineDelimiter)) {
                        formattedJs = String.valueOf(lineDelimiter) + formattedJs;
                    }
                    if (!formattedJs.endsWith(lineDelimiter)) {
                        formattedJs = String.valueOf(formattedJs) + lineDelimiter;
                    }
                    formattedJs = String.valueOf(formattedJs) + indentLine;
                    formattedJs = "/*-{" + formattedJs + "}-*/";
                    return new ReplaceEdit(offset, length, formattedJs);
                }
                if (original != null) break block6;
                return null;
            }
            catch (Exception e) {
                GWTPluginLog.logError(e);
                return null;
            }
        }
        formattedJs = original;
        return new ReplaceEdit(offset, length, formattedJs);
    }

    public static String[] getJsniMethods(IDocument document) {
        try {
            ITypedRegion[] regions;
            LinkedList<String> jsniMethods = new LinkedList<String>();
            ITypedRegion[] iTypedRegionArray = regions = TextUtilities.computePartitioning((IDocument)document, (String)"___gwt_partitioning", (int)0, (int)document.getLength(), (boolean)false);
            int n = regions.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedRegion region = iTypedRegionArray[n2];
                if (region.getType().equals("__jsni_method")) {
                    String jsni = document.get(region.getOffset(), region.getLength());
                    jsniMethods.add(jsni);
                }
                ++n2;
            }
            return jsniMethods.toArray(new String[0]);
        }
        catch (BadLocationException e) {
            GWTPluginLog.logError(e);
            return null;
        }
    }

    private static int getLineIndentLevel(IDocument document, int line, int tabWidth, int indentWidth) throws BadLocationException {
        int lineOffset = document.getLineOffset(line);
        return JsniFormattingUtil.getLineIndentLevel(document.get(lineOffset, document.getLineLength(line)), tabWidth, indentWidth);
    }

    private static int getLineIndentLevel(String line, int tabWidth, int indentWidth) {
        return IndentManipulation.measureIndentUnits((CharSequence)line, (int)tabWidth, (int)indentWidth);
    }

    private static int getMethodDeclarationOffset(IDocument document, int offset) {
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setResolveBindings(false);
        parser.setSource(document.get().toCharArray());
        ASTNode ast = parser.createAST(null);
        JsniMethodFinder finder = new JsniMethodFinder(offset);
        ast.accept((ASTVisitor)finder);
        return finder.getJsniMethodDeclarationOffset();
    }

    private static String makeJsToken(String s) {
        int hashCode = s.hashCode();
        String jsToken = "_" + (hashCode < 0 ? "N" + Math.abs(hashCode) : Integer.valueOf(hashCode));
        while (jsToken.length() < s.length()) {
            jsToken = String.valueOf(jsToken) + "_";
        }
        return jsToken;
    }

    private static JsniJavaRefReplacementResult replaceJsniJavaRefs(String jsni) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        Pattern p = Pattern.compile("@[a-zA-Z0-9._$]+::[a-zA-Z0-9_$]+(\\(.*?\\)\\(.*?\\))?");
        Matcher m = p.matcher(jsni);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            String ref = jsni.substring(start, end);
            String jsToken = JsniFormattingUtil.makeJsToken(ref);
            while (replacements.containsKey(jsToken) && !((String)replacements.get(jsToken)).equals(ref)) {
                jsToken = JsniFormattingUtil.makeJsToken(jsToken);
            }
            replacements.put(jsToken, ref);
        }
        for (Map.Entry kvp : replacements.entrySet()) {
            jsni = jsni.replace((CharSequence)kvp.getValue(), (CharSequence)kvp.getKey());
        }
        return new JsniJavaRefReplacementResult(jsni, replacements);
    }

    private static String restoreJsniJavaRefs(JsniJavaRefReplacementResult result) {
        String jsni = result.getJsni();
        for (Map.Entry<String, String> kvp : result.getReplacements().entrySet()) {
            jsni = jsni.replace(kvp.getKey(), kvp.getValue());
        }
        return jsni;
    }

    private static class JsniJavaRefReplacementResult {
        private String jsni;
        private Map<String, String> replacements;

        public JsniJavaRefReplacementResult(String jsni, Map<String, String> replacements) {
            this.jsni = jsni;
            this.replacements = replacements;
        }

        public String getJsni() {
            return this.jsni;
        }

        public Map<String, String> getReplacements() {
            return this.replacements;
        }
    }

    private static class JsniMethodFinder
    extends ASTVisitor {
        private final int jsniBlockOffset;
        private int jsniMethodDeclarationOffset = 0;

        public JsniMethodFinder(int jsniBlockOffset) {
            this.jsniBlockOffset = jsniBlockOffset;
            this.jsniMethodDeclarationOffset = jsniBlockOffset;
        }

        public int getJsniMethodDeclarationOffset() {
            return this.jsniMethodDeclarationOffset;
        }

        public boolean visit(MethodDeclaration method) {
            int offset = method.getStartPosition();
            int length = method.getLength();
            if (this.jsniBlockOffset > offset && this.jsniBlockOffset < offset + length) {
                this.jsniMethodDeclarationOffset = offset;
            }
            return false;
        }
    }
}

