/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.editors.java;

import com.google.gwt.eclipse.core.GWTPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;

public class JsniMethodBodyCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    public static final String SIMPLE_EXTENSION_ID = "jsniCompletionProposalComputer";
    public static final String THIS = "this";
    public static final String WND = "$wnd";
    private static final String JSNI_METHOD_OPEN_BRACE = "/*-{";
    private static final List<IContextInformation> NO_CONTEXTS = Collections.emptyList();
    private static final List<ICompletionProposal> NO_PROPOSALS = Collections.emptyList();

    static String computePropertyNameFromAccessorMethodName(String prefix, String propertyAccessorMethodName) {
        assert (propertyAccessorMethodName.startsWith(prefix));
        String propertyName = propertyAccessorMethodName.substring(prefix.length());
        if (propertyName.length() > 0) {
            propertyName = String.valueOf(propertyName.substring(0, 1).toLowerCase()) + propertyName.substring(1);
        }
        return propertyName;
    }

    static String createJsniBlock(IJavaProject project, String body, int indentationUnits) {
        StringBuilder sb = new StringBuilder();
        sb.append("/*-{\n");
        sb.append(CodeFormatterUtil.createIndentString((int)(indentationUnits + 1), (IJavaProject)project));
        if (body != null) {
            sb.append(body);
        }
        sb.append("\n");
        sb.append(CodeFormatterUtil.createIndentString((int)indentationUnits, (IJavaProject)project));
        sb.append("}-*/;\n");
        return sb.toString();
    }

    static int measureIndentationUnits(IDocument document, int lineOfInvocationOffset, int lineOffset, IJavaProject project) throws BadLocationException {
        Map options = project.getOptions(true);
        String lineText = document.get(lineOffset, document.getLineLength(lineOfInvocationOffset));
        int indentationUnits = IndentManipulation.measureIndentUnits((CharSequence)lineText, (int)IndentManipulation.getTabWidth((Map)options), (int)IndentManipulation.getIndentWidth((Map)options));
        return indentationUnits;
    }

    private static String createJsIndexedPropertyReadExpression(String propName, String indexerName, boolean isStatic) {
        String propRefExpression = propName.length() > 0 ? "." + propName : "";
        return String.valueOf(isStatic ? WND : THIS) + propRefExpression + "[" + indexerName + "]";
    }

    private static String createJsIndexedPropertyWriteExpression(String propName, String indexerName, String value, boolean isStatic) {
        return String.valueOf(JsniMethodBodyCompletionProposalComputer.createJsIndexedPropertyReadExpression(propName, indexerName, isStatic)) + " = " + value + ";";
    }

    private static String createJsMethodInvocationExpression(String methodName, boolean isStatic, String ... paramNames) {
        StringBuilder sb = new StringBuilder();
        sb.append(isStatic ? WND : THIS);
        sb.append(".");
        sb.append(methodName);
        sb.append("(");
        int i = 0;
        while (i < paramNames.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(paramNames[i]);
            ++i;
        }
        sb.append(");");
        return sb.toString();
    }

    private static String createJsPropertyReadExpression(String propName, boolean isStatic) {
        return String.valueOf(isStatic ? WND : THIS) + "." + propName + ";";
    }

    private static String createJsPropertyWriteExpression(String propName, String propValue, boolean isStatic) {
        StringBuilder sb = new StringBuilder();
        sb.append(isStatic ? WND : THIS);
        if (propName.length() > 0) {
            sb.append(".");
            sb.append(propName);
        }
        sb.append(" = ");
        sb.append(propValue);
        sb.append(";");
        return sb.toString();
    }

    private static JavaCompletionProposal createProposal(int flags, String replacementString, int replacementOffset, int numCharsFilled, int numCharsToOverwrite, String displayString) {
        GWTPlugin plugin = GWTPlugin.getDefault();
        Image image = Flags.isPublic((int)flags) ? plugin.getImage("com.gwtplugins.gwt.eclipse.core.images.jsniPublicMethodSmall") : (Flags.isPrivate((int)flags) ? plugin.getImage("com.gwtplugins.gwt.eclipse.core.images.jsniPrivateMethodSmall") : (Flags.isProtected((int)flags) ? plugin.getImage("com.gwtplugins.gwt.eclipse.core.images.jsniProtectedMethodSmall") : plugin.getImage("com.gwtplugins.gwt.eclipse.core.images.jsniDefaultMethodSmall")));
        replacementString = replacementString.substring(numCharsFilled);
        return new JavaCompletionProposal(replacementString, replacementOffset, numCharsToOverwrite, image, "/*-{ " + displayString + " }-*/;", 0);
    }

    private static boolean isIndexType(String typeSignature) {
        return "I".equals(typeSignature) || "J".equals(typeSignature) || "S".equals(typeSignature) || "B".equals(typeSignature) || "C".equals(typeSignature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return NO_PROPOSALS;
        }
        try {
            int flags;
            String prevMethodSource;
            IMethod prevMethod;
            JavaContentAssistInvocationContext jcaic = (JavaContentAssistInvocationContext)context;
            ICompilationUnit compilationUnit = jcaic.getCompilationUnit();
            compilationUnit.reconcile(0, false, null, null);
            int invocationOffset = jcaic.getInvocationOffset();
            IJavaElement elementAt = compilationUnit.getElementAt(invocationOffset);
            if (elementAt == null) {
                return NO_PROPOSALS;
            }
            if (9 != elementAt.getElementType()) {
                return NO_PROPOSALS;
            }
            IMethod method = (IMethod)elementAt;
            IType thisType = method.getDeclaringType();
            if (thisType.isInterface()) {
                return NO_PROPOSALS;
            }
            ISourceRange sourceRange = method.getSourceRange();
            if (sourceRange == null) {
                return NO_PROPOSALS;
            }
            String methodSource = method.getSource();
            int invocationIdx = invocationOffset - sourceRange.getOffset();
            IJavaElement prevElement = compilationUnit.getElementAt(sourceRange.getOffset() - 1);
            if (prevElement != null && 9 == prevElement.getElementType() && !(prevMethod = (IMethod)prevElement).getDeclaringType().isInterface() && Flags.isNative((int)prevMethod.getFlags()) && (prevMethodSource = prevMethod.getSource()).trim().endsWith(")")) {
                methodSource = prevMethodSource.concat(methodSource);
                method = prevMethod;
                invocationIdx += prevMethodSource.length();
            }
            if (!Flags.isNative((int)(flags = method.getFlags()))) {
                return NO_PROPOSALS;
            }
            int idxMultiLineComment = methodSource.trim().indexOf("/*");
            int idxSingleLineComment = methodSource.trim().indexOf("//");
            while (idxMultiLineComment == 0 || idxSingleLineComment == 0) {
                if (idxMultiLineComment == 0) {
                    invocationIdx -= methodSource.indexOf("*/") + 2;
                    methodSource = methodSource.substring(methodSource.indexOf("*/") + 2);
                } else {
                    invocationIdx -= methodSource.indexOf(10) + 1;
                    methodSource = methodSource.substring(methodSource.indexOf(10) + 1);
                }
                idxMultiLineComment = methodSource.trim().indexOf("/*");
                idxSingleLineComment = methodSource.trim().indexOf("//");
            }
            int jsniMethodOpenIdx = methodSource.indexOf(JSNI_METHOD_OPEN_BRACE);
            if (jsniMethodOpenIdx != -1) {
                int jsniMethodCloseBracketIdx = methodSource.indexOf(")");
                String tempString = methodSource.substring(jsniMethodCloseBracketIdx, jsniMethodOpenIdx);
                if (tempString.trim().length() != 1) {
                    methodSource = methodSource.substring(0, jsniMethodOpenIdx - 1);
                } else {
                    int nextJsniMethodOpenIdx = methodSource.substring(jsniMethodOpenIdx + 4).indexOf(JSNI_METHOD_OPEN_BRACE);
                    if (nextJsniMethodOpenIdx != -1) {
                        methodSource = methodSource.substring(0, (nextJsniMethodOpenIdx += jsniMethodOpenIdx + 4) - 1);
                    }
                }
            }
            if (methodSource.indexOf("}-*/;") != -1) {
                return NO_PROPOSALS;
            }
            int numCharsFilled = 0;
            int numCharsToOverwrite = 0;
            String tempString = "";
            if (methodSource.substring(methodSource.indexOf(")") + 1).trim().indexOf("/") != -1) {
                tempString = methodSource.substring(methodSource.indexOf(")"), methodSource.indexOf("/"));
            }
            if (methodSource.substring(methodSource.indexOf(")") + 1).trim().indexOf("/") == 0 && tempString.indexOf(10) == -1) {
                int jsniMethodOpenSlashIdx = methodSource.indexOf("/");
                if (jsniMethodOpenSlashIdx > invocationIdx) {
                    return NO_PROPOSALS;
                }
                String jsniCompletedString = methodSource.substring(jsniMethodOpenSlashIdx, invocationIdx);
                if (jsniCompletedString.indexOf(JSNI_METHOD_OPEN_BRACE) != -1) {
                    jsniCompletedString = jsniCompletedString.trim();
                }
                if (!JSNI_METHOD_OPEN_BRACE.startsWith(jsniCompletedString)) return NO_PROPOSALS;
                numCharsFilled = jsniCompletedString.length();
            } else {
                int jsniMethodCloseBracketIdx = methodSource.indexOf(")") + 1;
                if (jsniMethodCloseBracketIdx > invocationIdx) {
                    return NO_PROPOSALS;
                }
                if (methodSource.substring(jsniMethodCloseBracketIdx, invocationIdx).trim().length() != 0) {
                    return NO_PROPOSALS;
                }
            }
            methodSource = methodSource.substring(invocationIdx);
            int endIdx = methodSource.length();
            if (methodSource.indexOf(" ") != -1) {
                endIdx = methodSource.indexOf(" ");
                if (methodSource.indexOf("\n") != -1 && endIdx > methodSource.indexOf("\n")) {
                    endIdx = methodSource.indexOf("\n");
                }
            } else if (methodSource.indexOf("\n") != -1) {
                endIdx = methodSource.indexOf("\n");
            }
            numCharsToOverwrite = methodSource.substring(0, endIdx).trim().length();
            IDocument document = jcaic.getDocument();
            int lineOfInvocationOffset = document.getLineOfOffset(invocationOffset);
            int lineOffset = document.getLineOffset(lineOfInvocationOffset);
            IJavaProject project = jcaic.getProject();
            int indentationUnits = JsniMethodBodyCompletionProposalComputer.measureIndentationUnits(document, lineOfInvocationOffset, lineOffset, project);
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            this.proposeEmptyJsniBlock(project, method, invocationOffset, indentationUnits, proposals, numCharsFilled, numCharsToOverwrite);
            boolean isStatic = Flags.isStatic((int)flags);
            if (method.getReturnType().equals("V")) {
                this.proposeSetters(project, method, invocationOffset, indentationUnits, isStatic, proposals, numCharsFilled, numCharsToOverwrite);
                return proposals;
            } else {
                this.proposeGetters(project, method, invocationOffset, indentationUnits, isStatic, proposals, numCharsFilled, numCharsToOverwrite);
            }
            return proposals;
        }
        catch (JavaModelException javaModelException) {
            return NO_PROPOSALS;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return NO_PROPOSALS;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return NO_CONTEXTS;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }

    private void maybeProposeIndexedPropertyRead(IJavaProject project, IMethod method, int invocationOffset, int indentationUnits, List<ICompletionProposal> proposals, String propertyName, String[] parameterNames, boolean isStatic, int numCharsFilled, int numCharsToOverwrite) throws JavaModelException {
        if (parameterNames.length != 1) {
            return;
        }
        String indexParameterType = method.getParameterTypes()[0];
        if (JsniMethodBodyCompletionProposalComputer.isIndexType(indexParameterType)) {
            String expression = "return " + JsniMethodBodyCompletionProposalComputer.createJsIndexedPropertyReadExpression(propertyName, parameterNames[0], isStatic) + ";";
            String code = JsniMethodBodyCompletionProposalComputer.createJsniBlock(project, expression, indentationUnits);
            proposals.add((ICompletionProposal)JsniMethodBodyCompletionProposalComputer.createProposal(method.getFlags(), code, invocationOffset, numCharsFilled, numCharsToOverwrite, expression));
        }
    }

    private void maybeProposeIndexedPropertyWrite(IJavaProject project, IMethod method, String propertyName, int invocationOffset, int indentationUnits, boolean isStatic, List<ICompletionProposal> proposals, int numCharsFilled, int numCharsToOverwrite) throws JavaModelException {
        String[] parameterNames = method.getParameterNames();
        if (parameterNames.length != 2) {
            return;
        }
        String indexParameterType = method.getParameterTypes()[0];
        if (JsniMethodBodyCompletionProposalComputer.isIndexType(indexParameterType)) {
            String expression = JsniMethodBodyCompletionProposalComputer.createJsIndexedPropertyWriteExpression(propertyName, parameterNames[0], parameterNames[1], isStatic);
            String code = JsniMethodBodyCompletionProposalComputer.createJsniBlock(project, expression, indentationUnits);
            proposals.add((ICompletionProposal)JsniMethodBodyCompletionProposalComputer.createProposal(method.getFlags(), code, invocationOffset, numCharsFilled, numCharsToOverwrite, expression));
        }
    }

    private void maybeProposePropertyRead(IJavaProject project, IMethod method, String propertyName, int invocationOffset, int indentationUnits, boolean isStatic, List<ICompletionProposal> proposals, int numCharsFilled, int numCharsToOverwrite) throws JavaModelException {
        String[] parameterNames = method.getParameterNames();
        if (parameterNames.length == 0 && propertyName.length() > 0) {
            String expression = "return " + JsniMethodBodyCompletionProposalComputer.createJsPropertyReadExpression(propertyName, isStatic);
            String code = JsniMethodBodyCompletionProposalComputer.createJsniBlock(project, expression, indentationUnits);
            proposals.add((ICompletionProposal)JsniMethodBodyCompletionProposalComputer.createProposal(method.getFlags(), code, invocationOffset, numCharsFilled, numCharsToOverwrite, expression));
        }
    }

    private void maybeProposePropertyWrite(IJavaProject project, IMethod method, String propertyName, int invocationOffset, int indentationUnits, boolean isStatic, List<ICompletionProposal> proposals, int numCharsFilled, int numCharsToOverwrite) throws JavaModelException {
        String[] parameterNames = method.getParameterNames();
        if (parameterNames.length == 1 && propertyName.length() > 0) {
            String expression = JsniMethodBodyCompletionProposalComputer.createJsPropertyWriteExpression(propertyName, parameterNames[0], isStatic);
            String code = JsniMethodBodyCompletionProposalComputer.createJsniBlock(project, expression, indentationUnits);
            proposals.add((ICompletionProposal)JsniMethodBodyCompletionProposalComputer.createProposal(method.getFlags(), code, invocationOffset, numCharsFilled, numCharsToOverwrite, expression));
        }
    }

    private void proposeEmptyJsniBlock(IJavaProject project, IMethod method, int invocationOffset, int indentationUnits, List<ICompletionProposal> proposals, int numCharsFilled, int numCharsToOverwrite) throws JavaModelException {
        String code = JsniMethodBodyCompletionProposalComputer.createJsniBlock(project, "", indentationUnits);
        int cursorPosition = CodeFormatterUtil.createIndentString((int)(indentationUnits + 1), (IJavaProject)project).length() + (5 - numCharsFilled);
        JavaCompletionProposal javaCompletionProposal = JsniMethodBodyCompletionProposalComputer.createProposal(method.getFlags(), code, invocationOffset, numCharsFilled, numCharsToOverwrite, "");
        javaCompletionProposal.setCursorPosition(cursorPosition);
        proposals.add((ICompletionProposal)javaCompletionProposal);
    }

    private void proposeGetterDelegate(IJavaProject project, IMethod method, int invocationOffset, int indentationUnits, boolean isStatic, List<ICompletionProposal> proposals, int numCharsFilled, int numCharsToOverwrite) throws JavaModelException {
        String methodName = method.getElementName();
        String[] parameterNames = method.getParameterNames();
        String expression = "return " + JsniMethodBodyCompletionProposalComputer.createJsMethodInvocationExpression(methodName, isStatic, parameterNames);
        String code = JsniMethodBodyCompletionProposalComputer.createJsniBlock(project, expression, indentationUnits);
        proposals.add((ICompletionProposal)JsniMethodBodyCompletionProposalComputer.createProposal(method.getFlags(), code, invocationOffset, numCharsFilled, numCharsToOverwrite, expression));
    }

    private void proposeGetters(IJavaProject project, IMethod method, int invocationOffset, int indentationUnits, boolean isStatic, List<ICompletionProposal> proposals, int numCharsFilled, int numCharsToOverwrite) throws JavaModelException {
        String methodName;
        this.proposeGetterDelegate(project, method, invocationOffset, indentationUnits, isStatic, proposals, numCharsFilled, numCharsToOverwrite);
        String propertyName = methodName = method.getElementName();
        if (methodName.startsWith("get")) {
            propertyName = JsniMethodBodyCompletionProposalComputer.computePropertyNameFromAccessorMethodName("get", methodName);
        } else if (methodName.startsWith("is")) {
            propertyName = JsniMethodBodyCompletionProposalComputer.computePropertyNameFromAccessorMethodName("is", methodName);
        }
        String[] parameterNames = method.getParameterNames();
        if (propertyName != methodName && propertyName.length() > 0) {
            String expression = "return " + JsniMethodBodyCompletionProposalComputer.createJsMethodInvocationExpression(propertyName, isStatic, parameterNames);
            String code = JsniMethodBodyCompletionProposalComputer.createJsniBlock(project, expression, indentationUnits);
            proposals.add((ICompletionProposal)JsniMethodBodyCompletionProposalComputer.createProposal(method.getFlags(), code, invocationOffset, numCharsFilled, numCharsToOverwrite, expression));
        }
        this.maybeProposePropertyRead(project, method, propertyName, invocationOffset, indentationUnits, isStatic, proposals, numCharsFilled, numCharsToOverwrite);
        this.maybeProposeIndexedPropertyRead(project, method, invocationOffset, indentationUnits, proposals, propertyName, parameterNames, isStatic, numCharsFilled, numCharsToOverwrite);
    }

    private void proposeSetterDelegate(IJavaProject project, IMethod method, int invocationOffset, int indentationUnits, boolean isStatic, List<ICompletionProposal> proposals, int numCharsFilled, int numCharsToOverwrite) throws JavaModelException {
        String[] parameterNames = method.getParameterNames();
        String expression = JsniMethodBodyCompletionProposalComputer.createJsMethodInvocationExpression(method.getElementName(), isStatic, parameterNames);
        String code = JsniMethodBodyCompletionProposalComputer.createJsniBlock(project, expression, indentationUnits);
        proposals.add((ICompletionProposal)JsniMethodBodyCompletionProposalComputer.createProposal(method.getFlags(), code, invocationOffset, numCharsFilled, numCharsToOverwrite, expression));
    }

    private void proposeSetters(IJavaProject project, IMethod method, int invocationOffset, int indentationUnits, boolean isStatic, List<ICompletionProposal> proposals, int numCharsFilled, int numCharsToOverwrite) throws JavaModelException {
        String methodName;
        this.proposeSetterDelegate(project, method, invocationOffset, indentationUnits, isStatic, proposals, numCharsFilled, numCharsToOverwrite);
        String[] parameterNames = method.getParameterNames();
        String propertyName = methodName = method.getElementName();
        if (methodName.startsWith("set") && (propertyName = JsniMethodBodyCompletionProposalComputer.computePropertyNameFromAccessorMethodName("set", methodName)).length() > 0) {
            String expression = JsniMethodBodyCompletionProposalComputer.createJsMethodInvocationExpression(propertyName, isStatic, parameterNames);
            String code = JsniMethodBodyCompletionProposalComputer.createJsniBlock(project, expression, indentationUnits);
            proposals.add((ICompletionProposal)JsniMethodBodyCompletionProposalComputer.createProposal(method.getFlags(), code, invocationOffset, numCharsFilled, numCharsToOverwrite, expression));
        }
        this.maybeProposePropertyWrite(project, method, propertyName, invocationOffset, indentationUnits, isStatic, proposals, numCharsFilled, numCharsToOverwrite);
        this.maybeProposeIndexedPropertyWrite(project, method, propertyName, invocationOffset, indentationUnits, isStatic, proposals, numCharsFilled, numCharsToOverwrite);
    }
}

