/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.editors.java;

import com.google.gwt.eclipse.core.editors.java.JsniColorConstants;
import java.util.ArrayList;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class JsniScanner
extends RuleBasedScanner {
    private static final String[] JS_KEYWORDS = new String[]{"break", "case", "catch", "continue", "default", "delete", "do", "else", "false", "finally", "for", "function", "if", "in", "instanceof", "new", "null", "return", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "with"};

    public JsniScanner(IColorManager colorManager) {
        Token jsniJavaRef = new Token((Object)new TextAttribute(colorManager.getColor(JsniColorConstants.JSNI_JAVA_REF)));
        Token jsniComment = new Token((Object)new TextAttribute(colorManager.getColor("java_single_line_comment")));
        Token jsniKeyword = new Token((Object)new TextAttribute(colorManager.getColor("java_keyword")));
        Token jsniDefault = new Token((Object)new TextAttribute(colorManager.getColor("java_default")));
        Token jsniString = new Token((Object)new TextAttribute(colorManager.getColor("java_string")));
        ArrayList<JavaRefRule> rules = new ArrayList<JavaRefRule>();
        rules.add(new JavaRefRule((IToken)jsniJavaRef));
        rules.add((JavaRefRule)new EndOfLineRule("//", (IToken)jsniComment));
        WordRule keywordRules = new WordRule((IWordDetector)new JsWordDetector(), (IToken)jsniDefault);
        String[] stringArray = JS_KEYWORDS;
        int n = JS_KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            keywordRules.addWord(keyword, (IToken)jsniKeyword);
            ++n2;
        }
        rules.add((JavaRefRule)keywordRules);
        rules.add((JavaRefRule)new SingleLineRule("\"", "\"", (IToken)jsniString, '\\', true));
        rules.add((JavaRefRule)new SingleLineRule("'", "'", (IToken)jsniString, '\\', true));
        rules.add((JavaRefRule)new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    private static class JavaRefRule
    extends PatternRule {
        public JavaRefRule(IToken token) {
            super("@", "(", token, '/', true);
        }

        protected JavaRefRule(String startSequence, String endSequence, IToken token, char escapeChar, boolean endOnEOF) {
            super(startSequence, endSequence, token, escapeChar, endOnEOF);
        }

        protected boolean endSequenceDetected(ICharacterScanner scanner) {
            int c = 0;
            int readCount = 1;
            while ((c = scanner.read()) != -1) {
                if (!this.isValidJavaRefCharacter((char)c)) {
                    scanner.unread();
                    return true;
                }
                ++readCount;
            }
            while (--readCount > 0) {
                scanner.unread();
            }
            return super.endSequenceDetected(scanner);
        }

        private boolean isValidJavaRefCharacter(char c) {
            if (Character.isJavaIdentifierPart(c)) {
                return true;
            }
            return c == ':' || c == '.';
        }
    }

    private static class JsWordDetector
    implements IWordDetector {
        private JsWordDetector() {
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }

    private static class WhitespaceDetector
    implements IWhitespaceDetector {
        private WhitespaceDetector() {
        }

        public boolean isWhitespace(char c) {
            return Character.isWhitespace(c);
        }
    }
}

