/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.editors.java.contentassist;

import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.editors.java.contentassist.JsniCompletionProposalCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class JsniCompletionProcessor
implements IContentAssistProcessor {
    private static final char[] ACTIVATION_CHARS = new char[]{'.', ':'};
    private static final Pattern MEMBER_REF_START = Pattern.compile("(\\.?)@([^:]+)::(\\w*)$");
    private static final Pattern PACKAGE_OR_TYPE_REF_START = Pattern.compile("@([\\w\\.]+)$");
    private static final String THIS_DOT = "this.";
    private final ICompilationUnit cu;

    private static String getJavaCtorRefFragment(String qualifiedTypeName) {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        sb.append(Signature.getSimpleName((String)qualifiedTypeName));
        sb.append("(");
        return sb.toString();
    }

    private static String getJavaMethodOrFieldRefFragment(String qualifiedTypeName, String memberNameFragment, boolean isStatic) {
        if (isStatic) {
            return String.valueOf(qualifiedTypeName) + "." + memberNameFragment;
        }
        return THIS_DOT + memberNameFragment;
    }

    public JsniCompletionProcessor(ICompilationUnit cu) {
        this.cu = cu;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IJavaCompletionProposal[] proposals = null;
        try {
            IDocument document = viewer.getDocument();
            int line = document.getLineOfOffset(offset);
            int lineStartOffset = document.getLineOffset(line);
            String jsLine = document.get(lineStartOffset, offset - lineStartOffset);
            String lineBefore = document.get(document.getLineOffset(line - 1), document.getLineLength(line - 1)).trim();
            if (THIS_DOT.equals(lineBefore)) {
                jsLine = THIS_DOT + jsLine.trim();
            }
            if ((proposals = this.computePackageAndTypeProposals(jsLine, lineStartOffset, offset)) == null) {
                proposals = this.computeMemberProposals(jsLine, lineStartOffset, offset);
            }
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e);
        }
        catch (BadLocationException e) {
            GWTPluginLog.logError(e);
        }
        if (proposals != null) {
            Arrays.sort(proposals, new CompletionProposalComparator());
        }
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private IJavaCompletionProposal[] codeComplete(String qualifiedTypeName, String snippet, CompletionProposalCollector requestor) throws JavaModelException {
        IJavaCompletionProposal[] proposals = new IJavaCompletionProposal[]{};
        IType type = this.cu.getJavaProject().findType(qualifiedTypeName);
        if (type != null) {
            boolean isStatic = false;
            type.codeComplete(snippet.toCharArray(), -1, snippet.length(), new char[0][0], new char[0][0], new int[0], isStatic, (CompletionRequestor)requestor);
            proposals = requestor.getJavaCompletionProposals();
        }
        return proposals;
    }

    private IJavaCompletionProposal[] computeCtorProposals(String qualifiedTypeName, CompletionProposalCollector requestor) throws JavaModelException {
        String javaCtorFragment = JsniCompletionProcessor.getJavaCtorRefFragment(qualifiedTypeName);
        return this.codeComplete(qualifiedTypeName, javaCtorFragment, requestor);
    }

    private IJavaCompletionProposal[] computeMemberProposals(String js, int lineStartOffset, int cursorOffset) throws JavaModelException {
        Matcher matcher = MEMBER_REF_START.matcher(js);
        if (!matcher.find()) {
            return null;
        }
        boolean isStatic = !matcher.group(1).equals(".");
        String qualifiedTypeName = matcher.group(2);
        String memberNameFragment = matcher.group(3);
        int refOffset = matcher.start(3) + lineStartOffset;
        int refLength = cursorOffset - refOffset;
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        IJavaCompletionProposal[] methodAndFieldProposals = this.computeMethodAndFieldProposals(qualifiedTypeName, memberNameFragment, isStatic, JsniCompletionProposalCollector.createMemberProposalCollector(this.cu, refOffset, refLength, qualifiedTypeName));
        proposals.addAll(Arrays.asList(methodAndFieldProposals));
        if (isStatic && "new".startsWith(memberNameFragment)) {
            IJavaCompletionProposal[] ctorProposals = this.computeCtorProposals(qualifiedTypeName, JsniCompletionProposalCollector.createMemberProposalCollector(this.cu, refOffset, refLength, qualifiedTypeName));
            proposals.addAll(Arrays.asList(ctorProposals));
        }
        return proposals.toArray(new IJavaCompletionProposal[0]);
    }

    private IJavaCompletionProposal[] computeMethodAndFieldProposals(String qualifiedTypeName, String memberNameFragment, boolean isStatic, CompletionProposalCollector requestor) throws JavaModelException {
        String javaMethodOrFieldFragment = JsniCompletionProcessor.getJavaMethodOrFieldRefFragment(qualifiedTypeName, memberNameFragment, isStatic);
        return this.codeComplete(qualifiedTypeName, javaMethodOrFieldFragment, requestor);
    }

    private IJavaCompletionProposal[] computePackageAndTypeProposals(String js, int lineStartOffset, int cursorOffset) throws JavaModelException {
        Matcher matcher = PACKAGE_OR_TYPE_REF_START.matcher(js);
        if (!matcher.find()) {
            return null;
        }
        int refOffset = matcher.start(1) + lineStartOffset;
        int refLength = cursorOffset - refOffset;
        String partialRef = matcher.group(1);
        CompletionProposalCollector requestor = JsniCompletionProposalCollector.createPackageAndTypeProposalCollector(this.cu, refOffset, refLength);
        IEvaluationContext evalContext = this.createEvaluationContext();
        evalContext.codeComplete(partialRef, partialRef.length(), (CompletionRequestor)requestor);
        return requestor.getJavaCompletionProposals();
    }

    private IEvaluationContext createEvaluationContext() throws JavaModelException {
        IJavaProject project = this.cu.getJavaProject();
        IEvaluationContext evalContext = project.newEvaluationContext();
        String pckgName = this.cu.getPackageDeclarations()[0].getElementName();
        evalContext.setPackageName(pckgName);
        return evalContext;
    }
}

