/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.editors.java.contentassist;

import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

class JsniCompletionProposal
extends com.google.gwt.eclipse.platform.editors.java.contentassist.JsniCompletionProposal {
    private final IJavaProject javaProject;
    private int replaceLength;
    private int replaceOffset;
    private String replaceString;

    public static IJavaCompletionProposal create(IJavaCompletionProposal jdtProposal, CompletionProposal wrappedProposal, IJavaProject javaProject, int replaceOffset, int replaceLength) {
        switch (wrappedProposal.getKind()) {
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                return new JsniCompletionProposal(jdtProposal, wrappedProposal, javaProject, replaceOffset, replaceLength);
            }
        }
        return null;
    }

    private static String getParamTypesSignature(CompletionProposal proposal) {
        Object[] paramTypes = Signature.getParameterTypes((String)new String(proposal.getSignature()));
        return StringUtilities.join((Object[])paramTypes, (String)"").replace('.', '/');
    }

    private JsniCompletionProposal(IJavaCompletionProposal jdtProposal, CompletionProposal wrappedProposal, IJavaProject javaProject, int replaceOffset, int replaceLength) {
        super(jdtProposal, wrappedProposal);
        this.javaProject = javaProject;
        this.replaceOffset = replaceOffset;
        this.replaceLength = replaceLength;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.replaceOffset, this.replaceLength, this.getReplaceString());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getAdditionalProposalInfo() {
        return this.jdtProposal.getAdditionalProposalInfo();
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return this.getAdditionalProposalInfo();
    }

    public IContextInformation getContextInformation() {
        return this.jdtProposal.getContextInformation();
    }

    public String getDisplayString() {
        String displayString = this.jdtProposal.getDisplayString();
        if (this.wrappedProposal.isConstructor()) {
            displayString = JsniCompletionProposal.fixCtorDisplayString((String)displayString);
        }
        return displayString;
    }

    public Image getImage() {
        return this.jdtProposal.getImage();
    }

    public IInformationControlCreator getInformationControlCreator() {
        return ((ICompletionProposalExtension3)this.jdtProposal).getInformationControlCreator();
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return 0;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return null;
    }

    public int getRelevance() {
        return this.jdtProposal.getRelevance();
    }

    public Point getSelection(IDocument document) {
        return new Point(this.replaceOffset + this.getReplaceString().length(), 0);
    }

    private String computeCtorCompletion() {
        StringBuilder sb = new StringBuilder();
        sb.append("new");
        sb.append('(');
        try {
            IJavaElement typeParent;
            String qualifiedTypeName = Signature.toString((String)new String(this.wrappedProposal.getDeclarationSignature()));
            IType type = this.javaProject.findType(qualifiedTypeName);
            if (type != null && (typeParent = type.getParent()).getElementType() == 7 && !Flags.isStatic((int)type.getFlags())) {
                String outerTypeName = ((IType)typeParent).getFullyQualifiedName();
                String outerTypeSig = Signature.createTypeSignature((String)outerTypeName, (boolean)true).replace('.', '/');
                sb.append(outerTypeSig);
            }
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e);
        }
        sb.append(JsniCompletionProposal.getParamTypesSignature(this.wrappedProposal));
        sb.append(')');
        return sb.toString();
    }

    private String computeFieldCompletion() {
        return new String(this.wrappedProposal.getCompletion());
    }

    private String computeMethodCompletion() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.wrappedProposal.getName());
        sb.append('(');
        sb.append(JsniCompletionProposal.getParamTypesSignature(this.wrappedProposal));
        sb.append(')');
        return sb.toString();
    }

    private String computePackageCompletion() {
        return new String(this.wrappedProposal.getCompletion());
    }

    private String computeTypeCompletion() {
        return Signature.toString((String)new String(this.wrappedProposal.getSignature()));
    }

    private String createReplaceString() {
        switch (this.wrappedProposal.getKind()) {
            case 8: {
                return this.computePackageCompletion();
            }
            case 9: {
                return this.computeTypeCompletion();
            }
            case 2: {
                return this.computeFieldCompletion();
            }
            case 6: {
                if (this.wrappedProposal.isConstructor()) {
                    return this.computeCtorCompletion();
                }
                return this.computeMethodCompletion();
            }
        }
        return "";
    }

    private String getReplaceString() {
        if (this.replaceString == null) {
            this.replaceString = this.createReplaceString();
        }
        return this.replaceString;
    }
}

