/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.editors.java.contentassist;

import com.google.gwt.eclipse.core.editors.java.contentassist.JsniCompletionProposal;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;

class JsniCompletionProposalCollector
extends CompletionProposalCollector {
    private String qualifiedTypeName;
    private final int refLength;
    private final int refOffset;

    public static CompletionProposalCollector createMemberProposalCollector(ICompilationUnit cu, int refOffset, int refLength, String refQualifiedTypeName) {
        JsniCompletionProposalCollector collector = new JsniCompletionProposalCollector(cu, refOffset, refLength);
        collector.setIgnored(8, true);
        collector.setIgnored(9, true);
        collector.setQualifiedTypeName(refQualifiedTypeName);
        return collector;
    }

    public static CompletionProposalCollector createPackageAndTypeProposalCollector(ICompilationUnit cu, int refOffset, int refLength) {
        JsniCompletionProposalCollector collector = new JsniCompletionProposalCollector(cu, refOffset, refLength);
        collector.setIgnored(6, true);
        collector.setIgnored(2, true);
        return collector;
    }

    private JsniCompletionProposalCollector(ICompilationUnit cu, int refOffset, int refLength) {
        super(cu);
        this.refOffset = refOffset;
        this.refLength = refLength;
        this.setIgnored(1, true);
    }

    protected IJavaCompletionProposal createJavaCompletionProposal(CompletionProposal proposal) {
        IJavaCompletionProposal defaultProposal = super.createJavaCompletionProposal(proposal);
        if (proposal.getKind() == 6 || proposal.getKind() == 2) {
            char[] typeSignature = Signature.createTypeSignature((String)this.qualifiedTypeName, (boolean)true).toCharArray();
            proposal.setDeclarationSignature(typeSignature);
        }
        return JsniCompletionProposal.create(defaultProposal, proposal, this.getCompilationUnit().getJavaProject(), this.refOffset, this.refLength);
    }

    private void setQualifiedTypeName(String qualifiedTypeName) {
        this.qualifiedTypeName = qualifiedTypeName;
    }
}

