/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.formatter;

import java.util.LinkedList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;

public abstract class AbstractFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList<IDocument> documents = new LinkedList();
    private final LinkedList<TypedPosition> partitions = new LinkedList();

    public void format() {
        super.format();
        IDocument document = this.documents.removeFirst();
        TypedPosition partition = this.partitions.removeFirst();
        if (document == null || partition == null) {
            return;
        }
        this.format(document, partition);
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        IDocument document = (IDocument)context.getProperty((Object)"formatting.context.medium");
        TypedPosition position = (TypedPosition)context.getProperty((Object)"formatting.context.partition");
        this.partitions.addLast(position);
        this.documents.addLast(document);
    }

    public void formatterStops() {
        super.formatterStops();
        this.partitions.clear();
        this.documents.clear();
    }

    protected abstract void format(IDocument var1, TypedPosition var2);
}

