/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch;

import com.google.gdt.eclipse.core.launch.LaunchConfigurationUtilities;
import com.google.gdt.eclipse.core.sdk.SdkUtils;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfiguration;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;

public class GWTJUnitLaunchDelegate
extends JUnitLaunchConfigurationDelegate {
    public static final String LAUNCH_TYPE_ID = "com.gwtplugins.gwt.eclipse.core.launch.gwtJUnit";

    public static boolean getStandardsMode(ILaunchConfiguration config) {
        Throwable t;
        block7: {
            block6: {
                boolean fallbackValue = false;
                t = null;
                if (GWTJUnitLaunchDelegate.isGwtSdkVersionAtLeast("2.0.0", config)) break block6;
                return false;
            }
            try {
                return config.getAttribute("com.gwtplugins.gwt.eclipse.core.STANDARDS_MODE", false);
            }
            catch (NumberFormatException e) {
                t = e;
            }
            catch (JavaModelException e) {
                t = e;
            }
            catch (CoreException e) {
                if (e.getStatus().getSeverity() <= 1) break block7;
                t = e;
            }
        }
        if (t != null) {
            GWTPluginLog.logError(t, "Could not determine whether to use standards mode");
        }
        return false;
    }

    public static boolean isGwtSdkVersionAtLeast(String minVersion, ILaunchConfiguration config) throws CoreException {
        IJavaProject javaProject = LaunchConfigurationUtilities.getJavaProject((ILaunchConfiguration)config);
        if (javaProject == null) {
            throw new CoreException((IStatus)new Status(1, "com.gwtplugins.gwt.eclipse.core", "No Java project set on launch configuration"));
        }
        GwtSdk sdk = GwtSdk.findSdkFor(javaProject);
        if (sdk == null || !sdk.validate().isOK()) {
            throw new CoreException((IStatus)new Status(1, "com.gwtplugins.gwt.eclipse.core", "GWT SDK not found or isn't valid"));
        }
        String version = sdk.getVersion();
        return version.equals("0.0.0") || SdkUtils.compareVersionStrings((String)version, (String)minVersion) >= 0;
    }

    public static boolean isJUnitLaunchConfig(ILaunchConfigurationType launchConfigType) {
        return LAUNCH_TYPE_ID.equals(launchConfigType.getIdentifier());
    }

    private static String getGWTJUnitProgramArgs(ILaunchConfiguration config) throws CoreException {
        String webMode;
        boolean notHeadless;
        String outDir;
        String obfuscation;
        StringBuilder argsBuilder = new StringBuilder();
        String logLevel = config.getAttribute("com.gwtplugins.gwt.eclipse.core.LOG_LEVEL", "");
        if (logLevel.length() > 0) {
            argsBuilder.append(" -logLevel ");
            argsBuilder.append(logLevel);
        }
        if ((obfuscation = config.getAttribute("com.gwtplugins.gwt.eclipse.core.STYLE", "")).length() > 0) {
            argsBuilder.append(" -style ");
            argsBuilder.append(obfuscation);
        }
        if ((outDir = config.getAttribute("com.gwtplugins.gwt.eclipse.core.OUT_DIR", "")).length() > 0) {
            argsBuilder.append(" -war ");
            argsBuilder.append("\"" + outDir + "\"");
        }
        if (notHeadless = config.getAttribute("com.gwtplugins.gwt.eclipse.core.NOT_HEADLESS", false)) {
            argsBuilder.append(" -notHeadless");
        }
        if (Boolean.parseBoolean(webMode = config.getAttribute("com.gwtplugins.gwt.eclipse.core.WEB_MODE", "false"))) {
            argsBuilder.append(" -web");
        }
        if (GWTJUnitLaunchDelegate.getStandardsMode(config)) {
            try {
                if (!GWTJUnitLaunchDelegate.isGwtSdkVersionAtLeast("2.5.0", config)) {
                    argsBuilder.append(" -standardsMode");
                }
            }
            catch (CoreException e) {
                GWTPluginLog.logWarning(e, "Could not determine whether to use -standardsMode, skipping");
            }
        }
        return argsBuilder.toString().trim();
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = this.verifyJavaProject(configuration);
        String gwtArgs = GWTJUnitLaunchDelegate.getGWTJUnitProgramArgs(configuration);
        if (gwtArgs.length() > 0) {
            gwtArgs = " -Dgwt.args=\"" + gwtArgs + '\"';
        }
        String dynamicVMArgs = GWTLaunchConfiguration.computeJunitDynamicVMArgsAsString(javaProject);
        gwtArgs = String.valueOf(gwtArgs) + ' ' + dynamicVMArgs;
        return String.valueOf(gwtArgs) + ' ' + super.getVMArguments(configuration);
    }
}

