/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch;

import com.google.gdt.eclipse.core.AdapterUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.nature.GWTNature;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;

public class GWTJUnitPropertyTester
extends PropertyTester {
    public static final String PROPERTY_IS_GWT_TEST = "isGWTTest";
    private static final String GWT_TEST_CASE = "com.google.gwt.junit.client.GWTTestCase";
    private static final String GWT_TEST_SUITE = "com.google.gwt.junit.tools.GWTTestSuite";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isGWTTestCaseOrSuite(IType type) {
        try {
            IType[] superclasses;
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            IType[] iTypeArray = superclasses = hierarchy.getAllSuperclasses(type);
            int n = superclasses.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IType superclass = iTypeArray[n2];
                if (GWT_TEST_CASE.equals(superclass.getFullyQualifiedName()) || GWT_TEST_SUITE.equals(superclass.getFullyQualifiedName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e);
            return false;
        }
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IJavaElement element = (IJavaElement)AdapterUtilities.getAdapter((Object)receiver, IJavaElement.class);
        if (element == null) {
            return false;
        }
        if (!GWTNature.isGWTProject(element.getJavaProject().getProject())) {
            return false;
        }
        if (PROPERTY_IS_GWT_TEST.equals(property)) {
            IType testType = null;
            if (element instanceof ICompilationUnit) {
                testType = ((ICompilationUnit)element).findPrimaryType();
            } else if (element instanceof IClassFile) {
                testType = ((IClassFile)element).getType();
            } else if (element instanceof IType) {
                testType = (IType)element;
            } else if (element instanceof IMember) {
                testType = ((IMember)element).getDeclaringType();
            }
            return testType != null && GWTJUnitPropertyTester.isGWTTestCaseOrSuite(testType);
        }
        return false;
    }
}

