/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch;

import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.launch.GWTLaunchAttributes;
import com.google.gwt.eclipse.core.runtime.GWTProjectsRuntime;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class GWTLaunchConfiguration {
    public static List<String> computeCompileDynamicVMArgsAsList(IJavaProject javaProject) {
        return GWTLaunchConfiguration.computeDynamicVMArgs(javaProject);
    }

    public static List<String> computeJunitDynamicVMArgsAsList(IJavaProject javaProject) {
        List<String> out = GWTLaunchConfiguration.computeDynamicVMArgs(javaProject);
        out.add("-Xmx1g");
        return out;
    }

    public static String computeJunitDynamicVMArgsAsString(IJavaProject javaProject) {
        return StringUtilities.join(GWTLaunchConfiguration.computeJunitDynamicVMArgsAsList(javaProject), (String)" ");
    }

    public static String getClassicDevModeCodeServerPort(ILaunchConfiguration launchConfiguration) throws CoreException {
        return GWTLaunchConfiguration.getStringAttribute(launchConfiguration, GWTLaunchAttributes.CLASSIC_DEVMODE_CODE_SERVER_PORT);
    }

    public static boolean getClassicDevModeCodeServerPortAuto(ILaunchConfiguration launchConfiguration) throws CoreException {
        return GWTLaunchConfiguration.getBooleanAttribute(launchConfiguration, GWTLaunchAttributes.CLASSIC_DEVMODE_CODE_SERVER_PORT_AUTO);
    }

    public static List<String> getEntryPointModules(ILaunchConfiguration launchConfiguration) throws CoreException {
        return GWTLaunchConfiguration.getListAttribute(launchConfiguration, GWTLaunchAttributes.ENTRY_POINT_MODULES);
    }

    public static String getLogLevel(ILaunchConfiguration launchConfiguration) throws CoreException {
        return GWTLaunchConfiguration.getStringAttribute(launchConfiguration, GWTLaunchAttributes.LOG_LEVEL);
    }

    public static String getOutputStyle(ILaunchConfiguration launchConfiguration) throws CoreException {
        return GWTLaunchConfiguration.getStringAttribute(launchConfiguration, GWTLaunchAttributes.OUTPUT_STYLE);
    }

    public static IPath getSdkContainerPath(ILaunchConfiguration launchConfiguration) throws CoreException {
        String pathAsString = GWTLaunchConfiguration.getStringAttribute(launchConfiguration, GWTLaunchAttributes.SDK_CONTAINER_PATH);
        return new Path(pathAsString);
    }

    public static String getSdmCodeServerPort(ILaunchConfiguration launchConfiguration) throws CoreException {
        return GWTLaunchConfiguration.getStringAttribute(launchConfiguration, GWTLaunchAttributes.SDM_CODE_SERVER_PORT);
    }

    public static boolean getSuperDevModeEnabled(ILaunchConfiguration launchConfiguration) throws CoreException {
        return GWTLaunchConfiguration.getBooleanAttribute(launchConfiguration, GWTLaunchAttributes.SUPERDEVMODE_ENABLED);
    }

    public static String getStartupUrl(ILaunchConfiguration launchConfiguration) throws CoreException {
        return GWTLaunchConfiguration.getStringAttribute(launchConfiguration, GWTLaunchAttributes.URL);
    }

    public static String getSuperDevModeCodeServerLauncherDir(ILaunchConfiguration launchConfiguration) throws CoreException {
        return GWTLaunchConfiguration.getStringAttribute(launchConfiguration, GWTLaunchAttributes.CODE_SERVER_LAUNCHER_DIR);
    }

    private static List<String> computeDynamicVMArgs(IJavaProject javaProject) {
        ArrayList<String> out = new ArrayList<String>();
        String devJarPath = GWTLaunchConfiguration.maybeGetDevJarPath(javaProject);
        if (devJarPath.length() > 0) {
            out.add("-Dgwt.devjar=\"" + devJarPath + '\"');
        }
        return out;
    }

    private static boolean getBooleanAttribute(ILaunchConfiguration launchConfiguration, GWTLaunchAttributes launchAttribute) throws CoreException {
        return launchConfiguration.getAttribute(launchAttribute.getQualifiedName(), ((Boolean)launchAttribute.getDefaultValue()).booleanValue());
    }

    private static List<String> getListAttribute(ILaunchConfiguration launchConfiguration, GWTLaunchAttributes launchAttribute) throws CoreException {
        return launchConfiguration.getAttribute(launchAttribute.getQualifiedName(), Collections.emptyList());
    }

    private static String getStringAttribute(ILaunchConfiguration launchConfiguration, GWTLaunchAttributes launchAttribute) throws CoreException {
        return launchConfiguration.getAttribute(launchAttribute.getQualifiedName(), (String)launchAttribute.getDefaultValue());
    }

    private static String maybeGetDevJarPath(IJavaProject project) {
        block6: {
            if (!GWTProjectsRuntime.isGWTRuntimeProject(project)) break block6;
            GWTProjectsRuntime tempContribSDK = GWTProjectsRuntime.syntheziseContributorRuntime();
            if (((GwtSdk)tempContribSDK).validate().isOK()) {
                return ((GwtSdk)tempContribSDK).getDevJar().getAbsolutePath();
            }
            return "";
        }
        try {
            GwtSdk sdk = GwtSdk.findSdkFor(project);
            if (sdk.usesGwtDevProject()) {
                File gwtDevJarFile = sdk.getDevJar();
                return gwtDevJarFile.getAbsolutePath();
            }
        }
        catch (Sdk.SdkException sdke) {
            GWTPluginLog.logError(sdke, "Unable to extract gwt dev jar argument from GWTProjectsRuntime");
        }
        catch (JavaModelException jme) {
            GWTPluginLog.logError(jme, "Unable to extract gwt dev jar argument from GWTProjectsRuntime");
        }
        return "";
    }
}

