/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch;

import com.google.gdt.eclipse.core.CorePluginLog;
import com.google.gdt.eclipse.core.launch.ILaunchShortcutStrategy;
import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.launch.ui.LegacyGWTHostPageSelectionDialog;
import com.google.gwt.eclipse.core.modules.IModule;
import com.google.gwt.eclipse.core.modules.ModuleFile;
import com.google.gwt.eclipse.core.modules.ModuleUtils;
import com.google.gwt.eclipse.core.nature.GWTNature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class LegacyGWTLaunchShortcutStrategy
implements ILaunchShortcutStrategy {
    private final Map<IFile, Set<IFile>> allHostPagesByModule = new HashMap<IFile, Set<IFile>>();
    private IFile selectedHostPage;
    private IFile selectedModule;

    public static IPath getPublicRelativeHostPagePath(IFile module, IFile hostPage) {
        List<IFolder> publicFolders = LegacyGWTLaunchShortcutStrategy.getModulePublicFolders(module);
        for (IFolder publicFolder : publicFolders) {
            if (!publicFolder.getFullPath().isPrefixOf(hostPage.getFullPath())) continue;
            return hostPage.getFullPath().removeFirstSegments(publicFolder.getFullPath().segmentCount());
        }
        return null;
    }

    private static Set<IFile> findHostPages(IFile moduleFile) {
        List<IFolder> publicFolders = LegacyGWTLaunchShortcutStrategy.getModulePublicFolders(moduleFile);
        if (publicFolders.isEmpty()) {
            return Collections.emptySet();
        }
        final HashSet<IFile> hostPages = new HashSet<IFile>();
        try {
            for (IFolder publicFolder : publicFolders) {
                publicFolder.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource.getType() == 1 && "html".equalsIgnoreCase(resource.getFileExtension())) {
                            hostPages.add((IFile)resource);
                        }
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            CorePluginLog.logError((Throwable)e);
        }
        return hostPages;
    }

    private static String generateUrl(IFile module, IFile hostPage) {
        String moduleName = ModuleUtils.create(module).getQualifiedName();
        return new Path(moduleName).append(LegacyGWTLaunchShortcutStrategy.getPublicRelativeHostPagePath(module, hostPage)).toString();
    }

    private static List<IFolder> getModulePublicFolders(IFile moduleFile) {
        ModuleFile module = ModuleUtils.create(moduleFile);
        ArrayList<IFolder> publicFolders = new ArrayList<IFolder>();
        for (IPath publicPath : module.getPublicPaths()) {
            publicFolders.add(moduleFile.getParent().getFolder(publicPath));
        }
        return publicFolders;
    }

    private static Shell getShell() {
        return GWTPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public String generateUrl(IResource selection, boolean isExternal) {
        IProject project = selection.getProject();
        assert (GWTNature.isGWTProject(project));
        this.findAllHostPages(project);
        if (this.allHostPagesByModule.size() == 0) {
            MessageDialog.openError((Shell)LegacyGWTLaunchShortcutStrategy.getShell(), (String)"Launch failed", (String)("Could not find any host pages in project " + project.getName() + "."));
            return null;
        }
        this.inferModuleAndHostPage(selection);
        if (this.selectedModule != null && this.selectedHostPage != null && !isExternal) {
            return LegacyGWTLaunchShortcutStrategy.generateUrl(this.selectedModule, this.selectedHostPage);
        }
        return this.getUrlFromUser(project, isExternal);
    }

    public String getUrlFromUser(IResource resource, boolean isExternal) {
        this.findAllHostPages(resource.getProject());
        return this.getUrlFromUser(resource.getProject(), isExternal);
    }

    private Map<String, Set<String>> convertFromFileMapToStringMap(Map<IFile, Set<IFile>> hostPagesByModule) {
        HashMap<String, Set<String>> moduleToPublicRelativeHostPagesStr = new HashMap<String, Set<String>>();
        for (Map.Entry<IFile, Set<IFile>> entry : hostPagesByModule.entrySet()) {
            HashSet<String> publicRelativeHostPagesForModule = new HashSet<String>();
            for (IFile hostPage : entry.getValue()) {
                IPath publicRelativeHostPagePath = LegacyGWTLaunchShortcutStrategy.getPublicRelativeHostPagePath(entry.getKey(), hostPage);
                if (publicRelativeHostPagePath == null) continue;
                publicRelativeHostPagesForModule.add(publicRelativeHostPagePath.toString());
            }
            ModuleFile module = ModuleUtils.create(entry.getKey());
            moduleToPublicRelativeHostPagesStr.put(module.getQualifiedName(), publicRelativeHostPagesForModule);
        }
        return moduleToPublicRelativeHostPagesStr;
    }

    private void findAllHostPages(IProject project) {
        IModule[] projectModules;
        IModule[] iModuleArray = projectModules = ModuleUtils.findAllModules(JavaCore.create((IProject)project), false);
        int n = projectModules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule projectModule = iModuleArray[n2];
            IFile projectModuleFile = ((ModuleFile)projectModule).getFile();
            Set<IFile> moduleHostPages = LegacyGWTLaunchShortcutStrategy.findHostPages(projectModuleFile);
            if (moduleHostPages.size() > 0) {
                this.allHostPagesByModule.put(projectModuleFile, moduleHostPages);
            }
            ++n2;
        }
    }

    private String getUrlFromUser(IProject project, boolean isExternal) {
        Map<IFile, Set<IFile>> hostPagesByModule = this.allHostPagesByModule;
        if (this.selectedModule != null) {
            hostPagesByModule = new HashMap<IFile, Set<IFile>>();
            hostPagesByModule.put(this.selectedModule, this.allHostPagesByModule.get(this.selectedModule));
        }
        if (this.selectedModule != null) {
            hostPagesByModule = new HashMap<IFile, Set<IFile>>();
            hostPagesByModule.put(this.selectedModule, this.allHostPagesByModule.get(this.selectedModule));
        }
        return LegacyGWTHostPageSelectionDialog.getStartupUrl(LegacyGWTLaunchShortcutStrategy.getShell(), project, this.convertFromFileMapToStringMap(hostPagesByModule), isExternal);
    }

    private void inferFromHostPage(IResource selection) {
        this.selectedHostPage = (IFile)selection;
        IFile hostPageModule = null;
        for (IFile module : this.allHostPagesByModule.keySet()) {
            if (!this.allHostPagesByModule.get(module).contains(this.selectedHostPage)) continue;
            if (hostPageModule == null) {
                hostPageModule = module;
                continue;
            }
            return;
        }
        this.selectedModule = hostPageModule;
    }

    private void inferFromModule(IResource selection) {
        this.selectedModule = (IFile)selection;
        Set<IFile> hostPages = this.allHostPagesByModule.get(this.selectedModule);
        if (hostPages.size() == 1) {
            this.selectedHostPage = (IFile)hostPages.toArray()[0];
        }
    }

    private void inferFromProject(IProject project) {
        if (this.allHostPagesByModule.size() == 1) {
            this.selectedModule = (IFile)this.allHostPagesByModule.keySet().toArray()[0];
            Set<IFile> selectedModulesHostPages = this.allHostPagesByModule.get(this.selectedModule);
            if (selectedModulesHostPages.size() == 1) {
                this.selectedHostPage = (IFile)selectedModulesHostPages.toArray()[0];
            }
        }
    }

    private void inferModuleAndHostPage(IResource selection) {
        if (selection.getType() == 1) {
            if ("html".equalsIgnoreCase(selection.getFileExtension())) {
                for (IFile module : this.allHostPagesByModule.keySet()) {
                    if (!this.allHostPagesByModule.get(module).contains(selection)) continue;
                    this.inferFromHostPage(selection);
                }
            } else if (ModuleUtils.isModuleXml(selection) && this.allHostPagesByModule.containsKey(selection)) {
                this.inferFromModule(selection);
            }
        } else if (selection.getType() == 4) {
            this.inferFromProject(selection.getProject());
        }
    }
}

