/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch;

import com.google.common.collect.Lists;
import com.google.gdt.eclipse.core.console.CustomMessageConsole;
import com.google.gdt.eclipse.core.console.MessageConsoleUtilities;
import com.google.gdt.eclipse.core.properties.WebAppProjectProperties;
import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.GWTProjectUtilities;
import com.google.gwt.eclipse.core.launch.GWTJUnitLaunchDelegate;
import com.google.gwt.eclipse.core.launch.ModuleClasspathProviderData;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.runtime.GWTProjectsRuntime;
import com.google.gwt.eclipse.core.runtime.RuntimeClasspathEntryResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardClasspathProvider;
import org.eclipse.ui.console.MessageConsoleStream;

public class ModuleClasspathProvider
extends StandardClasspathProvider {
    private static final String EXTENSION_ID = "com.gwtplugins.gwt.eclipse.core.moduleClasspathProvider";
    private static final String PROVIDER_ID = "com.gwtplugins.gwt.eclipse.core.moduleClasspathProvider";

    public static String computeProviderId(IProject project) {
        ArrayList providers = Lists.newArrayList();
        if (project != null) {
            IConfigurationElement[] extensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor("com.gwtplugins.gwt.eclipse.core.moduleClasspathProvider");
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                ModuleClasspathProviderData entry = new ModuleClasspathProviderData(configurationElement);
                if (entry.isProviderAvailable()) {
                    providers.add(entry);
                }
                ++n2;
            }
            Collections.sort(providers);
            Collections.reverse(providers);
            for (ModuleClasspathProviderData provider : providers) {
                if (provider.getProvider().getProviderId(project) == null) continue;
                return provider.getProvider().getProviderId(project);
            }
        }
        return "com.gwtplugins.gwt.eclipse.core.moduleClasspathProvider";
    }

    private static int findIndexOfFirstUserEntry(List<IRuntimeClasspathEntry> entries) {
        int i = 0;
        int size = entries.size();
        while (i < size) {
            if (entries.get(i).getClasspathProperty() == 3) {
                return i;
            }
            ++i;
        }
        return entries.size();
    }

    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration config) throws CoreException {
        IRuntimeClasspathEntry[] unresolvedClasspathEntries = super.computeUnresolvedClasspath(config);
        IJavaProject proj = JavaRuntime.getJavaProject((ILaunchConfiguration)config);
        if (proj == null || !GWTNature.isGWTProject(proj.getProject())) {
            return unresolvedClasspathEntries;
        }
        boolean useDefault = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        if (!useDefault) {
            return unresolvedClasspathEntries;
        }
        ArrayList<IRuntimeClasspathEntry> defaultRuntimeClasspathEntries = new ArrayList<IRuntimeClasspathEntry>();
        defaultRuntimeClasspathEntries.addAll(Arrays.asList(unresolvedClasspathEntries));
        int srcPathsInsertionIndex = ModuleClasspathProvider.findIndexOfFirstUserEntry(defaultRuntimeClasspathEntries);
        try {
            defaultRuntimeClasspathEntries.addAll(srcPathsInsertionIndex, GWTProjectUtilities.getGWTSourceFolderPathsFromProjectAndDependencies(proj, GWTJUnitLaunchDelegate.isJUnitLaunchConfig(config.getType())));
        }
        catch (Sdk.SdkException e) {
            GWTPluginLog.logError(e);
        }
        return defaultRuntimeClasspathEntries.toArray(new IRuntimeClasspathEntry[defaultRuntimeClasspathEntries.size()]);
    }

    public IRuntimeClasspathEntry[] resolveClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] resolvedEntries = super.resolveClasspath(entries, configuration);
        IJavaProject proj = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        if (GWTProjectsRuntime.isGWTRuntimeProject(proj)) {
            LinkedHashSet<IRuntimeClasspathEntry> all = new LinkedHashSet<IRuntimeClasspathEntry>(entries.length);
            RuntimeClasspathEntryResolver resolver = new RuntimeClasspathEntryResolver();
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = resolvedEntries;
            int n = resolvedEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntimeClasspathEntry resolvedEntry = iRuntimeClasspathEntryArray[n2];
                IRuntimeClasspathEntry[] gwtRuntimeResolvedEntries = resolver.resolveRuntimeClasspathEntry(resolvedEntry, configuration);
                if (gwtRuntimeResolvedEntries.length == 0) {
                    all.add(resolvedEntry);
                } else {
                    all.addAll(Arrays.asList(gwtRuntimeResolvedEntries));
                }
                ++n2;
            }
            resolvedEntries = all.toArray(new IRuntimeClasspathEntry[all.size()]);
        }
        try {
            this.logErrorIfMoreThanGWTSdkOnClassPath(proj, resolvedEntries);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createWarOutDirectory(proj);
        return resolvedEntries;
    }

    private void createWarOutDirectory(IJavaProject project) {
        try {
            IPath warOutPath = WebAppProjectProperties.getLastUsedWarOutLocation((IProject)project.getProject());
            if (warOutPath != null) {
                warOutPath.toFile().mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void logErrorIfMoreThanGWTSdkOnClassPath(IJavaProject project, IRuntimeClasspathEntry[] resolvedEntries) {
        IRuntimeClasspathEntry entry;
        CustomMessageConsole messageConsole = MessageConsoleUtilities.getMessageConsoleKeepLog((String)(String.valueOf(project.getProject().getName()) + "-GWT"), null);
        MessageConsoleStream out = messageConsole.newMessageStream();
        String message = "~~~~~> There is more than one jar on the classpath? Recommended removing one: ";
        int countDupsGwtUser = 0;
        boolean countDupsCodeServer = false;
        int i = 0;
        while (i < resolvedEntries.length) {
            entry = resolvedEntries[i];
            if (entry.getPath().toString().toLowerCase().contains("gwt-") && entry.getType() == 2 && entry.getPath().toString().toLowerCase().contains("gwt-user")) {
                ++countDupsGwtUser;
            }
            ++i;
        }
        if (countDupsCodeServer > true || countDupsGwtUser > 1) {
            out.println("\n\n More than one gwt jar has been found on the classpath. Clear console after fix.");
        }
        i = 0;
        while (i < resolvedEntries.length) {
            entry = resolvedEntries[i];
            if (entry.getPath().toString().toLowerCase().contains("gwt-") && entry.getType() == 2 && countDupsGwtUser > 1 && entry.getPath().toString().toLowerCase().contains("gwt-user")) {
                String m = String.valueOf(message.replace("jar", "gwt-user.jar")) + " ::: path=" + entry.getPath();
                out.println(m);
            }
            ++i;
        }
    }

    public static interface IModuleClasspathProviderIdProvider {
        public String getProviderId(IProject var1);
    }
}

