/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch;

import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.launch.ModuleClasspathProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class ModuleClasspathProviderData
implements Comparable<ModuleClasspathProviderData> {
    public static final int DEFAULT_PRIORITY = 10;
    private ModuleClasspathProvider.IModuleClasspathProviderIdProvider provider;
    private int priority;

    public ModuleClasspathProviderData(IConfigurationElement config) {
        this.priority = this.convertInt(config.getAttribute("priority"));
        try {
            this.provider = (ModuleClasspathProvider.IModuleClasspathProviderIdProvider)config.createExecutableExtension("providerClass");
        }
        catch (CoreException e) {
            GWTPluginLog.logError("Unable to create classpath provider entry", new Object[]{e});
        }
    }

    @Override
    public int compareTo(ModuleClasspathProviderData other) {
        return this.getPriority() - other.getPriority();
    }

    public int getPriority() {
        return this.priority;
    }

    public ModuleClasspathProvider.IModuleClasspathProviderIdProvider getProvider() {
        return this.provider;
    }

    public boolean isProviderAvailable() {
        return this.provider != null;
    }

    private int convertInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return 10;
        }
    }
}

