/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch;

import com.google.gdt.eclipse.core.ResourceUtils;
import com.google.gdt.eclipse.core.WebAppUtilities;
import com.google.gdt.eclipse.core.launch.ILaunchShortcutStrategy;
import com.google.gwt.eclipse.core.launch.ui.WebAppHostPageSelectionDialog;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class WebAppLaunchShortcutStrategy
implements ILaunchShortcutStrategy {
    public String generateUrl(IResource selection, boolean isExternal) throws CoreException {
        IProject project = selection.getProject();
        WebAppUtilities.verifyIsWebApp((IProject)project);
        IFolder warFolder = WebAppUtilities.getWarSrc((IProject)project);
        if (warFolder == null) {
            throw new CoreException((IStatus)new Status(4, "com.gwtplugins.gwt.eclipse.core", "Couldn't find WAR folder."));
        }
        if (isExternal) {
            return this.getUrlFromUser(selection, isExternal);
        }
        if (ResourceUtils.hasJspOrHtmlExtension((IResource)selection)) {
            int warSegments = warFolder.getFullPath().segmentCount();
            IPath pathRelativeToWar = selection.getFullPath().removeFirstSegments(warSegments);
            return pathRelativeToWar.toString();
        }
        ArrayList<IResource> candidates = new ArrayList<IResource>();
        IResource[] iResourceArray = warFolder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (ResourceUtils.hasJspOrHtmlExtension((IResource)member)) {
                candidates.add(member);
            }
            ++n2;
        }
        if (candidates.isEmpty()) {
            return "";
        }
        if (candidates.size() == 1) {
            return ((IResource)candidates.get(0)).getName();
        }
        return this.getUrlFromUser(selection, isExternal);
    }

    public String getUrlFromUser(IResource resource, boolean isExternal) {
        IJavaProject javaProject = JavaCore.create((IProject)resource.getProject());
        return WebAppHostPageSelectionDialog.show(javaProject, isExternal);
    }
}

