/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.processors;

import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gdt.eclipse.core.console.CustomMessageConsole;
import com.google.gdt.eclipse.core.console.MessageConsoleUtilities;
import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gdt.eclipse.core.launch.LaunchConfigurationProcessorUtilities;
import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.launch.processors.GwtLaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.runtime.GWTProjectsRuntime;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class DGwtDevJarArgumentProcessor
implements ILaunchConfigurationProcessor {
    private static final String ARG_DGWT_DEVJAR = "-Dgwt.devjar=";

    private static String maybeGetDevJarPath(IJavaProject project) {
        GwtSdk sdk;
        block10: {
            block9: {
                if (!GWTProjectsRuntime.isGWTRuntimeProject(project)) break block9;
                GWTProjectsRuntime tempContribSDK = GWTProjectsRuntime.syntheziseContributorRuntime();
                if (((GwtSdk)tempContribSDK).validate().isOK()) {
                    return ((GwtSdk)tempContribSDK).getDevJar().getAbsolutePath();
                }
                return "";
            }
            sdk = GwtSdk.findSdkFor(project);
            if (sdk != null) break block10;
            CustomMessageConsole messageConsole = MessageConsoleUtilities.getMessageConsole((String)(String.valueOf(project.getProject().getName()) + "-GWT"), null);
            messageConsole.activate();
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
            final ConsoleColorProvider consoleColorProvider = new ConsoleColorProvider();
            final MessageConsoleStream console = messageConsole.newMessageStream();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    console.setColor(consoleColorProvider.getColor("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM"));
                }
            });
            console.println("GWT SDK not installed.");
            try {
                console.close();
            }
            catch (IOException e) {
                GWTPluginLog.logError(e, "Unable to close output stream to console");
            }
            return "";
        }
        try {
            if (sdk.usesGwtDevProject()) {
                File gwtDevJarFile = sdk.getDevJar();
                return gwtDevJarFile.getAbsolutePath();
            }
        }
        catch (Sdk.SdkException sdke) {
            GWTPluginLog.logError(sdke, "Unable to extract gwt dev jar argument from GWTProjectsRuntime");
        }
        catch (JavaModelException jme) {
            GWTPluginLog.logError(jme, "Unable to extract gwt dev jar argument from GWTProjectsRuntime");
        }
        return "";
    }

    public void update(ILaunchConfigurationWorkingCopy launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        String devJarPath;
        if (GwtLaunchConfigurationProcessorUtilities.isCompiler((ILaunchConfiguration)launchConfig)) {
            return;
        }
        int devJarIndex = StringUtilities.indexOfThatStartsWith(vmArgs, (String)ARG_DGWT_DEVJAR, (int)0);
        int insertionIndex = LaunchConfigurationProcessorUtilities.removeArgsAndReturnInsertionIndex(vmArgs, (int)devJarIndex, (boolean)false);
        if (GWTNature.isGWTProject(javaProject.getProject()) && !StringUtilities.isEmpty((String)(devJarPath = DGwtDevJarArgumentProcessor.maybeGetDevJarPath(javaProject)))) {
            vmArgs.add(insertionIndex, ARG_DGWT_DEVJAR + devJarPath);
        }
    }

    public String validate(ILaunchConfiguration launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        return null;
    }
}

