/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.processors;

import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gwt.eclipse.core.launch.GWTLaunchAttributes;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfigurationWorkingCopy;
import com.google.gwt.eclipse.core.launch.processors.GwtLaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.nature.GWTNature;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;

public class DevModeCodeServerPortArgumentProcessor
implements ILaunchConfigurationProcessor {
    public static final String CODE_SERVER_PORT_ARG = "-codeServerPort";
    private static final String CODE_SERVER_PORT_ERROR = "-codeServerPort must specify a valid port number or use 'auto'";

    public static String getPort(List<String> args) {
        int index = DevModeCodeServerPortArgumentProcessor.getArgIndex(args);
        if (index < 0 || index == args.size() - 1) {
            return (String)GWTLaunchAttributes.CLASSIC_DEVMODE_CODE_SERVER_PORT.getDefaultValue();
        }
        String port = args.get(index + 1);
        if (!DevModeCodeServerPortArgumentProcessor.validatePort(port)) {
            return (String)GWTLaunchAttributes.CLASSIC_DEVMODE_CODE_SERVER_PORT.getDefaultValue();
        }
        return port;
    }

    private static int getArgIndex(List<String> args) {
        return args.indexOf(CODE_SERVER_PORT_ARG);
    }

    private static boolean validatePort(String port) {
        if ("auto".equalsIgnoreCase(port)) {
            return true;
        }
        try {
            int valueNum = Integer.parseInt(port);
            return valueNum >= 0 && valueNum <= 65535;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void update(ILaunchConfigurationWorkingCopy launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        if (!GWTNature.isGWTProject(javaProject.getProject())) {
            return;
        }
        if (GwtLaunchConfigurationProcessorUtilities.isCompiler((ILaunchConfiguration)launchConfig)) {
            return;
        }
        int index = DevModeCodeServerPortArgumentProcessor.getArgIndex(programArgs);
        if (GwtLaunchConfigurationProcessorUtilities.isSuperDevModeCodeServer((ILaunchConfiguration)launchConfig)) {
            if (index > -1) {
                programArgs.remove(index);
                programArgs.remove(index);
            }
            return;
        }
        String port = GWTLaunchConfigurationWorkingCopy.getClassicDevModeCodeServerPort((ILaunchConfiguration)launchConfig);
        boolean auto = GWTLaunchConfigurationWorkingCopy.getClassicDevModeCodeServerPortAuto((ILaunchConfiguration)launchConfig);
        if (auto || !DevModeCodeServerPortArgumentProcessor.validatePort(port)) {
            port = "auto";
        }
        if (index < 0) {
            programArgs.add(0, CODE_SERVER_PORT_ARG);
            programArgs.add(1, port);
        } else if (index == programArgs.size() - 1) {
            programArgs.add(port);
        } else {
            String argValue = programArgs.get(index + 1);
            if (DevModeCodeServerPortArgumentProcessor.validatePort(argValue)) {
                programArgs.set(index + 1, port);
            } else {
                programArgs.add(index + 1, port);
            }
        }
    }

    public String validate(ILaunchConfiguration launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        int index = DevModeCodeServerPortArgumentProcessor.getArgIndex(programArgs);
        if (index < 0) {
            return null;
        }
        if (index == programArgs.size() - 1) {
            return CODE_SERVER_PORT_ERROR;
        }
        String value = programArgs.get(index + 1);
        if (value.equals("auto")) {
            return null;
        }
        if (!DevModeCodeServerPortArgumentProcessor.validatePort(value)) {
            return CODE_SERVER_PORT_ERROR;
        }
        return null;
    }
}

