/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.processors;

import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gdt.eclipse.core.launch.LaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfiguration;
import com.google.gwt.eclipse.core.nature.GWTNature;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;

public class LogLevelArgumentProcessor
implements ILaunchConfigurationProcessor {
    public static final String[] LOG_LEVELS = new String[]{"ERROR", "WARN", "INFO", "TRACE", "DEBUG", "SPAM", "ALL"};
    public static final String DEFAULT_LOG_LEVEL = "INFO";
    private static final String ARG_LOG_LEVEL = "-logLevel";

    public static String getValidLogLevel(List<String> args) {
        return LaunchConfigurationProcessorUtilities.getArgValueFromUpperCaseChoices(args, (String)ARG_LOG_LEVEL, (String[])LOG_LEVELS, (String)DEFAULT_LOG_LEVEL);
    }

    private static int getArgIndex(List<String> args) {
        return args.indexOf(ARG_LOG_LEVEL);
    }

    private static boolean isApplicable(ILaunchConfiguration config) throws CoreException {
        return "com.gwtplugins.gdt.eclipse.suite.webapp".equals(config.getType().getIdentifier());
    }

    public void update(ILaunchConfigurationWorkingCopy config, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        int insertionIndex = LaunchConfigurationProcessorUtilities.removeArgsAndReturnInsertionIndex(programArgs, (int)LogLevelArgumentProcessor.getArgIndex(programArgs), (boolean)true);
        String persistedLogLevel = GWTLaunchConfiguration.getLogLevel((ILaunchConfiguration)config);
        if (GWTNature.isGWTProject(javaProject.getProject()) && !StringUtilities.isEmpty((String)persistedLogLevel)) {
            programArgs.add(insertionIndex, ARG_LOG_LEVEL);
            programArgs.add(insertionIndex + 1, persistedLogLevel);
        }
    }

    public String validate(ILaunchConfiguration launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        if (!LogLevelArgumentProcessor.isApplicable(launchConfig)) {
            return null;
        }
        int logLevelArgIndex = LogLevelArgumentProcessor.getArgIndex(programArgs);
        if (logLevelArgIndex == -1) {
            return null;
        }
        if (!GWTNature.isGWTProject(javaProject.getProject())) {
            return "Log level argument is only valid for GWT projects";
        }
        String logLevel = LaunchConfigurationProcessorUtilities.getArgValue(programArgs, (int)(logLevelArgIndex + 1));
        if (StringUtilities.isEmpty((String)logLevel)) {
            return "Argument for specifying a log level is missing or invalid";
        }
        return null;
    }
}

