/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.processors;

import com.google.gdt.eclipse.core.extensions.ExtensionQuery;
import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfiguration;
import com.google.gwt.eclipse.core.modules.ModuleInfo;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.properties.GWTProjectProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;

public class ModuleArgumentProcessor
implements ILaunchConfigurationProcessor {
    public static List<String> getDefaultModules(IProject project, ILaunchConfiguration configuration) {
        List<String> modules = ModuleArgumentProcessor.getExtensionDefaultModules(project, configuration);
        if (modules.isEmpty()) {
            modules = GWTProjectProperties.getEntryPointModules(project);
        }
        return modules;
    }

    public static List<String> getModules(List<String> args, ILaunchConfiguration config, IProject project) throws CoreException {
        return ModuleParser.parse(args, ModuleArgumentProcessor.getAllPossibleModules(config, project)).modules;
    }

    private static boolean doesGwtMainTypeTakeModuleArguments(ILaunchConfiguration config) throws CoreException {
        return true;
    }

    private static Set<String> getAllPossibleModules(ILaunchConfiguration configuration, IProject project) throws CoreException {
        HashSet<String> possibleModules = new HashSet<String>();
        possibleModules.addAll(ModuleArgumentProcessor.getExtensionDefaultModules(project, configuration));
        possibleModules.addAll(GWTLaunchConfiguration.getEntryPointModules(configuration));
        possibleModules.addAll(GWTProjectProperties.getDefinedEntryPointModules(project));
        possibleModules.addAll(GWTProjectProperties.getDefaultEntryPointModules(project));
        return possibleModules;
    }

    private static List<String> getExtensionDefaultModules(IProject project, ILaunchConfiguration configuration) {
        ExtensionQuery extQuery = new ExtensionQuery("com.gwtplugins.gwt.eclipse.core", "moduleInfo", "class");
        List moduleInfos = extQuery.getData();
        Iterator iterator = moduleInfos.iterator();
        if (iterator.hasNext()) {
            ExtensionQuery.Data moduleInfo = (ExtensionQuery.Data)iterator.next();
            try {
                String[] startupModules = ((ModuleInfo)moduleInfo.getExtensionPointData()).getStartupModules(project, configuration);
                if (startupModules != null && startupModules.length > 0) {
                    return Arrays.asList(startupModules);
                }
            }
            catch (CoreException e) {
                GWTPluginLog.logError(e);
            }
        }
        return Collections.emptyList();
    }

    private static void removeModules(List<String> programArgs, ModuleParser parser, List<String> modulesToKeep) {
        int i = parser.moduleIndices.size() - 1;
        while (i >= 0) {
            int moduleIndex = (Integer)parser.moduleIndices.get(i);
            if (modulesToKeep == null || !modulesToKeep.contains(programArgs.get(moduleIndex))) {
                programArgs.remove(moduleIndex);
            }
            --i;
        }
    }

    public void update(ILaunchConfigurationWorkingCopy launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        IProject project = javaProject.getProject();
        List<String> persistedModules = GWTLaunchConfiguration.getEntryPointModules((ILaunchConfiguration)launchConfig);
        if (persistedModules.isEmpty()) {
            persistedModules = ModuleArgumentProcessor.getDefaultModules(project, (ILaunchConfiguration)launchConfig);
        }
        Set<String> possibleModules = ModuleArgumentProcessor.getAllPossibleModules((ILaunchConfiguration)launchConfig, project);
        ModuleParser parser = ModuleParser.parse(programArgs, possibleModules);
        if (!GWTNature.isGWTProject(project) || !ModuleArgumentProcessor.doesGwtMainTypeTakeModuleArguments((ILaunchConfiguration)launchConfig)) {
            ModuleArgumentProcessor.removeModules(programArgs, parser, null);
        } else {
            ModuleArgumentProcessor.removeModules(programArgs, parser, persistedModules);
            for (String module : persistedModules) {
                if (parser.modules.contains(module)) continue;
                programArgs.add(module);
            }
        }
    }

    public String validate(ILaunchConfiguration launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        return null;
    }

    private static class ModuleParser {
        private final List<Integer> moduleIndices;
        private final List<String> modules;

        private static ModuleParser parse(List<String> args, Set<String> possibleModules) {
            ArrayList<Integer> moduleIndices = new ArrayList<Integer>();
            ArrayList<String> modules = new ArrayList<String>();
            int i = args.size() - 1;
            while (i >= 0) {
                String arg = args.get(i);
                if (arg.startsWith("-")) break;
                if (possibleModules.contains(arg)) {
                    moduleIndices.add(i);
                    modules.add(arg);
                }
                --i;
            }
            return new ModuleParser(moduleIndices, modules);
        }

        private ModuleParser(List<Integer> moduleIndices, List<String> modules) {
            this.moduleIndices = moduleIndices;
            this.modules = modules;
            Collections.sort(moduleIndices);
        }
    }
}

