/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.processors;

import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gdt.eclipse.core.launch.LaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.launch.processors.GwtLaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.runtime.GwtCapabilityChecker;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;

public class RemoteUiArgumentProcessor
implements ILaunchConfigurationProcessor {
    public static final String ARG_REMOTE_UI = "-remoteUI";
    GwtCapabilityChecker.Factory gwtCapabilityCheckerFactory = new GwtCapabilityChecker.Factory();

    static boolean isUseRemoteUiEnvVarFalse(ILaunchConfiguration configuration) throws CoreException {
        String[] environmentVariables = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        if (environmentVariables != null) {
            String[] stringArray = environmentVariables;
            int n = environmentVariables.length;
            int n2 = 0;
            while (n2 < n) {
                String environmentVariable = stringArray[n2];
                if (environmentVariable.matches("\\s*USE_REMOTE_UI\\s*=\\s*false\\s*")) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean shouldUseRemoteUI(ILaunchConfiguration configuration) throws CoreException {
        return !RemoteUiArgumentProcessor.isUseRemoteUiEnvVarFalse(configuration) && !GwtLaunchConfigurationProcessorUtilities.isSuperDevModeCodeServer(configuration);
    }

    public void update(ILaunchConfigurationWorkingCopy launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        if (!GWTNature.isGWTProject(javaProject.getProject())) {
            return;
        }
        if (GwtLaunchConfigurationProcessorUtilities.isCompiler((ILaunchConfiguration)launchConfig)) {
            return;
        }
        int index = programArgs.indexOf(ARG_REMOTE_UI);
        String remoteUiValue = null;
        if (index >= 0) {
            remoteUiValue = LaunchConfigurationProcessorUtilities.getArgValue(programArgs, (int)(index + 1));
        }
        if (StringUtilities.isEmpty(remoteUiValue)) {
            remoteUiValue = "${gwt_remote_ui_server_port}:${unique_id}";
        }
        int insertionIndex = LaunchConfigurationProcessorUtilities.removeArgsAndReturnInsertionIndex(programArgs, (int)index, (boolean)true);
        IProject project = javaProject.getProject();
        if (GWTNature.isGWTProject(project) && RemoteUiArgumentProcessor.shouldUseRemoteUI((ILaunchConfiguration)launchConfig)) {
            programArgs.add(insertionIndex, ARG_REMOTE_UI);
            programArgs.add(insertionIndex + 1, remoteUiValue);
        }
    }

    public String validate(ILaunchConfiguration launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) {
        return null;
    }
}

