/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.processors;

import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gdt.eclipse.core.collections.ListUtilities;
import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gdt.eclipse.core.launch.LaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfiguration;
import com.google.gwt.eclipse.core.launch.processors.GwtLaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.nature.GWTNature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;

public class StartupUrlArgumentProcessor
implements ILaunchConfigurationProcessor {
    private static final String ARG_STARTUP_URL = "-startupUrl";

    public static String getStartupUrl(List<String> args, ILaunchConfiguration config) throws CoreException {
        String startupUrl = null;
        try {
            startupUrl = GWTLaunchConfiguration.getStartupUrl(config);
        }
        catch (CoreException e) {
            GWTPluginLog.logWarning(e, "Could not get persisted startup URL");
        }
        StartupUrlParser parser = StartupUrlParser.parse(args, startupUrl, config);
        return parser.startupUrls.isEmpty() ? null : parser.startupUrls.get(0);
    }

    private static int findStartupUrlFromGwtShellArgs(List<String> args) {
        HashMap<String, Integer> allGwtShellArgs = new HashMap<String, Integer>();
        allGwtShellArgs.put("-ea", 0);
        allGwtShellArgs.put("-noserver", 0);
        allGwtShellArgs.put("-port", 1);
        allGwtShellArgs.put("-whitelist", 1);
        allGwtShellArgs.put("-blacklist", 1);
        allGwtShellArgs.put("-logLevel", 1);
        allGwtShellArgs.put("-gen", 1);
        allGwtShellArgs.put("-out", 1);
        allGwtShellArgs.put("-style", 1);
        allGwtShellArgs.put("-logdir", 1);
        allGwtShellArgs.put("-codeServerPort", 1);
        allGwtShellArgs.put("-remoteUI", 1);
        int i = 0;
        while (i < args.size()) {
            String arg = args.get(i);
            Integer argsToSkip = (Integer)allGwtShellArgs.get(arg);
            if (argsToSkip == null && i == args.size() - 1) {
                return i;
            }
            if (argsToSkip != null) {
                i += argsToSkip.intValue();
            }
            ++i;
        }
        return -1;
    }

    private static void removeStartupUrlForGwtShell(List<String> args, StartupUrlParser parser) {
        if (parser.gwtShellStyleStartupUrlIndex != -1) {
            args.remove(parser.gwtShellStyleStartupUrlIndex);
        }
    }

    private static int removeStartupUrlsWithStartupUrlArg(List<String> args, StartupUrlParser parser, boolean removeOnlyFirst) {
        int insertionIndex = -1;
        for (Integer argIndex : parser.startupUrlArgIndices) {
            int curInsertionIndex = LaunchConfigurationProcessorUtilities.removeArgsAndReturnInsertionIndex(args, (int)argIndex, (boolean)true);
            if (insertionIndex == -1) {
                insertionIndex = curInsertionIndex;
            }
            if (!removeOnlyFirst) continue;
            return insertionIndex;
        }
        return insertionIndex == -1 ? 0 : insertionIndex;
    }

    public void update(ILaunchConfigurationWorkingCopy launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        if (GwtLaunchConfigurationProcessorUtilities.isCompiler((ILaunchConfiguration)launchConfig)) {
            return;
        }
        String persistedStartupUrl = GWTLaunchConfiguration.getStartupUrl((ILaunchConfiguration)launchConfig);
        StartupUrlParser parser = StartupUrlParser.parse(programArgs, persistedStartupUrl, (ILaunchConfiguration)launchConfig);
        if (!GWTNature.isGWTProject(javaProject.getProject())) {
            StartupUrlArgumentProcessor.removeStartupUrlForGwtShell(programArgs, parser);
            StartupUrlArgumentProcessor.removeStartupUrlsWithStartupUrlArg(programArgs, parser, false);
        } else {
            StartupUrlArgumentProcessor.removeStartupUrlForGwtShell(programArgs, parser);
            int insertionIndex = StartupUrlArgumentProcessor.removeStartupUrlsWithStartupUrlArg(programArgs, parser, true);
            if (!StringUtilities.isEmpty((String)persistedStartupUrl)) {
                programArgs.add(insertionIndex, ARG_STARTUP_URL);
                programArgs.add(insertionIndex + 1, persistedStartupUrl);
            }
        }
    }

    public String validate(ILaunchConfiguration launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        return null;
    }

    private static class StartupUrlParser {
        public final List<String> startupUrls;
        public final List<Integer> startupUrlArgIndices;
        public final int gwtShellStyleStartupUrlIndex;

        static StartupUrlParser parse(List<String> args, String persistedStartupUrl, ILaunchConfiguration config) throws CoreException {
            ArrayList<String> startupUrls = new ArrayList<String>();
            List<Integer> startupUrlArgIndices = StartupUrlParser.findStartupUrlArgIndices(args);
            for (Integer startupUrlArgIndex : startupUrlArgIndices) {
                String startupUrl = LaunchConfigurationProcessorUtilities.getArgValue(args, (int)(startupUrlArgIndex + 1));
                if (startupUrl == null) continue;
                startupUrls.add(startupUrl);
            }
            int gwtShellStyleStartupUrlIndex = -1;
            if (startupUrls.isEmpty()) {
                if (!StringUtilities.isEmpty((String)persistedStartupUrl)) {
                    gwtShellStyleStartupUrlIndex = args.lastIndexOf(persistedStartupUrl);
                }
                if (gwtShellStyleStartupUrlIndex >= 0) {
                    startupUrls.add(args.get(gwtShellStyleStartupUrlIndex));
                }
            }
            return new StartupUrlParser(startupUrls, startupUrlArgIndices, gwtShellStyleStartupUrlIndex);
        }

        private static List<Integer> findStartupUrlArgIndices(List<String> args) {
            int startupUrlArgIndex;
            ArrayList<Integer> startupUrlArgIndices = new ArrayList<Integer>();
            int searchBeginIndex = 0;
            while ((startupUrlArgIndex = ListUtilities.indexOf(args, (Object)StartupUrlArgumentProcessor.ARG_STARTUP_URL, (int)searchBeginIndex)) != -1) {
                startupUrlArgIndices.add(startupUrlArgIndex);
                searchBeginIndex = startupUrlArgIndex + 1;
            }
            return startupUrlArgIndices;
        }

        public StartupUrlParser(List<String> startupUrls, List<Integer> startupUrlArgIndices, int gwtShellStartupUrlIndex) {
            this.startupUrls = startupUrls;
            this.startupUrlArgIndices = startupUrlArgIndices;
            this.gwtShellStyleStartupUrlIndex = gwtShellStartupUrlIndex;
        }
    }
}

