/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.processors;

import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfigurationWorkingCopy;
import com.google.gwt.eclipse.core.launch.GWTLaunchConstants;
import com.google.gwt.eclipse.core.launch.processors.GwtLaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.modules.IModule;
import com.google.gwt.eclipse.core.modules.ModuleUtils;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.util.GwtVersionUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class SuperDevModeArgumentProcessor
implements ILaunchConfigurationProcessor {
    public static final String ERROR_NO_JAR_CODESERVER = "Add gwt-codeserver.jar to the classpath.";
    public static final String ERROR_NO_JAR_GWTDEV = "Add gwt-dev.jar to the classpath.";
    public static final String ERROR_NO_LEGACY_LAUNCHER_JAR = "Add the super dev mode legacy jar for 2.5.0 to < 2.7 jar, superdevmode-launcher-legacy.jar to the classpath.";
    public static final String ERROR_NO_LINKER = "Add super dev mode linker <add-linker name=\"xsiframe\" /> to project module.";
    public static final String ERROR_NO_LINKER_NOSOURCEMAP = "Add <set-property name=\"compiler.useSourceMaps\" value=\"true\" /> to project module.";
    public static final String ERROR_NO_LINKER_REDIRECT = "Add <set-configuration-property name=\"devModeRedirectEnabled\" value=\"true\"/> to project module.";
    public static final String ERRORS = "Errors exist:";
    public static final String SUPERDEVMODE_ENABLED_ARG = "-superDevMode";
    public static final String SUPERDEVMODE_DISABLED_ARG = "-nosuperDevMode";

    public void update(ILaunchConfigurationWorkingCopy launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        if (!GWTNature.isGWTProject(javaProject.getProject())) {
            return;
        }
        if (GwtLaunchConfigurationProcessorUtilities.isCompiler((ILaunchConfiguration)launchConfig)) {
            return;
        }
        String gwtVersion = GwtVersionUtil.getProjectGwtVersion(javaProject);
        boolean superDevModeEnabled = GWTLaunchConfigurationWorkingCopy.getSuperDevModeEnabled((ILaunchConfiguration)launchConfig);
        int indexEnabled = programArgs.indexOf(SUPERDEVMODE_ENABLED_ARG);
        int indexDisabled = programArgs.indexOf(SUPERDEVMODE_DISABLED_ARG);
        if (GwtVersionUtil.isGwtVersionlessThan25(javaProject)) {
            this.updateLessThanGwt25(programArgs, indexDisabled, indexEnabled);
        } else if (GWTLaunchConstants.SUPERDEVMODE_LAUNCH_LEGACY_VERSIONS.contains(gwtVersion)) {
            this.updateGwt25toLessThan27(programArgs, indexDisabled, indexEnabled, superDevModeEnabled);
        } else {
            this.updateGwt27On(javaProject, programArgs, indexDisabled, indexEnabled, superDevModeEnabled);
        }
    }

    public String validate(ILaunchConfiguration launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        String error;
        String gwtVersion = GwtVersionUtil.getProjectGwtVersion(javaProject);
        ArrayList<String> errors = new ArrayList<String>();
        if (GwtVersionUtil.isGwtVersionlessThan25(javaProject)) {
            return null;
        }
        if (GWTLaunchConstants.SUPERDEVMODE_LAUNCH_LEGACY_VERSIONS.contains(gwtVersion) && (error = this.validateSuperDevModeLinkerExists(javaProject, launchConfig)) != null) {
            errors.add(error);
        }
        if (errors.size() > 0) {
            return "Errors exist: " + StringUtilities.join(errors, (String)", ");
        }
        return null;
    }

    private void updateLessThanGwt25(List<String> programArgs, int indexDisabled, int indexEnabled) {
        if (indexDisabled > -1) {
            programArgs.remove(indexDisabled);
        }
        if (indexEnabled > -1) {
            programArgs.remove(indexEnabled);
        }
    }

    private void updateGwt25toLessThan27(List<String> programArgs, int indexDisabled, int indexEnabled, boolean superDevModeEnabled) {
        if (indexEnabled > -1) {
            programArgs.remove(indexEnabled);
        }
        if (indexDisabled > -1) {
            programArgs.remove(indexDisabled);
        }
        if (superDevModeEnabled) {
            programArgs.add(0, SUPERDEVMODE_ENABLED_ARG);
        }
    }

    private void updateGwt27On(IJavaProject javaProject, List<String> programArgs, int indexDisabled, int indexEnabled, boolean superDevModeEnabled) {
        if (indexEnabled > -1) {
            programArgs.remove(indexEnabled);
        }
        if (indexDisabled > -1) {
            programArgs.remove(indexDisabled);
        }
        if (!superDevModeEnabled) {
            programArgs.add(0, SUPERDEVMODE_DISABLED_ARG);
        }
    }

    private String validateGwtDev(IJavaProject javaProject) {
        boolean alreadyExists = false;
        try {
            IType type = javaProject.findType("com.google.gwt.dev.About");
            if (type != null) {
                alreadyExists = true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (!alreadyExists) {
            return ERROR_NO_JAR_GWTDEV;
        }
        return null;
    }

    private String validateSuperDevModeLinkerExists(IJavaProject javaProject, ILaunchConfiguration configuration) {
        List<String> modules;
        block5: {
            modules = GWTLaunchConfigurationWorkingCopy.getEntryPointModules(configuration);
            if (modules != null && !modules.isEmpty()) break block5;
            return ERROR_NO_LINKER;
        }
        try {
            ArrayList<String> errors = new ArrayList<String>();
            for (String module : modules) {
                String error;
                IModule imodule = ModuleUtils.findModule(javaProject, module, false);
                if (imodule == null || (error = this.validateModule(imodule, javaProject, configuration)) == null) continue;
                errors.add(error);
            }
            if (errors.size() > 0) {
                return StringUtilities.join(errors, (String)", ");
            }
        }
        catch (CoreException e) {
            return ERROR_NO_LINKER;
        }
        return null;
    }

    private String validateModule(IModule imodule, IJavaProject javaProject, ILaunchConfiguration configuration) {
        List<String> linkers = imodule.getAddLinkers();
        List<String> redirects = imodule.getSetConfigurationProperty("devModeRedirectEnabled");
        List<String> useSourceMaps = imodule.getSetConfigurationProperty("compiler.useSourceMaps");
        String gwtVersion = GwtVersionUtil.getProjectGwtVersion(javaProject);
        boolean legacySuperDevModePossibleForGwtVersion = GWTLaunchConstants.SUPERDEVMODE_LAUNCH_LEGACY_VERSIONS.contains(gwtVersion);
        ArrayList<String> errors = new ArrayList<String>();
        if (legacySuperDevModePossibleForGwtVersion && (linkers == null || linkers.indexOf("xsiframe") < 0)) {
            errors.add(ERROR_NO_LINKER);
        }
        if (gwtVersion.contains("2.5") && redirects == null) {
            errors.add(ERROR_NO_LINKER_REDIRECT);
        } else if (gwtVersion.contains("2.5") && redirects != null) {
            for (String redirect : redirects) {
                if (!redirect.toLowerCase().equals("false")) continue;
                errors.add(ERROR_NO_LINKER_REDIRECT);
                break;
            }
            for (String useSourceMap : useSourceMaps) {
                if (!useSourceMap.toLowerCase().equals("false")) continue;
                errors.add(ERROR_NO_LINKER_NOSOURCEMAP);
                break;
            }
        }
        if (errors.size() > 0) {
            return StringUtilities.join(errors, (String)", ");
        }
        return null;
    }
}

