/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.processors;

import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import com.google.gwt.eclipse.core.util.Util;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class XStartOnFirstThreadArgumentProcessor
implements ILaunchConfigurationProcessor {
    private static final String ARG_XSTART_ON_FIRST_THREAD = "-XstartOnFirstThread";
    private static final String ATTR_XSTART_ON_FIRST_THREAD = "org.eclipse.jdt.launching.ATTR_USE_START_ON_FIRST_THREAD";

    private static boolean needsStartOnFirstThreadHack(IJavaProject javaProject, ILaunchConfiguration config) throws CoreException {
        if (!Util.isPlatformMac()) {
            return false;
        }
        GwtSdk sdk = GwtSdk.findSdkFor(javaProject);
        if (sdk == null || !sdk.validate().isOK()) {
            GWTPluginLog.logWarning(String.format("Could not check whether the launch configuration \"%1$s\" needs the -XstartOnFirstThread argument, assuming it does", config.getName()));
            return true;
        }
        return true;
    }

    public void update(ILaunchConfigurationWorkingCopy launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.platform");
        if (bundle != null) {
            Version bundleVersion = bundle.getVersion();
            if (bundleVersion.getMajor() == 4 && bundleVersion.getMinor() >= 3) {
                this.updateEclipse43(launchConfig, javaProject, programArgs, vmArgs);
            } else {
                this.updateNonEclipse43(launchConfig, javaProject, programArgs, vmArgs);
            }
        }
    }

    public String validate(ILaunchConfiguration launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        return null;
    }

    private void updateEclipse43(ILaunchConfigurationWorkingCopy launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        boolean startOnFirstThread = launchConfig.getAttribute(ATTR_XSTART_ON_FIRST_THREAD, false);
        if (XStartOnFirstThreadArgumentProcessor.needsStartOnFirstThreadHack(javaProject, (ILaunchConfiguration)launchConfig)) {
            if (!startOnFirstThread) {
                launchConfig.setAttribute(ATTR_XSTART_ON_FIRST_THREAD, true);
                launchConfig.doSave();
            }
        } else if (startOnFirstThread) {
            launchConfig.removeAttribute(ATTR_XSTART_ON_FIRST_THREAD);
            launchConfig.doSave();
        }
    }

    private void updateNonEclipse43(ILaunchConfigurationWorkingCopy launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        int argIndex = vmArgs.indexOf(ARG_XSTART_ON_FIRST_THREAD);
        if (XStartOnFirstThreadArgumentProcessor.needsStartOnFirstThreadHack(javaProject, (ILaunchConfiguration)launchConfig)) {
            if (argIndex == -1) {
                vmArgs.add(0, ARG_XSTART_ON_FIRST_THREAD);
            }
        } else if (argIndex >= 0) {
            vmArgs.remove(argIndex);
        }
    }
}

