/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.processors.codeserver;

import com.google.gdt.eclipse.core.WebAppUtilities;
import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gdt.eclipse.core.launch.LaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfiguration;
import com.google.gwt.eclipse.core.launch.processors.GwtLaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.nature.GWTNature;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;

public class SuperDevModeCodeServerLauncherDirArgumentProcessor
implements ILaunchConfigurationProcessor {
    public static final String LAUNCHERDIR_ARG = "-launcherDir";

    public void update(ILaunchConfigurationWorkingCopy launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        IPath path;
        if (!GWTNature.isGWTProject(javaProject.getProject())) {
            return;
        }
        if (GwtLaunchConfigurationProcessorUtilities.isCompiler((ILaunchConfiguration)launchConfig)) {
            return;
        }
        if (!GwtLaunchConfigurationProcessorUtilities.isSuperDevModeCodeServer((ILaunchConfiguration)launchConfig)) {
            return;
        }
        int argIndex = programArgs.indexOf(LAUNCHERDIR_ARG);
        if (argIndex > -1) {
            return;
        }
        String pathToWarOutDir = null;
        String launcherDir = GWTLaunchConfiguration.getSuperDevModeCodeServerLauncherDir((ILaunchConfiguration)launchConfig);
        if (launcherDir != null) {
            pathToWarOutDir = launcherDir;
        }
        if (pathToWarOutDir == null && (path = WebAppUtilities.getWarOutLocationOrPrompt((IProject)javaProject.getProject())) != null) {
            pathToWarOutDir = path.toFile().getAbsolutePath();
        }
        if (pathToWarOutDir == null || pathToWarOutDir.isEmpty()) {
            String msg = "SuperDevModeCodeServerLauncherDirArgumentProcessor > update: couldn't determine pathtoWarOutDir.";
            GWTPluginLog.logWarning(msg);
            return;
        }
        int insertionIndex = LaunchConfigurationProcessorUtilities.removeArgsAndReturnInsertionIndex(programArgs, (int)argIndex, (boolean)true);
        programArgs.add(insertionIndex, LAUNCHERDIR_ARG);
        programArgs.add(insertionIndex + 1, pathToWarOutDir);
    }

    public String validate(ILaunchConfiguration launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        return null;
    }
}

