/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.processors.codeserver;

import com.google.gdt.eclipse.core.CorePluginLog;
import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gdt.eclipse.core.launch.LaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.nature.GWTNature;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class SuperDevModeCodeServerMainTypeProcessor
implements ILaunchConfigurationProcessor {
    private static final String ATTR_PREVIOUSLY_SET_MAIN_TYPE_NAME = "com.gwtplugins.gwt.eclipse.coreMainTypeProcessor.PREVIOUSLY_SET_MAIN_TYPE_NAME";

    public static boolean isMainTypeFromSdk(ILaunchConfiguration config) throws CoreException {
        String mainTypeName = LaunchConfigurationProcessorUtilities.getMainTypeName((ILaunchConfiguration)config);
        MainType[] mainTypeArray = MainType.values();
        int n = mainTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MainType sdkMainType = mainTypeArray[n2];
            if (sdkMainType.mainTypeName.equals(mainTypeName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String getPreviouslySetMainTypeName(ILaunchConfiguration config) {
        try {
            return config.getAttribute(ATTR_PREVIOUSLY_SET_MAIN_TYPE_NAME, null);
        }
        catch (CoreException e) {
            CorePluginLog.logError((Throwable)e, (String)"Could not restore previously set main type, forcing overwrite.");
            return null;
        }
    }

    private static void setMainTypeName(ILaunchConfigurationWorkingCopy config, String mainType) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainType);
        config.setAttribute(ATTR_PREVIOUSLY_SET_MAIN_TYPE_NAME, mainType);
    }

    public void update(ILaunchConfigurationWorkingCopy config, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        String currentMainTypeName = LaunchConfigurationProcessorUtilities.getMainTypeName((ILaunchConfiguration)config);
        String previouslySetMainTypeName = SuperDevModeCodeServerMainTypeProcessor.getPreviouslySetMainTypeName((ILaunchConfiguration)config);
        if (!StringUtilities.isEmpty((String)currentMainTypeName) && !currentMainTypeName.equals(previouslySetMainTypeName)) {
            return;
        }
        String newMainTypeName = null;
        IProject project = javaProject.getProject();
        if (GWTNature.isGWTProject(project)) {
            newMainTypeName = MainType.GWT_SDM_MODE.mainTypeName;
        }
        if (StringUtilities.isEmpty(newMainTypeName) || newMainTypeName.equals(currentMainTypeName)) {
            return;
        }
        SuperDevModeCodeServerMainTypeProcessor.setMainTypeName(config, newMainTypeName);
    }

    public String validate(ILaunchConfiguration config, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) {
        return null;
    }

    public static enum MainType {
        GWT_SDM_MODE("com.google.gwt.dev.codeserver.CodeServer");

        public final String mainTypeName;

        private MainType(String mainTypeName) {
            this.mainTypeName = mainTypeName;
        }
    }

    public static interface MainTypeFinder {
        public String findMainType(IJavaProject var1);
    }
}

