/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.processors.codeserver;

import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gdt.eclipse.core.launch.LaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.launch.GWTLaunchAttributes;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfigurationWorkingCopy;
import com.google.gwt.eclipse.core.launch.processors.GwtLaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.nature.GWTNature;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;

public class SuperDevModeCodeServerPortArgumentProcessor
implements ILaunchConfigurationProcessor {
    public static final String SDM_CODE_SERVER_PORT_ARG = "-port";
    private static final String SDM_CODE_SERVER_PORT_ERROR = "-port must specify a valid port number";

    public static String getPort(List<String> args) {
        int index = SuperDevModeCodeServerPortArgumentProcessor.getArgIndex(args);
        if (index < 0 || index == args.size() - 1) {
            return (String)GWTLaunchAttributes.SDM_CODE_SERVER_PORT.getDefaultValue();
        }
        String port = args.get(index + 1);
        if (!SuperDevModeCodeServerPortArgumentProcessor.validatePort(port)) {
            return (String)GWTLaunchAttributes.SDM_CODE_SERVER_PORT.getDefaultValue();
        }
        return port;
    }

    private static int getArgIndex(List<String> args) {
        return args.indexOf(SDM_CODE_SERVER_PORT_ARG);
    }

    private static boolean validatePort(String port) {
        try {
            int valueNum = Integer.parseInt(port);
            return valueNum >= 0 && valueNum <= 65535;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void update(ILaunchConfigurationWorkingCopy launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        if (!GWTNature.isGWTProject(javaProject.getProject())) {
            return;
        }
        if (GwtLaunchConfigurationProcessorUtilities.isCompiler((ILaunchConfiguration)launchConfig)) {
            return;
        }
        String mainType = GWTLaunchConfigurationWorkingCopy.getMainType(launchConfig);
        if (mainType != null && !mainType.contains("CodeServer")) {
            return;
        }
        int insertionIndex = LaunchConfigurationProcessorUtilities.removeArgsAndReturnInsertionIndex(programArgs, (int)SuperDevModeCodeServerPortArgumentProcessor.getArgIndex(programArgs), (boolean)true);
        String port = GWTLaunchConfigurationWorkingCopy.getSdmCodeServerPort((ILaunchConfiguration)launchConfig);
        if (!SuperDevModeCodeServerPortArgumentProcessor.validatePort(port)) {
            port = GWTLaunchAttributes.SDM_CODE_SERVER_PORT.getDefaultValue().toString();
        }
        programArgs.add(insertionIndex, SDM_CODE_SERVER_PORT_ARG);
        programArgs.add(insertionIndex + 1, port);
    }

    public String validate(ILaunchConfiguration launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        int index = SuperDevModeCodeServerPortArgumentProcessor.getArgIndex(programArgs);
        if (index < 0) {
            return null;
        }
        if (index == programArgs.size() - 1) {
            return SDM_CODE_SERVER_PORT_ERROR;
        }
        String value = programArgs.get(index + 1);
        if (!SuperDevModeCodeServerPortArgumentProcessor.validatePort(value)) {
            return SDM_CODE_SERVER_PORT_ERROR;
        }
        return null;
    }
}

