/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.processors.codeserver;

import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gdt.eclipse.core.launch.LaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.launch.processors.GwtLaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.nature.GWTNature;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class SuperDevModeSrcArgumentProcessor
implements ILaunchConfigurationProcessor {
    public static final String SRC_ARG = "-src";

    private static int getArgIndex(List<String> args) {
        return args.indexOf(SRC_ARG);
    }

    public void update(ILaunchConfigurationWorkingCopy launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        if (!GWTNature.isGWTProject(javaProject.getProject())) {
            return;
        }
        if (!GwtLaunchConfigurationProcessorUtilities.isSuperDevModeCodeServer((ILaunchConfiguration)launchConfig)) {
            return;
        }
        if (GwtLaunchConfigurationProcessorUtilities.isCompiler((ILaunchConfiguration)launchConfig)) {
            return;
        }
        int srcArgIndex = SuperDevModeSrcArgumentProcessor.getArgIndex(programArgs);
        String srcDirs = null;
        if (srcArgIndex >= 0) {
            srcDirs = LaunchConfigurationProcessorUtilities.getArgValue(programArgs, (int)(srcArgIndex + 1));
        }
        if (StringUtilities.isEmpty(srcDirs)) {
            srcDirs = this.getSrcDirectories(javaProject);
        }
        int insertionIndex = LaunchConfigurationProcessorUtilities.removeArgsAndReturnInsertionIndex(programArgs, (int)srcArgIndex, (boolean)true);
        programArgs.add(insertionIndex, SRC_ARG);
        programArgs.add(insertionIndex + 1, srcDirs);
    }

    public String validate(ILaunchConfiguration launchConfig, IJavaProject javaProject, List<String> programArgs, List<String> vmArgs) throws CoreException {
        return null;
    }

    private String getPathIfDir(IJavaProject javaProject, IClasspathEntry entry) {
        String dir;
        IPath p = entry.getPath();
        String projectName = javaProject.getProject().getName();
        String path = null;
        if (entry.getEntryKind() == 3 && (entry.getOutputLocation() == null || entry.getOutputLocation() != null && !entry.getOutputLocation().lastSegment().toString().equals("test-classes")) && (dir = p.toString()).contains(projectName)) {
            IPath relative = p.removeFirstSegments(1);
            path = relative.toString();
        }
        return path;
    }

    private String getSrcDirectories(IJavaProject javaProject) {
        String src = "";
        IClasspathEntry[] cp = null;
        try {
            cp = javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        if (cp == null || cp.length == 0) {
            return "REPLACE_ME_WITH_src_dir";
        }
        int i = 0;
        while (i < cp.length) {
            String path = this.getPathIfDir(javaProject, cp[i]);
            if (path != null && src.length() == 0) {
                src = path;
            } else if (path != null && src.length() > 0) {
                src = String.valueOf(src) + " -src " + path;
            }
            ++i;
        }
        if (src.length() == 0) {
            src = "REPLACE_ME_WITH_src_dir";
        }
        return src;
    }
}

